/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3;

import eu.ewerkzeug.easytranscript3.Bootstrap;
import eu.ewerkzeug.easytranscript3.commons.RuntimeUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javafx.scene.control.Alert;
import lombok.Generated;
import org.apache.commons.exec.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Bootstrap {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private static final String RELATIVE_MAC_JNA_LIB_PATH = "Contents/Resources";

    private Bootstrap() {
    }

    protected static void start() {
        Bootstrap.greeting();
        Bootstrap.getSystemInformation();
        Bootstrap.checkDirectoryStructure();
        Bootstrap.prepareJNA();
        Bootstrap.uploadQueuedLogs();
    }

    private static void prepareJNA() {
        log.debug("Preparing jna ...");
        log.debug("Is MacOS: {}", (Object)OS.isFamilyMac());
        Path path = Paths.get("Contents/Resources", new String[0]);
        log.debug("Does jna lib exists relative to jar: {}", (Object)Files.exists(path, new LinkOption[0]));
        try {
            log.debug("JNA Lib search path: {}", (Object)path.toFile().getCanonicalPath());
        }
        catch (IOException e) {
            log.debug("JNA Lib search path is invalid.");
        }
        log.debug("Current Path: {}", (Object)Paths.get("", new String[0]).toAbsolutePath());
        if (OS.isFamilyMac() && Files.exists(path, new LinkOption[0])) {
            System.setProperty("jna.nosys", "true");
            System.setProperty("jna.nounpack", "true");
            System.setProperty("jna.noclasspath", "true");
            System.setProperty("jna.debug_load.jna", "true");
            System.setProperty("jna.boot.library.path", "Contents/Resources");
        }
    }

    private static void getSystemInformation() {
        File[] roots;
        Runtime runtime = Runtime.getRuntime();
        log.info("Java Home: {}", (Object)System.getProperty("java.home"));
        log.info("Java Version: {}", (Object)System.getProperty("java.version"));
        log.info("Java Vendor: {}", (Object)System.getProperty("java.vendor"));
        log.info("Java Architecture: {}", (Object)System.getProperty("os.arch"));
        log.info("Java Image Type: {} (bundled: {})", (Object)RuntimeUtils.getRuntimeProperties().getProperty(RuntimeUtils.ReleaseKey.IMAGE_TYPE.name()), (Object)RuntimeUtils.isBundledJRE());
        log.info("OS Name: {}", (Object)System.getProperty("os.name"));
        log.info("OS Version: {}", (Object)System.getProperty("os.version"));
        log.info("User Home: {}", (Object)System.getProperty("user.home"));
        log.info("User Directory: {}", (Object)System.getProperty("user.dir"));
        log.info("ET Home: {}", (Object)Configuration.ET_HOME);
        log.info("Memory (Used, Total, Max): {} MB/ {} MB/ {}MB", new Object[]{(runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L, runtime.maxMemory() / 0x100000L});
        log.info("CPU Cores: {}", (Object)Runtime.getRuntime().availableProcessors());
        for (File root : roots = File.listRoots()) {
            log.info("File system root: {}", (Object)root.getAbsolutePath());
            log.info("Total space (bytes): {} MB", (Object)(root.getTotalSpace() / 1024L / 1024L));
            log.info("Free space (bytes): {} MB", (Object)(root.getFreeSpace() / 1024L / 1024L));
            log.info("Usable space (bytes): {} MB", (Object)(root.getUsableSpace() / 1024L / 1024L));
        }
    }

    private static void greeting() {
        log.info("easytranscript Version {} ({}), Build {}", new Object[]{Configuration.get().getVersion(), Configuration.get().getChannel(), Configuration.get().getCommitIdOfVersion()});
        Locale.setDefault(Locale.forLanguageTag(Configuration.get().getProgramLanguage()));
        log.debug(Configuration.get().toString());
    }

    private static void uploadQueuedLogs() {
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        CompletableFuture.runAsync((Runnable)task);
    }

    private static void checkDirectoryStructure() {
        log.info("Checking directory structure ...");
        try {
            IOException e;
            Path core = Path.of(Configuration.ET_HOME, new String[0]);
            Path logs = Path.of(Configuration.ET_HOME + "/logs", new String[0]);
            Path backups = Path.of(Configuration.ET_HOME + "/backups", new String[0]);
            Files.createDirectories(core, new FileAttribute[0]);
            Files.createDirectories(logs, new FileAttribute[0]);
            Files.createDirectories(backups, new FileAttribute[0]);
            if (!Files.isWritable(core)) {
                e = new IOException(String.valueOf(core) + " " + Utils.getLocaleBundle().getString("general.notWritable"));
                log.error("", (Throwable)e);
                ETDialog.get((String)e.getMessage(), (Alert.AlertType)Alert.AlertType.ERROR).showAndWait();
            }
            if (!Files.isWritable(logs)) {
                e = new IOException(String.valueOf(logs) + " " + Utils.getLocaleBundle().getString("general.notWritable"));
                log.error("", (Throwable)e);
                ETDialog.get((String)e.getMessage(), (Alert.AlertType)Alert.AlertType.ERROR).showAndWait();
            }
            if (!Files.isWritable(backups)) {
                e = new IOException(String.valueOf(backups) + " " + Utils.getLocaleBundle().getString("general.notWritable"));
                log.error("", (Throwable)e);
                ETDialog.get((String)e.getMessage(), (Alert.AlertType)Alert.AlertType.ERROR).showAndWait();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
        log.info("... Done.");
    }
}

