/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3;

import eu.ewerkzeug.easytranscript3.Bootstrap;
import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.StageReadyEvent;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.migrations.MigrationService;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxWeaver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PrimaryStageInitializer
implements ApplicationListener<StageReadyEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrimaryStageInitializer.class);
    private final FxWeaver fxWeaver;
    private final MigrationService migrationService;
    private final ExecutorService executorService;

    public void onApplicationEvent(@NotNull StageReadyEvent event) {
        Bootstrap.start();
        this.executorService.submit(Utils::deleteAllLeftOverTempFiles);
        this.migrationService.runProgramMigrations();
        log.debug("Setting main stage ...");
        GUIState.setMainStage((Stage)event.stage);
        ExtendedController controller = this.loadControllerBasedOnStageUserData(event.stage);
        controller.loadTitle();
        GUIState.setController((ExtendedController)controller);
        GUIState.setFree((boolean)false);
    }

    private ExtendedController loadControllerBasedOnStageUserData(@NotNull Stage stage) {
        List data;
        log.debug("User data of this stage: {}", stage.getUserData());
        if (stage.getUserData() instanceof List && !(data = (List)stage.getUserData()).isEmpty()) {
            Transcript.get().setTranscriptLocation(Path.of((String)data.getFirst(), new String[0]));
        }
        return (ExtendedController)this.fxWeaver.loadController(MainController.class, Utils.getLocaleBundle());
    }

    @Generated
    public PrimaryStageInitializer(FxWeaver fxWeaver, MigrationService migrationService, ExecutorService executorService) {
        this.fxWeaver = fxWeaver;
        this.migrationService = migrationService;
        this.executorService = executorService;
    }
}

