/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.Keyring;
import eu.ewerkzeug.easytranscript3.commons.AESUtil;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
public class CredentialsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CredentialsUtils.class);
    public static final Path CREDS_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve(".creds");
    public static final Path DEVICE_ID_FILE = Path.of(Configuration.ET_HOME, new String[0]).resolve(".instance_info.dat");
    public static final String KEYRING_SERVICE_NAME = "easytranscript3";
    public static final String KEYRING_ACCOUNT_NAME = "LicenseAuth";
    public static final String KEYRING_ACCOUNT_DEVICE_ID = "DeviceId";

    public static boolean isKeyringSupportedPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        return !os.contains("mac");
    }

    public static void storeCredentials(byte[] auth) throws IOException {
        if (!CredentialsUtils.isKeyringSupportedPlatform()) {
            CredentialsUtils.storeInFile((byte[])auth);
            return;
        }
        try (Keyring keyring = Keyring.create();){
            String payload = Base64.getEncoder().encodeToString(auth);
            keyring.setPassword("easytranscript3", "LicenseAuth", payload);
            log.info("Credentials stored in system keyring.");
        }
        catch (BackendNotSupportedException e) {
            log.warn("System keyring not supported. Falling back to file storage.", (Throwable)e);
            CredentialsUtils.storeInFile((byte[])auth);
        }
        catch (Exception e) {
            log.error("Failed to access system keyring to store credentials. Falling back to file storage.", (Throwable)e);
            CredentialsUtils.storeInFile((byte[])auth);
        }
    }

    private static void storeInFile(byte[] auth) throws IOException {
        Files.write(CREDS_PATH, auth, new OpenOption[0]);
        Utils.markAsHidden((Path)CREDS_PATH);
    }

    public static void clearCredentials() throws IOException {
        if (CredentialsUtils.isKeyringSupportedPlatform()) {
            try (Keyring keyring = Keyring.create();){
                keyring.deletePassword("easytranscript3", "LicenseAuth");
            }
            catch (Exception e) {
                log.warn("Could not delete credentials from keyring", (Throwable)e);
            }
        }
        Files.deleteIfExists(CREDS_PATH);
    }

    public static byte[] getCredentials() {
        block14: {
            if (CredentialsUtils.isKeyringSupportedPlatform()) {
                byte[] byArray;
                block13: {
                    Keyring keyring = Keyring.create();
                    try {
                        String payload = keyring.getPassword("easytranscript3", "LicenseAuth");
                        byArray = Base64.getDecoder().decode(payload);
                        if (keyring == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (keyring != null) {
                                try {
                                    keyring.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (BackendNotSupportedException e) {
                            log.debug("Keyring not supported. Trying file fallback.");
                            break block14;
                        }
                        catch (Exception e) {
                            log.info("No credentials found in keyring or access denied. Trying file fallback.");
                        }
                    }
                    keyring.close();
                }
                return byArray;
            }
        }
        if (Files.exists(CREDS_PATH, new LinkOption[0])) {
            try {
                return Files.readAllBytes(CREDS_PATH);
            }
            catch (IOException e) {
                log.error("Failed to read credentials from file", (Throwable)e);
            }
        }
        return null;
    }

    public static void storeDeviceId(String deviceId) {
        if (!CredentialsUtils.isKeyringSupportedPlatform()) {
            CredentialsUtils.storeDeviceIdInFile((String)deviceId);
            return;
        }
        try (Keyring keyring = Keyring.create();){
            keyring.setPassword("easytranscript3", "DeviceId", deviceId);
            log.info("Device ID stored in system keyring.");
        }
        catch (BackendNotSupportedException e) {
            log.warn("System keyring not supported for Device ID. Falling back to file storage.", (Throwable)e);
            CredentialsUtils.storeDeviceIdInFile((String)deviceId);
        }
        catch (Exception e) {
            log.error("Failed to access system keyring to store Device ID. Falling back to file storage.", (Throwable)e);
            CredentialsUtils.storeDeviceIdInFile((String)deviceId);
        }
    }

    private static void storeDeviceIdInFile(String deviceId) {
        try {
            byte[] encrypted = AESUtil.encrypt((Serializable)((Object)deviceId));
            Files.write(DEVICE_ID_FILE, encrypted, new OpenOption[0]);
            Utils.markAsHidden((Path)DEVICE_ID_FILE);
        }
        catch (IOException e) {
            log.error("Failed to store Device ID in fallback file", (Throwable)e);
            throw new RuntimeException("Could not store Device ID securely", e);
        }
    }

    public static String getDeviceId() throws IOException {
        block12: {
            if (CredentialsUtils.isKeyringSupportedPlatform()) {
                String string;
                block11: {
                    Keyring keyring = Keyring.create();
                    try {
                        string = keyring.getPassword("easytranscript3", "DeviceId");
                        if (keyring == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (keyring != null) {
                                try {
                                    keyring.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (BackendNotSupportedException e) {
                            log.debug("Keyring not supported for Device ID. Trying file fallback.");
                            break block12;
                        }
                        catch (Exception e) {
                            log.info("No Device ID found in keyring or access denied. Trying file fallback.");
                        }
                    }
                    keyring.close();
                }
                return string;
            }
        }
        if (Files.exists(DEVICE_ID_FILE, new LinkOption[0])) {
            byte[] encrypted = Files.readAllBytes(DEVICE_ID_FILE);
            return (String)AESUtil.decrypt((byte[])encrypted);
        }
        log.info("No device id found. Generating new one.");
        String newDeviceId = UUID.randomUUID().toString();
        CredentialsUtils.storeDeviceId((String)newDeviceId);
        return newDeviceId;
    }

    public static <T> Mono<T> executeAuthenticated(Function<Consumer<HttpHeaders>, Mono<T>> requestFunction) {
        Consumer deviceIdAuth = CredentialsUtils.getDeviceIdAuthHeadersConsumer();
        log.info("Executing authenticated");
        if (deviceIdAuth == null) {
            log.warn("Could not get deviceId auth headers. Proceeding with full authentication directly.");
            Consumer fullAuth = CredentialsUtils.getAuthHeadersForFullAuthenticationConsumer();
            if (fullAuth == null) {
                return Mono.error((Throwable)new IllegalStateException("Could not get any authentication headers."));
            }
            return requestFunction.apply(fullAuth);
        }
        return requestFunction.apply(deviceIdAuth).onErrorResume(e -> {
            WebClientResponseException wcre;
            if (e instanceof WebClientResponseException && ((wcre = (WebClientResponseException)e).getStatusCode().value() == 401 || wcre.getStatusCode().value() == 403)) {
                log.warn("Request with deviceId auth failed with status {}. Retrying with full authentication.", (Object)wcre.getStatusCode());
                Consumer fullAuth = CredentialsUtils.getAuthHeadersForFullAuthenticationConsumer();
                if (fullAuth == null) {
                    try {
                        CredentialsUtils.clearCredentials();
                    }
                    catch (IOException ex) {
                        log.error("Could not clear credentials.");
                    }
                    return Mono.error((Throwable)new IllegalStateException("Could not get full authentication headers for retry."));
                }
                return (Mono)requestFunction.apply(fullAuth);
            }
            return Mono.error((Throwable)e);
        });
    }

    public static Consumer<HttpHeaders> getAuthHeadersForFullAuthenticationConsumer() {
        HashMap authHeaders = CredentialsUtils.getAuthHeadersForFullAuthentication();
        if (authHeaders == null) {
            return null;
        }
        return headers -> {
            for (Map.Entry authHeader : authHeaders.entrySet()) {
                headers.add((String)authHeader.getKey(), (String)authHeader.getValue());
            }
        };
    }

    public static Consumer<HttpHeaders> getDeviceIdAuthHeadersConsumer() {
        HashMap authHeaders = CredentialsUtils.getDeviceIdAuthHeaders();
        if (authHeaders == null) {
            return null;
        }
        return headers -> {
            for (Map.Entry authHeader : authHeaders.entrySet()) {
                headers.add((String)authHeader.getKey(), (String)authHeader.getValue());
            }
        };
    }

    public static HashMap<String, String> getDeviceIdAuthHeaders() {
        String deviceId;
        try {
            deviceId = CredentialsUtils.getDeviceId();
        }
        catch (IOException e) {
            log.error("Could not retrieve deviceId", (Throwable)e);
            return null;
        }
        HashMap<String, String> returner = new HashMap<String, String>();
        returner.put("X-Device-ID", deviceId);
        return returner;
    }

    public static HashMap<String, String> getAuthHeadersForFullAuthentication() {
        String deviceId;
        Pair authHeader = CredentialsUtils.getAuthenticationHeader();
        if (authHeader == null) {
            return null;
        }
        try {
            deviceId = CredentialsUtils.getDeviceId();
        }
        catch (IOException e) {
            log.error("Could not retrieve deviceId", (Throwable)e);
            return null;
        }
        HashMap<String, String> returner = new HashMap<String, String>();
        returner.put((String)authHeader.getKey(), (String)authHeader.getValue());
        returner.put("X-Device-ID", deviceId);
        return returner;
    }

    private static Pair<String, String> getAuthenticationHeader() {
        Pair credentials = LicenseService.getLicenseCredentials();
        if (credentials == null) {
            log.error("No credentials saved.");
            return null;
        }
        String header = "Authorization";
        String headerValue = "Basic " + Base64.getEncoder().encodeToString(((String)credentials.getLeft() + ":" + (String)credentials.getRight()).getBytes(StandardCharsets.UTF_8));
        return ImmutablePair.of((Object)header, (Object)headerValue);
    }
}

