/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.icu.util.ULocale;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SttLanguage;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class SttLanguageService {
    private final ObjectMapper mapper;
    private List<String> azureTags;
    private List<SttLanguage> supportedAzureLanguages;

    @PostConstruct
    public void init() throws IOException {
        this.azureTags = Arrays.asList((String[])this.mapper.readValue(Utils.class.getResourceAsStream("/stt/languages-azure.json"), String[].class));
        this.supportedAzureLanguages = this.getSupportedLanguages();
    }

    private List<SttLanguage> getSupportedLanguages() {
        return this.azureTags.stream().map(tag -> {
            ULocale locale = ULocale.forLanguageTag((String)tag);
            return new SttLanguage(tag, locale.getDisplayName());
        }).toList();
    }

    public SttLanguage getLanguageByLabel(String label) {
        return this.supportedAzureLanguages.stream().filter(l -> l.label().equals(label)).findFirst().orElse(null);
    }

    @Generated
    public SttLanguageService(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Generated
    public List<SttLanguage> getSupportedAzureLanguages() {
        return this.supportedAzureLanguages;
    }
}

