/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.jthemedetecor.OsThemeDetector;
import com.jthemedetecor.util.OsInfo;
import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.PairDeserializer;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.KeyCombinationDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.KeyCombinationSerializer;
import eu.ewerkzeug.easytranscript3.commons.types.PathDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.Theme;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.MainController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.awt.Toolkit;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.Declaration;
import javafx.css.ParsedValue;
import javafx.css.Rule;
import javafx.css.Stylesheet;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.fxmisc.richtext.model.Paragraph;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    @Generated
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Utils.class);
    private static final List<Integer> fontSizes = List.of(5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 28, 32, 36, 40, 48, 56, 64, 72);
    private static final List<String> fontFamilies = new ArrayList();
    private static final HashMap<URI, Stylesheet> readStylesheets = new HashMap();
    private static final String GENERAL_LOCAL_BUNDLE = "bundles.easytranscript_i18n";
    private static final String TUTORIALS_LOCAL_BUNDLE = "bundles.tutorials_i18n";
    private static final ThreadLocal<ObjectMapper> mapper = ThreadLocal.withInitial(() -> {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Pair.class, (JsonDeserializer)new PairDeserializer());
        JsonFactory factory = new JsonFactoryBuilder().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS).build();
        ObjectMapper mapper = new ObjectMapper(factory);
        mapper.registerModule((Module)module);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule confModule = new SimpleModule("confModule", Version.unknownVersion());
        confModule.addSerializer(KeyCombination.class, (JsonSerializer)new KeyCombinationSerializer());
        confModule.addDeserializer(KeyCombination.class, (JsonDeserializer)new KeyCombinationDeserializer());
        confModule.addSerializer(Path.class, (JsonSerializer)new ToStringSerializer());
        confModule.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        mapper.registerModule((Module)confModule);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    });
    private static boolean programInitialized = false;

    private Utils() {
    }

    public static ResourceBundle getLocaleBundle() {
        return Utils.getLocaleBundle((String)"bundles.easytranscript_i18n");
    }

    public static ResourceBundle getTutorialLocaleBundle() {
        return Utils.getLocaleBundle((String)"bundles.tutorials_i18n");
    }

    public static ResourceBundle getLocaleBundle(String bundle) {
        return ResourceBundle.getBundle(bundle, Locale.forLanguageTag(Configuration.get().getProgramLanguage()));
    }

    public static double round2Places(double value) {
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static int getGridPaneRowCount(GridPane gridPane) {
        return gridPane.getChildren().stream().mapToInt(n -> {
            Integer row = GridPane.getRowIndex((Node)n);
            Integer rowSpan = GridPane.getRowSpan((Node)n);
            return (row == null ? 0 : row + 1) + (rowSpan == null ? 0 : rowSpan - 1);
        }).max().orElse(0);
    }

    public static void deleteRow(GridPane grid, int rowIndex) {
        HashSet<Node> deleteNodes = new HashSet<Node>();
        for (Node child : grid.getChildren()) {
            int r;
            Integer rowI = GridPane.getRowIndex((Node)child);
            int n = r = rowI == null ? 0 : rowI;
            if (r > rowIndex) {
                GridPane.setRowIndex((Node)child, (Integer)(r - 1));
                continue;
            }
            if (r != rowIndex) continue;
            deleteNodes.add(child);
        }
        grid.getChildren().removeAll(deleteNodes);
    }

    public static void deleteAllLeftOverTempFiles() {
        Utils.clearTmp((Path)Main.getEasytranscriptTempDirectory());
    }

    public static void deleteLeftOverTranscriptTempFiles() {
        Utils.clearTmp((Path)Transcript.getTemporaryTranscriptsLocation());
    }

    private static void clearTmp(Path path) {
        long millis = System.currentTimeMillis();
        try {
            Utils.clearFolder((Path)path);
        }
        catch (IOException e) {
            log.error("Failed to clear path", (Throwable)e);
        }
        log.debug("Finished cleaning. Took {}ms", (Object)(System.currentTimeMillis() - millis));
    }

    public static void clearFolder(Path path) throws IOException {
        log.debug("Clearing folder.");
        if (path != null && path.toFile().exists()) {
            log.debug("Path: {}", (Object)path);
            try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(file -> {
                    try {
                        Files.delete(file);
                        log.debug("Deleted file {}", file);
                    }
                    catch (IOException e) {
                        log.error("Could not delete file {}.", file, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                log.error("Could not read files.", (Throwable)e);
            }
        } else {
            log.debug("Folder {} does not exist.", path != null ? "null" + String.valueOf(path) : "");
        }
    }

    public static void setLoggingLevel(String level) {
        log.debug("Changing log level to {}...", (Object)level);
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (root != null) {
            root.setLevel(Level.toLevel((String)level));
        } else {
            log.warn("Cannot change loglevel since logger is null.");
        }
        log.info("Changed log level to {}", (Object)level);
    }

    public static boolean isHighContrastModeActive() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return (Boolean)toolkit.getDesktopProperty("win.highContrast.on");
    }

    public static <T> T getCssVariable(String variable) throws URISyntaxException {
        Object result = Configuration.get().getTheme().equals((Object)Theme.DARK) ? Utils.getVariableFromUrl((String)variable, (URI)Utils.getDarculaThemeResource()) : Utils.getVariableFromUrl((String)variable, (URI)Utils.getLightThemeResource());
        if (result == null) {
            result = Utils.getVariableFromUrl((String)variable, (URI)Utils.getRootThemeResource());
        }
        return (T)result;
    }

    public static String getColorAsHex(Color color) {
        return Utils.getColorAsHex((Color)color, (boolean)true);
    }

    public static String getColorAsHex(Color color, boolean withOpacity) {
        return "#" + (Utils.formatColorPartValue((double)color.getRed()) + Utils.formatColorPartValue((double)color.getGreen()) + Utils.formatColorPartValue((double)color.getBlue()) + (withOpacity ? Utils.formatColorPartValue((double)color.getOpacity()) : "")).toUpperCase();
    }

    private static String formatColorPartValue(double val) {
        String in = Integer.toHexString((int)Math.round(val * 255.0));
        return in.length() == 1 ? "0" + in : in;
    }

    private static <T> T getVariableFromUrl(String variable, URI uri) {
        Stylesheet stylesheet = Utils.readCssFile((URI)uri);
        return (T)Utils.getVariableFromStylesheet((String)variable, (Stylesheet)stylesheet);
    }

    private static <T> T getVariableFromStylesheet(String variable, Stylesheet stylesheet) {
        if (stylesheet == null) {
            log.error("Could not get variable '{}'. Stylesheet is null.", (Object)variable);
            return null;
        }
        Rule rootRule = (Rule)stylesheet.getRules().getFirst();
        ObservableList declarations = rootRule.getDeclarations();
        for (Declaration d : declarations) {
            if (!d.getProperty().equals(variable)) continue;
            ParsedValue parsedValue = d.getParsedValue();
            return (T)parsedValue.getValue();
        }
        return null;
    }

    private static Stylesheet readCssFile(URI uri) {
        if (!readStylesheets.containsKey(uri)) {
            try {
                Stylesheet parse = new CssParser().parse(uri.toURL());
                readStylesheets.put(uri, parse);
                return parse;
            }
            catch (IOException e) {
                log.error("Could not read root theme resource.", (Throwable)e);
                return null;
            }
        }
        return (Stylesheet)readStylesheets.get(uri);
    }

    public static URI getDarculaThemeResource() throws URISyntaxException {
        return Objects.requireNonNull(Utils.class.getResource("/eu/ewerkzeug/easytranscript3/darcula.css")).toURI();
    }

    public static URI getLightThemeResource() throws URISyntaxException {
        return Objects.requireNonNull(Utils.class.getResource("/eu/ewerkzeug/easytranscript3/light.css")).toURI();
    }

    public static URI getRootThemeResource() throws URISyntaxException {
        return Objects.requireNonNull(Utils.class.getResource("/eu/ewerkzeug/easytranscript3/theme.css")).toURI();
    }

    public static Map<String, String> getMisspellingCorrections() {
        HashMap<String, String> returner = new HashMap<String, String>();
        try {
            ArrayType pairType = ((ObjectMapper)mapper.get()).getTypeFactory().constructArrayType(((ObjectMapper)mapper.get()).getTypeFactory().constructParametricType(Pair.class, new Class[]{String.class, String.class}));
            if (Configuration.get().getProgramLanguage().equals("de")) {
                Pair[] de;
                for (Pair mutablePair : de = (Pair[])((ObjectMapper)mapper.get()).readValue(Utils.class.getResourceAsStream("/substitutions/misspellings_de.json"), (JavaType)pairType)) {
                    returner.put(((String)mutablePair.getKey()).replace("*", "").toLowerCase(), ((String)mutablePair.getValue()).replace("*", ""));
                }
            } else if (Configuration.get().getProgramLanguage().equals("en")) {
                Pair[] en;
                for (Pair mutablePair : en = (Pair[])((ObjectMapper)mapper.get()).readValue(Utils.class.getResourceAsStream("/substitutions/misspellings_en.json"), (JavaType)pairType)) {
                    returner.put(((String)mutablePair.getKey()).replace("*", "").toLowerCase(), ((String)mutablePair.getValue()).replace("*", ""));
                }
            }
            return returner;
        }
        catch (IOException e) {
            log.error("Could not read substitution files.", (Throwable)e);
            return returner;
        }
    }

    public static List<String> getFontFamilies() {
        if (fontFamilies.isEmpty()) {
            List families = Font.getFamilies();
            for (String f : families) {
                List fontNames = Font.getFontNames((String)f);
                boolean boldItalic = false;
                boolean bold = false;
                boolean italic = false;
                for (String fn : fontNames) {
                    if (fn.toLowerCase().endsWith("bold italic")) {
                        boldItalic = true;
                    } else if (fn.toLowerCase().endsWith("italic")) {
                        italic = true;
                    } else if (fn.toLowerCase().endsWith("bold")) {
                        bold = true;
                    }
                    if (!boldItalic || !italic || !bold) continue;
                    break;
                }
                if (!boldItalic || !italic || !bold) continue;
                fontFamilies.add(f);
            }
            log.debug("Fonts installed in system: {}", (Object)fontFamilies);
        }
        return fontFamilies;
    }

    public static long getLastTimestamp() {
        for (int i = TranscriptTextArea.get().getDocument().getParagraphs().size() - 1; i >= 0; --i) {
            Paragraph paragraph = (Paragraph)TranscriptTextArea.get().getDocument().getParagraphs().get(i);
            TimestampSegment timestampSegment = paragraph.getSegments().stream().filter(TimestampSegment.class::isInstance).reduce((first, second) -> second).orElse(null);
            if (timestampSegment == null) continue;
            return timestampSegment.getMillis();
        }
        return -1L;
    }

    public static void setStyleSheets(Scene scene) {
        String path;
        scene.getStylesheets().clear();
        String dark = "eu/ewerkzeug/easytranscript3/darcula.css";
        String light = "eu/ewerkzeug/easytranscript3/light.css";
        if (Configuration.get().getTheme().equals((Object)Theme.SYNC_WITH_OS)) {
            if (!OsThemeDetector.isSupported()) {
                Configuration.get().setTheme(Theme.DARK);
                Configuration.get().save();
                path = dark;
            } else {
                try {
                    path = OsThemeDetector.getDetector().isDark() ? dark : light;
                }
                catch (Exception e) {
                    log.error("Failed to detect theme.", (Throwable)e);
                    path = dark;
                }
            }
        } else {
            path = Configuration.get().getTheme().equals((Object)Theme.DARK) ? dark : light;
        }
        URL base = ExtendedController.class.getClassLoader().getResource("eu/ewerkzeug/easytranscript3/theme.css");
        URL theme = ExtendedController.class.getClassLoader().getResource(path);
        if (base != null) {
            scene.getStylesheets().add(0, (Object)base.toExternalForm());
        }
        if (theme != null) {
            scene.getStylesheets().add(0, (Object)theme.toExternalForm());
        }
    }

    public static void reapplyTheme() {
        Platform.runLater(() -> {
            Utils.setStyleSheets((Scene)GUIState.getMainStage().getScene());
            Utils.setStyleSheets((Scene)((MainController)GUIState.getController()).getProgressBarController().stage.getScene());
            Window.getWindows().forEach(window -> Utils.setStyleSheets((Scene)window.getScene()));
        });
    }

    public static Screen getScreenForRectangle(Rectangle2D rect) {
        ObservableList screens = Screen.getScreens();
        double rectX0 = rect.getMinX();
        double rectX1 = rect.getMaxX();
        double rectY0 = rect.getMinY();
        double rectY1 = rect.getMaxY();
        Screen selectedScreen = null;
        double maxIntersection = 0.0;
        for (Screen screen : screens) {
            Rectangle2D screenBounds = screen.getBounds();
            double intersection = Utils.getIntersectionLength((double)rectX0, (double)rectX1, (double)screenBounds.getMinX(), (double)screenBounds.getMaxX()) * Utils.getIntersectionLength((double)rectY0, (double)rectY1, (double)screenBounds.getMinY(), (double)screenBounds.getMaxY());
            if (!(maxIntersection < intersection)) continue;
            maxIntersection = intersection;
            selectedScreen = screen;
        }
        if (selectedScreen != null) {
            return selectedScreen;
        }
        selectedScreen = Screen.getPrimary();
        double minDistance = Double.MAX_VALUE;
        for (Screen screen : screens) {
            double dy;
            Rectangle2D screenBounds = screen.getBounds();
            double dx = Utils.getOuterDistance((double)rectX0, (double)rectX1, (double)screenBounds.getMinX(), (double)screenBounds.getMaxX());
            double distance = dx * dx + (dy = Utils.getOuterDistance((double)rectY0, (double)rectY1, (double)screenBounds.getMinY(), (double)screenBounds.getMaxY())) * dy;
            if (!(minDistance > distance)) continue;
            minDistance = distance;
            selectedScreen = screen;
        }
        return selectedScreen;
    }

    private static double getIntersectionLength(double a0, double a1, double b0, double b1) {
        return a0 <= b0 ? Utils.getIntersectionLengthImpl((double)b0, (double)b1, (double)a1) : Utils.getIntersectionLengthImpl((double)a0, (double)a1, (double)b1);
    }

    private static double getIntersectionLengthImpl(double v0, double v1, double v) {
        if (v <= v0) {
            return 0.0;
        }
        return v <= v1 ? v - v0 : v1 - v0;
    }

    private static double getOuterDistance(double a0, double a1, double b0, double b1) {
        if (a1 <= b0) {
            return b0 - a1;
        }
        if (b1 <= a0) {
            return b1 - a0;
        }
        return 0.0;
    }

    public static String millisToTimestamp(long millis) {
        Configuration.get();
        return DateFormatUtils.format((long)millis, (String)Configuration.get().getTimestampsFormat(), (TimeZone)TimeZone.getTimeZone("GMT"));
    }

    public static ObjectMapper getObjectMapper() {
        return (ObjectMapper)mapper.get();
    }

    public static String removeControlCharactersFromJSON(String jsonString) {
        return jsonString.replaceAll("[\\x00-\\x1F]", "");
    }

    public static Screen getWindowScreen(Window window) {
        do {
            if (Double.isNaN(window.getX()) || Double.isNaN(window.getY()) || Double.isNaN(window.getWidth()) || Double.isNaN(window.getHeight())) continue;
            return Utils.getScreenForRectangle((Rectangle2D)new Rectangle2D(window.getX(), window.getY(), window.getWidth(), window.getHeight()));
        } while ((window = Utils.getParentWindow((Window)window)) != null);
        return Screen.getPrimary();
    }

    public static Window getParentWindow(Window window) {
        Window parentWindow;
        if (window instanceof Stage) {
            Stage stage = (Stage)window;
            parentWindow = stage.getOwner();
        } else if (window instanceof Popup) {
            Popup popup = (Popup)window;
            parentWindow = popup.getOwnerWindow();
        } else {
            parentWindow = null;
        }
        return parentWindow;
    }

    public static <T> T getFromNonNullableSupplier(@NotNull Supplier<T> supplier) {
        T result = supplier.get();
        if (result == null) {
            log.error("The result of the given non-nullable type supplier is null!");
        }
        return result;
    }

    public static void showGenericResponseServerErrorDialog() {
        String title = Utils.getLocaleBundle().getString("general.genericResponseServerErrorTitle");
        String content = Utils.getLocaleBundle().getString("general.genericResponseServerError");
        Platform.runLater(() -> ETDialog.createDialog((String)title, (String)content, (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    public static void showGenericRequestErrorDialog() {
        Platform.runLater(() -> ETDialog.createDialog((String)"", (String)Utils.getLocaleBundle().getString("general.noConnectionToServer"), (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    public static void markAsHidden(Path path) {
        if (OsInfo.isWindows10OrLater()) {
            try {
                DosFileAttributeView fileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
                if (fileAttributeView != null) {
                    fileAttributeView.setHidden(true);
                }
            }
            catch (IOException e) {
                log.error("Could not mark file as hidden", (Throwable)e);
            }
        }
    }

    @Generated
    public static List<Integer> getFontSizes() {
        return fontSizes;
    }

    @Generated
    public static boolean isProgramInitialized() {
        return programInitialized;
    }

    @Generated
    public static void setProgramInitialized(boolean programInitialized) {
        Utils.programInitialized = programInitialized;
    }
}

