/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.Position;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.stage.Window;
import lombok.Generated;
import org.jetbrains.annotations.Contract;

public final class Placement {
    private final Window window;
    private final Bounds toAlignTo;
    private final int horizontalDistance;
    private final int verticalDistance;
    private final Rectangle2D screenBounds;

    public Placement(Window window, Bounds toAlignTo, int horizontalDistance, int verticalDistance) {
        this.window = window;
        this.toAlignTo = toAlignTo;
        this.horizontalDistance = horizontalDistance;
        this.verticalDistance = verticalDistance;
        this.screenBounds = Utils.getWindowScreen((Window)window).getVisualBounds();
    }

    public double insideRight() {
        return this.toAlignTo.getMaxX() - this.window.getWidth() + (double)this.horizontalDistance;
    }

    public double insideLeft() {
        return this.toAlignTo.getMinX() + (double)this.horizontalDistance;
    }

    public double toTheLeft() {
        return this.insideLeft() - this.window.getWidth();
    }

    public double toTheRight() {
        return this.insideRight() + this.window.getWidth();
    }

    public double insideBottom() {
        return this.toAlignTo.getMaxY() - this.window.getHeight();
    }

    public double insideTop() {
        return this.toAlignTo.getMinY();
    }

    public double above() {
        return this.insideTop() - this.window.getHeight();
    }

    public double below() {
        return this.insideBottom() + this.window.getHeight();
    }

    @Contract(pure=true)
    public Position getHorizontalOverlap(Double position) {
        Position horizontal = null;
        if (position + this.window.getWidth() > this.screenBounds.getMaxX()) {
            horizontal = Position.RIGHT;
        } else if (position < this.screenBounds.getMinX()) {
            horizontal = Position.LEFT;
        }
        return horizontal;
    }

    @Contract(pure=true)
    public Position getVerticalOverlap(Double position) {
        Position vertical = null;
        if (position + this.window.getHeight() > this.screenBounds.getMaxY()) {
            vertical = Position.BOTTOM;
        } else if (position < this.screenBounds.getMinY()) {
            vertical = Position.TOP;
        }
        return vertical;
    }

    @Generated
    public Window getWindow() {
        return this.window;
    }

    @Generated
    public Bounds getToAlignTo() {
        return this.toAlignTo;
    }

    @Generated
    public int getHorizontalDistance() {
        return this.horizontalDistance;
    }

    @Generated
    public int getVerticalDistance() {
        return this.verticalDistance;
    }
}

