/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.alerts;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@FxmlView(value="etDialog.fxml")
public class ETDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ETDialog.class);
    ETButtonType selectedButtonType;
    @FXML
    private VBox root;
    @FXML
    private Label text;
    @FXML
    private ButtonBar buttonBar;
    @FXML
    private VBox otherContent;
    private Stage stage;

    public static ETDialog createDialog(String title, String text, Modality modality, List<ETButtonType> buttons) {
        return ETDialog.createDialog((String)title, (String)text, (Modality)modality, buttons, (Window)GUIState.getMainStage());
    }

    public static ETDialog createDialog(String title, String text, Modality modality, List<ETButtonType> buttons, Window owner) {
        log.debug("Creating dialog...");
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(ETDialog.class.getClassLoader().getResource(ETDialog.class.getPackageName().replace(".", "/") + "/etDialog.fxml"));
        fxmlLoader.setResources(Utils.getLocaleBundle());
        try {
            Parent node = (Parent)fxmlLoader.load();
            Scene scene = new Scene(node);
            Stage stage = new Stage();
            stage.initStyle(StageStyle.UTILITY);
            stage.setResizable(false);
            stage.setScene(scene);
            ETDialog etDialog = (ETDialog)fxmlLoader.getController();
            etDialog.setStage(stage);
            if (buttons != null) {
                etDialog.setButtons(buttons);
            } else {
                ArrayList<ETButtonType> buttonTypeList = new ArrayList<ETButtonType>();
                buttonTypeList.add(new ETButtonType(new ButtonType(ButtonType.OK.getText(), ButtonBar.ButtonData.OK_DONE), true, false));
                etDialog.setButtons(buttonTypeList);
            }
            etDialog.getOtherContent().setManaged(false);
            etDialog.getOtherContent().getChildren().addListener(change -> etDialog.getOtherContent().setManaged(!etDialog.getOtherContent().getChildren().isEmpty()));
            Utils.setStyleSheets((Scene)scene);
            ((Stage)etDialog.text.getScene().getWindow()).initOwner(owner);
            etDialog.setText(text);
            etDialog.setTitle(title);
            etDialog.initModality(modality);
            log.debug("Dialog created.");
            return etDialog;
        }
        catch (IOException exception) {
            log.error("Could not create dialog.", (Throwable)exception);
            ExceptionAlert.get().showModal();
            return null;
        }
    }

    public static ETDialog get(String text) {
        return ETDialog.get((String)"", (String)text);
    }

    public static ETDialog get(String text, Alert.AlertType type) {
        return ETDialog.get((String)"", (String)text);
    }

    public static ETDialog get(String title, String text) {
        return ETDialog.createDialog((String)title, (String)text, (Modality)Modality.WINDOW_MODAL, null);
    }

    public static ETDialog get(String title, String text, Window owner) {
        return ETDialog.createDialog((String)title, (String)text, (Modality)Modality.WINDOW_MODAL, null, (Window)owner);
    }

    protected Button createButton(ETButtonType buttonType) {
        Button button = new Button(buttonType.getButtonType().getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonType().getButtonData();
        ButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
        button.setDefaultButton(buttonData.isDefaultButton());
        if (buttonType.isDefaultButton()) {
            button.getStyleClass().add((Object)"primary-button");
        } else {
            button.getStyleClass().add((Object)"secondary-button");
        }
        button.setCancelButton(buttonType.isCancelButton());
        return button;
    }

    public void setText(String content) {
        this.text.setText(content);
    }

    public void setButtons(List<ETButtonType> buttons) {
        this.buttonBar.getButtons().clear();
        buttons.forEach(b -> {
            Button button = this.createButton(b);
            button.setOnAction(actionEvent -> {
                this.selectedButtonType = b;
                ((Stage)this.text.getScene().getWindow()).close();
            });
            this.buttonBar.getButtons().add((Object)button);
        });
    }

    public ButtonType showAndWait() {
        this.stage.centerOnScreen();
        this.stage.showAndWait();
        return this.selectedButtonType == null ? null : this.selectedButtonType.getButtonType();
    }

    public void initModality(Modality modality) {
        ((Stage)this.text.getScene().getWindow()).initModality(modality);
    }

    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    @Generated
    public VBox getOtherContent() {
        return this.otherContent;
    }

    @Generated
    public Stage getStage() {
        return this.stage;
    }

    @Generated
    public void setStage(Stage stage) {
        this.stage = stage;
    }
}

