/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.apache.commons.exec.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KeyCombinationTextField
extends JFXTextField {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyCombinationTextField.class);
    private final KeyCode[] notAllowedInAnyCombination = new KeyCode[]{KeyCode.ENTER, KeyCode.TAB, KeyCode.UNDEFINED};
    private final BooleanProperty keyCharacterCombinationAllowed = new SimpleBooleanProperty(false);
    private final Pattern oneOrMoreCharacterAtBoundary = Pattern.compile("^[\\p{IsGraph}]*$");
    private final Pattern oneCharacterAtBoundary = Pattern.compile("^[\\p{IsGraph}]");

    public KeyCombinationTextField(@NamedArg(value="keyCharacterCombinationAllowed") boolean keyCharacterCombinationAllowed) {
        this.keyCharacterCombinationAllowed.setValue(Boolean.valueOf(keyCharacterCombinationAllowed));
        this.setOnKeyPressed(event -> {
            event.consume();
            for (KeyCode c : this.notAllowedInAnyCombination) {
                if (!event.getCode().equals((Object)c)) continue;
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (this.isKeyCharacterCombinationAllowed().booleanValue() && !event.isControlDown() && !event.isAltDown() && !event.isMetaDown() && !event.getCode().isFunctionKey() && this.oneOrMoreCharacterAtBoundary.matcher(event.getText()).matches()) {
                if (!this.isEditable()) {
                    this.clear();
                }
                this.setEditable(true);
            } else {
                this.setEditable(false);
                if (event.getCode().equals((Object)KeyCode.DELETE) || event.getCode().equals((Object)KeyCode.BACK_SPACE)) {
                    this.setText("");
                    return;
                }
                if (event.isShiftDown()) {
                    list.add(KeyCode.SHIFT.getName());
                }
                if (event.isAltDown()) {
                    list.add(KeyCode.ALT.getName());
                }
                if (event.isControlDown()) {
                    list.add(KeyCode.CONTROL.getName());
                }
                if (event.isMetaDown()) {
                    if (OS.isFamilyMac()) {
                        list.add(KeyCode.COMMAND.getName());
                    } else if (OS.isFamilyWindows()) {
                        list.add(KeyCode.WINDOWS.getName());
                    } else {
                        list.add(KeyCode.META.getName());
                    }
                }
                if (!event.getCode().isModifierKey()) {
                    list.add(event.getCode().getName());
                }
                StringBuilder finaler = new StringBuilder();
                for (String s : list) {
                    finaler.append("+").append(s);
                }
                this.setText(finaler.substring(1));
            }
        });
        this.setEditable(false);
    }

    public static String replacePlatformIndependentBySpecific(String value) {
        return value.replace(KeyCode.META.getName(), OS.isFamilyMac() ? KeyCode.COMMAND.getName() : (OS.isFamilyWindows() ? KeyCode.WINDOWS.getName() : KeyCode.META.getName())).replace(KeyCode.SHORTCUT.getName(), OS.isFamilyMac() ? KeyCode.COMMAND.getName() : KeyCode.CONTROL.getName());
    }

    public static String replaceSpecificByPlatformIndependent(String value) {
        return value.replace(KeyCode.COMMAND.getName(), KeyCode.META.getName()).replace(KeyCode.WINDOWS.getName(), KeyCode.META.getName());
    }

    public KeyCombination validateText() {
        try {
            String text = this.getText();
            if (!text.isEmpty()) {
                text = text.replace(KeyCode.COMMAND.getName(), KeyCode.META.getName());
                text = text.replace(KeyCode.WINDOWS.getName(), KeyCode.META.getName());
                KeyCombination keyCombination = KeyCombination.valueOf((String)text);
                return this.validateKeyCombination(keyCombination);
            }
            return KeyCombination.NO_MATCH;
        }
        catch (Exception e) {
            log.warn("Invalid key combination: {}", (Object)this.getText(), (Object)e);
            return KeyCombination.NO_MATCH;
        }
    }

    public KeyCombination validateKeyCombination(KeyCombination keyCombination) {
        if (keyCombination instanceof KeyCharacterCombination) {
            if (!this.keyCharacterCombinationAllowed.get()) {
                log.warn("An invalid input was detected. This field does not allow character combinations but input was " + keyCombination.getName());
                return KeyCombination.NO_MATCH;
            }
        } else if (keyCombination instanceof KeyCodeCombination) {
            boolean onlyArrows;
            if (this.oneCharacterAtBoundary.matcher(keyCombination.getDisplayText()).matches()) {
                log.warn("An invalid input was detected. This field does allow character combinations but input was a single visible character: {}", (Object)keyCombination.getName());
                return KeyCombination.NO_MATCH;
            }
            boolean onlyModifiers = ((KeyCodeCombination)keyCombination).getCode() == null || ((KeyCodeCombination)keyCombination).getCode().isModifierKey();
            boolean bl = onlyArrows = ((KeyCodeCombination)keyCombination).getCode().isArrowKey() && keyCombination.getShift() == KeyCombination.ModifierValue.UP && keyCombination.getAlt() == KeyCombination.ModifierValue.UP && keyCombination.getControl() == KeyCombination.ModifierValue.UP && keyCombination.getShortcut() == KeyCombination.ModifierValue.UP && keyCombination.getMeta() == KeyCombination.ModifierValue.UP;
            if (onlyArrows) {
                log.warn("An invalid input was detected. Only arrow keys are not allowed.");
                return KeyCombination.NO_MATCH;
            }
            if (onlyModifiers) {
                log.warn("An invalid input was detected. Only modifier keys are not allowed.");
                return KeyCombination.NO_MATCH;
            }
        } else {
            log.error("Unhandled KeyCombination type: {}", (Object)keyCombination.getClass().getName());
        }
        return keyCombination;
    }

    public Boolean isKeyCharacterCombinationAllowed() {
        return this.keyCharacterCombinationAllowed.getValue();
    }

    public void setKeyCombinationFieldText(KeyCombination value) {
        this.setText(KeyCombinationTextField.replacePlatformIndependentBySpecific((String)this.validateKeyCombination(value).toString()));
    }
}

