/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpacedText
extends FlowPane {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpacedText.class);
    private static final String DEFAULT_STYLE_CLASS = "et-spaced-text";
    private final SimpleDoubleProperty spacing = new SimpleDoubleProperty();
    private final SimpleStringProperty formatting = new SimpleStringProperty();
    private final SimpleStringProperty text = new SimpleStringProperty();
    private final SimpleStringProperty suffix = new SimpleStringProperty("");
    private final SimpleStringProperty textBreak;

    public SpacedText() {
        this("", Double.valueOf(1.0), FormattingValue.NORMAL.value, "");
    }

    public SpacedText(@NamedArg(value="spacing", defaultValue="1") Double spacing) {
        this("", spacing, FormattingValue.NORMAL.value, "");
    }

    public SpacedText(@NamedArg(value="text") String text) {
        this(text, Double.valueOf(1.0), FormattingValue.NORMAL.value, "");
    }

    public SpacedText(FormattingValue formatting) {
        this("", Double.valueOf(1.0), formatting.value, "");
    }

    public SpacedText(@NamedArg(value="text") String text, @NamedArg(value="spacing", defaultValue="1") Double spacing) {
        this(text, spacing, FormattingValue.NORMAL.value, "");
    }

    public SpacedText(@NamedArg(value="spacing", defaultValue="1") Double spacing, @NamedArg(value="formatting") String formatting) {
        this("", spacing, formatting, "");
    }

    public SpacedText(@NamedArg(value="text") String text, @NamedArg(value="formatting") String formatting) {
        this(text, Double.valueOf(1.0), formatting, "");
    }

    public SpacedText(@NamedArg(value="text") String text, @NamedArg(value="spacing", defaultValue="1") Double spacing, @NamedArg(value="formatting") String formatting) {
        this(text, spacing, formatting, "");
    }

    public SpacedText(@NamedArg(value="text") String text, @NamedArg(value="spacing", defaultValue="1") Double spacing, @NamedArg(value="formatting") String formatting, @NamedArg(value="suffix") String suffix) {
        this.textBreak = new SimpleStringProperty(TextBreak.AFTER_WORDS.value);
        this.formattingProperty().setValue(formatting);
        this.spacingProperty().setValue((Number)spacing);
        this.getStyleClass().add((Object)"et-spaced-text");
        if (text.startsWith("%")) {
            text = Utils.getLocaleBundle().getString(text.substring(1));
        }
        this.hgapProperty().bind((ObservableValue)this.spacing);
        this.text.addListener(observable -> this.layoutText());
        this.text.set(text);
        this.suffixProperty().addListener(observable -> this.layoutText());
        this.suffixProperty().set(suffix);
    }

    private void layoutText() {
        this.getChildren().clear();
        Object formattedText = this.getText() + this.getSuffix();
        if (((String)formattedText).isEmpty()) {
            return;
        }
        switch (FormattingValue.valueOf((String)this.formatting.getValue()).ordinal()) {
            case 1: {
                formattedText = ((String)formattedText).toUpperCase();
                break;
            }
            case 2: {
                formattedText = ((String)formattedText).toLowerCase();
                break;
            }
        }
        if (this.textBreak.get().equals(TextBreak.ANYWHERE.value)) {
            formattedText = ((String)formattedText).replace("&shy;", "");
            for (char c : ((String)formattedText).toCharArray()) {
                this.getChildren().add((Object)new Label("" + c));
            }
        } else if (this.textBreak.get().equals(TextBreak.AFTER_WORDS.value)) {
            String[] words;
            formattedText = ((String)formattedText).replace("&shy;", "");
            for (String word : words = ((String)formattedText).split(" ")) {
                HBox hBox = new HBox();
                hBox.getStyleClass().add((Object)"hbox");
                hBox.spacingProperty().bind((ObservableValue)this.spacing);
                for (char c : word.toCharArray()) {
                    hBox.getChildren().add((Object)new Label("" + c));
                }
                this.getChildren().add((Object)hBox);
                this.getChildren().add((Object)new Label(" "));
            }
        }
        Platform.runLater(() -> {
            double width = 0.0;
            for (Node c : this.getChildren()) {
                width += c.getBoundsInParent().getWidth() + this.getSpacing();
            }
            this.setPrefWrapLength(Math.min(this.getPrefWrapLength(), Math.ceil(width)));
        });
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String text) {
        this.text.set(text);
    }

    public final SimpleStringProperty textProperty() {
        return this.text;
    }

    public final double getSpacing() {
        return this.spacing.get();
    }

    public final void setSpacing(double spacing) {
        this.spacing.set(spacing);
    }

    public final SimpleDoubleProperty spacingProperty() {
        return this.spacing;
    }

    public final String getFormatting() {
        return this.formatting.get();
    }

    public final void setFormatting(String formatting) {
        this.formatting.set(formatting);
    }

    public final SimpleStringProperty formattingProperty() {
        return this.formatting;
    }

    public final SimpleStringProperty suffixProperty() {
        return this.suffix;
    }

    public String getSuffix() {
        return this.suffix.get();
    }

    public void setSuffix(String suffix) {
        this.suffix.set(suffix);
    }
}

