/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix;

import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.CustomJFXRadioButtonSkin;
import javafx.animation.Interpolator;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.skin.RadioButtonSkin;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomJFXRadioButtonSkin
extends RadioButtonSkin {
    private final JFXRippler rippler;
    private final StackPane container;
    private final double padding = 12.0;
    private final Circle radio;
    private final Circle dot;
    private JFXAnimationTimer timer;

    public CustomJFXRadioButtonSkin(JFXRadioButton control) {
        super((RadioButton)control);
        double radioRadius = 8.0;
        this.radio = new Circle(8.0);
        this.radio.getStyleClass().setAll((Object[])new String[]{"radio"});
        this.radio.setStrokeWidth(2.0);
        this.radio.setFill((Paint)Color.TRANSPARENT);
        this.radio.setSmooth(true);
        this.dot = new Circle(8.0);
        this.dot.getStyleClass().setAll((Object[])new String[]{"dot"});
        this.dot.fillProperty().bind((ObservableValue)control.selectedColorProperty());
        this.dot.setScaleX(0.0);
        this.dot.setScaleY(0.0);
        this.dot.setSmooth(true);
        this.container = new StackPane(new Node[]{this.radio, this.dot});
        this.container.getStyleClass().add((Object)"radio-container");
        this.rippler = new /* Unavailable Anonymous Inner Class!! */;
        this.rippler.setRipplerDisabled(Boolean.valueOf(true));
        this.updateChildren();
        control.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (!control.disableVisualFocusProperty().get()) {
                if (newVal.booleanValue()) {
                    if (!((RadioButton)this.getSkinnable()).isPressed()) {
                        this.rippler.setOverlayVisible(true);
                    }
                } else {
                    this.rippler.setOverlayVisible(false);
                }
            }
        });
        control.pressedProperty().addListener((o, oldVal, newVal) -> this.rippler.setOverlayVisible(false));
        this.timer = new JFXAnimationTimer(new JFXKeyFrame[]{new JFXKeyFrame(Duration.millis((double)200.0), new JFXKeyValue[]{JFXKeyValue.builder().setTarget((WritableValue)this.dot.scaleXProperty()).setEndValueSupplier(() -> ((RadioButton)this.getSkinnable()).isSelected() ? 0.55 : 0.0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTarget((WritableValue)this.dot.scaleYProperty()).setEndValueSupplier(() -> ((RadioButton)this.getSkinnable()).isSelected() ? 0.55 : 0.0).setInterpolator(Interpolator.EASE_BOTH).build()})});
        this.registerChangeListener((ObservableValue)control.selectedColorProperty(), obs -> this.updateColors());
        this.registerChangeListener((ObservableValue)control.unSelectedColorProperty(), obs -> this.updateColors());
        this.registerChangeListener((ObservableValue)control.selectedProperty(), obs -> {
            boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
            Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
            Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
            this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
            if (((JFXRadioButton)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                this.timer.applyEndValues();
            } else {
                this.timer.reverseAndContinue();
            }
        });
        this.updateColors();
        this.timer.applyEndValues();
    }

    private static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (2.$SwitchMap$javafx$geometry$HPos[hpos.ordinal()]) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return (width - contentWidth) / 2.0;
            }
            case 3: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    private static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (2.$SwitchMap$javafx$geometry$VPos[vpos.ordinal()]) {
            case 1: {
                return 0.0;
            }
            case 2: {
                return (height - contentHeight) / 2.0;
            }
            case 3: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.radio != null) {
            this.removeRadio();
            this.getChildren().addAll((Object[])new Node[]{this.container, this.rippler});
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        RadioButton radioButton = (RadioButton)this.getSkinnable();
        double contWidth = this.snapSizeX(this.container.prefWidth(-1.0));
        double contHeight = this.snapSizeY(this.container.prefHeight(-1.0));
        double computeWidth = Math.max(radioButton.prefWidth(-1.0), radioButton.minWidth(-1.0));
        double width = this.snapSizeX(contWidth);
        double height = this.snapSizeY(contHeight);
        double labelWidth = Math.min(computeWidth - contWidth, w - width);
        double labelHeight = Math.min(radioButton.prefHeight(labelWidth), h);
        double maxHeight = Math.max(contHeight, labelHeight);
        double xOffset = CustomJFXRadioButtonSkin.computeXOffset((double)w, (double)(labelWidth + contWidth), (HPos)radioButton.getAlignment().getHpos()) + x;
        double yOffset = CustomJFXRadioButtonSkin.computeYOffset((double)h, (double)maxHeight, (VPos)radioButton.getAlignment().getVpos()) + x;
        this.container.resize(width, height);
        this.layoutLabelInArea(xOffset + contWidth + 4.0, yOffset, labelWidth, maxHeight, radioButton.getAlignment());
        this.positionInArea((Node)this.container, xOffset, yOffset, contWidth, maxHeight, 0.0, radioButton.getAlignment().getHpos(), radioButton.getAlignment().getVpos());
        double ripplerWidth = width + 24.0;
        double ripplerHeight = height + 24.0;
        this.rippler.resizeRelocate(width / 2.0 + xOffset - ripplerWidth / 2.0, height / 2.0 + xOffset - ripplerHeight / 2.0, ripplerWidth, ripplerHeight);
    }

    private void removeRadio() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (!((Node)this.getChildren().get(i)).getStyleClass().contains((Object)"radio")) continue;
            this.getChildren().remove(i);
            break;
        }
    }

    private void updateColors() {
        boolean isSelected = ((RadioButton)this.getSkinnable()).isSelected();
        Color unSelectedColor = ((JFXRadioButton)this.getSkinnable()).getUnSelectedColor();
        Color selectedColor = ((JFXRadioButton)this.getSkinnable()).getSelectedColor();
        this.rippler.setRipplerFill((Paint)(isSelected ? selectedColor : unSelectedColor));
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.radio.minWidth(-1.0)) + 4.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSizeX(this.radio.prefWidth(-1.0)) + 4.0;
    }

    public void dispose() {
        super.dispose();
        this.timer.dispose();
        this.timer = null;
    }
}

