/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix;

import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.effects.JFXDepthManager;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.CustomJFXTabPaneSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomJFXTabPaneSkin
extends SkinBase<JFXTabPane> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomJFXTabPaneSkin.class);
    private static final int SPACER = 10;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"disabled");
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass CLOSABLE = PseudoClass.getPseudoClass((String)"closable");
    private final HeaderContainer header;
    private final ObservableList<TabContentHolder> tabContentHolders;
    private final Rectangle clip;
    private final Rectangle tabsClip;
    private final AnchorPane tabsContainer;
    private final AnchorPane tabsContainerHolder;
    private final TabPaneBehavior behavior;
    private Tab selectedTab;
    private boolean isSelectingTab = false;
    private double dragStart;
    private double offsetStart;
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private boolean removedTabs = false;
    private int diffTabsIndices = 0;

    public CustomJFXTabPaneSkin(JFXTabPane tabPane) {
        super((Control)tabPane);
        this.behavior = new TabPaneBehavior((TabPane)tabPane);
        this.tabContentHolders = FXCollections.observableArrayList();
        this.header = new HeaderContainer(this);
        this.getChildren().add((Object)JFXDepthManager.createMaterialNode((Node)this.header, (int)1));
        this.tabsContainer = new AnchorPane();
        this.tabsContainerHolder = new AnchorPane();
        this.tabsContainerHolder.getChildren().add((Object)this.tabsContainer);
        this.tabsClip = new Rectangle();
        this.tabsContainerHolder.setClip((Node)this.tabsClip);
        this.getChildren().add(0, (Object)this.tabsContainerHolder);
        for (Tab tab : ((JFXTabPane)this.getSkinnable()).getTabs()) {
            this.addTabContentHolder(tab);
        }
        this.clip = new Rectangle(tabPane.getWidth(), tabPane.getHeight());
        ((JFXTabPane)this.getSkinnable()).setClip((Node)this.clip);
        if (((JFXTabPane)this.getSkinnable()).getTabs().isEmpty()) {
            this.header.setVisible(false);
        }
        this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((JFXTabPane)this.getSkinnable()).getSelectionModel().select(((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((JFXTabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.header.headersRegion.setOnMouseDragged(me -> {
            this.header.updateScrollOffset(this.offsetStart + (this.isHorizontal() ? me.getSceneX() : me.getSceneY()) - this.dragStart);
            me.consume();
        });
        ((JFXTabPane)this.getSkinnable()).addEventHandler(MouseEvent.MOUSE_PRESSED, me -> {
            this.dragStart = this.isHorizontal() ? me.getSceneX() : me.getSceneY();
            this.offsetStart = this.header.scrollOffset;
        });
        ((JFXTabPane)this.getSkinnable()).getTabs().addListener(change -> {
            ArrayList tabsToBeRemoved = new ArrayList();
            ArrayList tabsToBeAdded = new ArrayList();
            int insertIndex = -1;
            while (change.next()) {
                if (change.wasPermutated()) {
                    Tab selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
                    ArrayList<Tab> permutatedTabs = new ArrayList<Tab>(change.getTo() - change.getFrom());
                    ((JFXTabPane)this.getSkinnable()).getSelectionModel().clearSelection();
                    for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        permutatedTabs.add((Tab)((JFXTabPane)this.getSkinnable()).getTabs().get(i));
                    }
                    this.removeTabs(permutatedTabs);
                    this.addTabs(permutatedTabs, change.getFrom());
                    ((JFXTabPane)this.getSkinnable()).getSelectionModel().select((Object)selectedTab);
                }
                if (change.wasRemoved()) {
                    tabsToBeRemoved.addAll(change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                tabsToBeAdded.addAll(change.getAddedSubList());
                insertIndex = change.getFrom();
            }
            tabsToBeRemoved.removeAll(tabsToBeAdded);
            this.removeTabs(tabsToBeRemoved);
            if (!tabsToBeAdded.isEmpty()) {
                for (TabContentHolder tabContentHolder : this.tabContentHolders) {
                    TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tabContentHolder.tab);
                    if (tabHeaderContainer.isClosing) continue;
                    tabsToBeAdded.remove(tabContentHolder.tab);
                }
                this.addTabs(tabsToBeAdded, insertIndex == -1 ? this.tabContentHolders.size() : insertIndex);
            }
            ((JFXTabPane)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)tabPane.getSelectionModel().selectedItemProperty(), obs -> {
            this.isSelectingTab = true;
            this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
            ((JFXTabPane)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)tabPane.widthProperty(), obs -> this.clip.setWidth(((JFXTabPane)this.getSkinnable()).getWidth()));
        this.registerChangeListener((ObservableValue)tabPane.heightProperty(), obs -> this.clip.setHeight(((JFXTabPane)this.getSkinnable()).getHeight()));
    }

    private static int getRotation(Side pos) {
        return switch (2.$SwitchMap$javafx$geometry$Side[pos.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> 0;
            case 2 -> 180;
            case 3 -> -90;
            case 4 -> 90;
        };
    }

    private void removeTabs(List<? extends Tab> removedTabs) {
        for (Tab tab : removedTabs) {
            TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.isClosing = true;
            this.removeTab(tab);
            if (!((JFXTabPane)this.getSkinnable()).getTabs().isEmpty()) continue;
            this.header.setVisible(false);
        }
        this.removedTabs = !removedTabs.isEmpty();
    }

    private void addTabs(List<? extends Tab> addedTabs, int startIndex) {
        int i = 0;
        for (Tab tab : addedTabs) {
            if (!this.header.isVisible()) {
                this.header.setVisible(true);
            }
            this.header.addTab(tab, startIndex + i++, false);
            this.addTabContentHolder(tab);
            TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.setVisible(true);
            tabHeaderContainer.inner.requestLayout();
        }
    }

    private void addTabContentHolder(Tab tab) {
        TabContentHolder tabContentHolder = new TabContentHolder(this, tab);
        tabContentHolder.setClip((Node)new Rectangle());
        this.tabContentHolders.add((Object)tabContentHolder);
        this.tabsContainer.getChildren().add(0, (Object)tabContentHolder);
    }

    private void removeTabContentHolder(Tab tab) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            if (!tabContentHolder.tab.equals(tab)) continue;
            tabContentHolder.removeListeners(tab);
            this.getChildren().remove((Object)tabContentHolder);
            this.tabContentHolders.remove((Object)tabContentHolder);
            this.tabsContainer.getChildren().remove((Object)tabContentHolder);
            break;
        }
    }

    private void removeTab(Tab tab) {
        TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
        if (tabHeaderContainer != null) {
            tabHeaderContainer.removeListeners();
        }
        this.header.removeTab(tab);
        this.removeTabContentHolder(tab);
        this.header.requestLayout();
    }

    private boolean isHorizontal() {
        Side tabPosition = ((JFXTabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)tabPosition) || Side.BOTTOM.equals((Object)tabPosition);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxWidth = Math.max(this.maxWidth, this.snapSizeX(tabContentHolder.prefWidth(-1.0)));
        }
        double headerContainerWidth = this.snapSizeX(this.header.prefWidth(-1.0));
        double prefWidth = Math.max(this.maxWidth, headerContainerWidth);
        return this.snapSizeX(prefWidth) + rightInset + leftInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxHeight = Math.max(this.maxHeight, this.snapSizeX(tabContentHolder.prefHeight(-1.0)));
        }
        double headerContainerHeight = this.snapSizeX(this.header.prefHeight(-1.0));
        double prefHeight = this.maxHeight + this.snapSizeX(headerContainerHeight);
        return this.snapSizeX(prefHeight) + topInset + bottomInset;
    }

    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.header.getBaselineOffset() + topInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double headerHeight = this.snapSizeX(this.header.prefHeight(-1.0));
        Side side = ((JFXTabPane)this.getSkinnable()).getSide();
        double tabsX = side == Side.RIGHT ? x + w - headerHeight : x;
        double tabsY = side == Side.BOTTOM ? y + h - headerHeight : y;
        int rotation = CustomJFXTabPaneSkin.getRotation((Side)side);
        switch (2.$SwitchMap$javafx$geometry$Side[side.ordinal()]) {
            case 1: {
                this.header.resize(w, headerHeight);
                this.header.relocate(tabsX, tabsY);
                break;
            }
            case 3: {
                this.header.resize(h, headerHeight);
                this.header.relocate(tabsX + headerHeight, h - headerHeight);
                break;
            }
            case 4: {
                this.header.resize(h, headerHeight);
                this.header.relocate(tabsX, y - headerHeight);
                break;
            }
            case 2: {
                this.header.resize(w, headerHeight);
                this.header.relocate(w, tabsY - headerHeight);
            }
        }
        this.header.getTransforms().setAll((Object[])new Transform[]{new Rotate((double)rotation, 0.0, headerHeight, 1.0)});
        double contentStartX = x + (side == Side.LEFT ? headerHeight : 0.0);
        double contentStartY = y + (side == Side.TOP ? headerHeight : 0.0);
        double contentWidth = w - (this.isHorizontal() ? 0.0 : headerHeight);
        double contentHeight = h - (this.isHorizontal() ? headerHeight : 0.0);
        this.tabsClip.setWidth(contentWidth);
        this.tabsClip.setHeight(contentHeight);
        this.tabsContainerHolder.resize(contentWidth, contentHeight);
        this.tabsContainerHolder.relocate(contentStartX, contentStartY);
        this.tabsContainer.resize(contentWidth * (double)this.tabContentHolders.size(), contentHeight);
        int max = this.tabContentHolders.size();
        for (int i = 0; i < max; ++i) {
            TabContentHolder tabContentHolder = (TabContentHolder)this.tabContentHolders.get(i);
            tabContentHolder.setVisible(true);
            tabContentHolder.setTranslateX(contentWidth * (double)i);
            if (tabContentHolder.getClip() != null) {
                ((Rectangle)tabContentHolder.getClip()).setWidth(contentWidth);
                ((Rectangle)tabContentHolder.getClip()).setHeight(contentHeight);
            }
            if (tabContentHolder.tab == this.selectedTab) {
                int index = ((JFXTabPane)this.getSkinnable()).getTabs().indexOf((Object)this.selectedTab);
                if (index != i) {
                    this.tabsContainer.setTranslateX(-contentWidth * (double)i);
                    this.diffTabsIndices = i - index;
                } else {
                    if (this.diffTabsIndices != 0) {
                        this.tabsContainer.setTranslateX(this.tabsContainer.getTranslateX() + contentWidth * (double)this.diffTabsIndices);
                        this.diffTabsIndices = 0;
                    }
                    if (this.isSelectingTab && !((JFXTabPane)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                        new /* Unavailable Anonymous Inner Class!! */.play();
                    } else {
                        this.tabsContainer.setTranslateX(-contentWidth * (double)index);
                    }
                }
            }
            tabContentHolder.resize(contentWidth, contentHeight);
        }
    }
}

