/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix;

import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.jfoenix.JFXTextFieldSkin;
import java.lang.reflect.Field;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFXTextFieldSkin<T extends TextField>
extends TextFieldSkin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JFXTextFieldSkin.class);
    private final Pane textPane = (Pane)this.getChildren().get(0);
    private final ValidationPane<T> errorContainer;
    private final PromptLinesWrapper<T> linesWrapper;
    private boolean invalid = true;
    private Text promptText;
    private Node textNode;
    private DoubleProperty textTranslateX;

    public JFXTextFieldSkin(T textField) {
        super(textField);
        this.reflectionFieldConsumer("textNode", field -> {
            this.textNode = (Node)field.get(this);
        });
        this.reflectionFieldConsumer("textTranslateX", field -> {
            this.textTranslateX = (DoubleProperty)field.get(this);
        });
        this.textPane.prefWidthProperty().bind((ObservableValue)textField.widthProperty().add(-20));
        this.textPane.maxWidthProperty().bind((ObservableValue)textField.widthProperty().add(-20));
        this.linesWrapper = new PromptLinesWrapper(textField, super.promptTextFillProperty(), (ObservableValue)textField.textProperty(), (ObservableValue)textField.promptTextProperty(), () -> this.promptText);
        this.linesWrapper.init(() -> this.customCreatePromptNode(), new Node[]{this.textPane});
        this.reflectionFieldConsumer("usePromptText", field -> field.set(this, this.linesWrapper.usePromptText));
        this.errorContainer = new ValidationPane(textField);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextField)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, Math.floor(h));
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
            this.customUpdateTextPos();
        }
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void customUpdateTextPos() {
        double textWidth = this.textNode.getLayoutBounds().getWidth();
        double promptWidth = this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getWidth();
        switch (1.$SwitchMap$javafx$geometry$HPos[((TextField)this.getSkinnable()).getAlignment().getHpos().ordinal()]) {
            case 1: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth / 2.0);
                break;
            }
            case 2: {
                this.linesWrapper.promptTextScale.setPivotX(0.0);
                break;
            }
            case 3: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth);
            }
        }
    }

    private void customCreatePromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextField)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextField)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind((ObservableValue)this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextField)this.getSkinnable()).isFocused() && ((IFXLabelFloatControl)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.textPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            this.reflectionFieldConsumer("promptNode", field -> {
                Object oldValue = field.get(this);
                if (oldValue != null) {
                    this.textPane.getChildren().remove(oldValue);
                }
                field.set(this, this.promptText);
            });
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private <T> void reflectionFieldConsumer(String fieldName, CheckedConsumer<Field> consumer) {
        Field field = null;
        try {
            field = TextFieldSkin.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            consumer.accept((Object)field);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

