/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceData;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.io.DocumentParser;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.WordAlternativesPopup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentDeserializer.class);

    public ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> deserialize(String xmlContent) throws IOException, ParserConfigurationException, SAXException {
        Document doc = new DocumentParser(xmlContent).parse();
        return this.convertToStyledDocument(doc);
    }

    private ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> convertToStyledDocument(Document document) {
        ReadOnlyStyledDocument finalDoc = ReadOnlyStyledDocument.fromString((String)"", (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (TextOps)TranscriptTextArea.STYLED_TEXT_OPS);
        NodeList paragraphs = document.getElementsByTagName("Paragraph");
        for (int idx = 0; idx < paragraphs.getLength(); ++idx) {
            Element paragraph = (Element)paragraphs.item(idx);
            ParStyle paraStyle = ParStyle.fromCss((String)paragraph.getAttribute("style"));
            NodeList segments = paragraph.getChildNodes();
            TextStyle style = TextStyle.EMPTY;
            for (int segIdx = 0; segIdx < segments.getLength(); ++segIdx) {
                ReadOnlyStyledDocument ros;
                Node node = segments.item(segIdx);
                switch (node.getNodeName()) {
                    case "Timestamp": {
                        ReadOnlyStyledDocument readOnlyStyledDocument = this.createTimestampElement(paraStyle, style, (Element)node);
                        break;
                    }
                    case "Speaker": {
                        ReadOnlyStyledDocument readOnlyStyledDocument = this.createSpeakerElement(paraStyle, (Element)node);
                        break;
                    }
                    case "StyledText": {
                        Pair pair = this.createStyledTextElement(paraStyle, style, (Element)node);
                        style = (TextStyle)pair.getLeft();
                        ReadOnlyStyledDocument readOnlyStyledDocument = (ReadOnlyStyledDocument)pair.getRight();
                        break;
                    }
                    case "lct": {
                        ReadOnlyStyledDocument readOnlyStyledDocument = this.createLowConfidenceElement(paraStyle, style, (Element)node);
                        break;
                    }
                    default: {
                        ReadOnlyStyledDocument readOnlyStyledDocument = ros = null;
                    }
                }
                if (ros == null) continue;
                finalDoc = finalDoc.concat((StyledDocument)ros);
            }
            if (idx >= paragraphs.getLength() - 1) continue;
            finalDoc = finalDoc.concat((StyledDocument)ReadOnlyStyledDocument.fromString((String)"\n", (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (TextOps)TranscriptTextArea.STYLED_TEXT_OPS));
        }
        return finalDoc;
    }

    private ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> createTimestampElement(ParStyle paraStyle, TextStyle style, Element node) {
        if (!node.hasAttribute("ms")) {
            log.warn("Missing ms attribute for timestamp segment.");
            return null;
        }
        long timestamp = Long.parseLong(node.getAttribute("ms"));
        return ReadOnlyStyledDocument.fromSegment((Object)new TimestampSegment((Object)timestamp), (Object)paraStyle, (Object)style, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    private ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> createLowConfidenceElement(ParStyle paraStyle, TextStyle style, Element node) {
        if (!node.hasAttribute("conf")) {
            log.warn("Missing confidence attribute for low confidence segment.");
            return null;
        }
        float confidence = Float.parseFloat(node.getAttribute("conf"));
        ArrayList<String> alternatives = new ArrayList<String>(Arrays.stream(node.getAttribute("alt").split(",")).filter(entry -> !entry.isEmpty()).toList());
        return ReadOnlyStyledDocument.fromSegment((Object)new LowConfidenceSegment(new LowConfidenceData(node.getTextContent(), confidence, alternatives)), (Object)paraStyle, (Object)style, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    private ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle> createSpeakerElement(ParStyle paraStyle, Element node) {
        if (!node.hasAttribute("uuid")) {
            log.warn("Missing uuid attribute for speaker segment.");
            return null;
        }
        return ReadOnlyStyledDocument.fromSegment((Object)new SpeakerSegment((Object)node.getAttribute("uuid")), (Object)paraStyle, (Object)TextStyle.EMPTY, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
    }

    private Pair<TextStyle, ReadOnlyStyledDocument<ParStyle, AbstractSegment<?>, TextStyle>> createStyledTextElement(ParStyle paraStyle, TextStyle style, Element styledText) {
        String text = styledText.getTextContent();
        if ((style = this.getTextStyle(style, styledText, text)) == null) {
            return Pair.of(null, null);
        }
        if (style.textColorOptional.isPresent()) {
            style = style.updateTextColor(null);
        }
        ReadOnlyStyledDocument ros = style.wordConfidenceOptional.isPresent() && (double)((Float)style.wordConfidenceOptional.get()).floatValue() < 0.5 ? ReadOnlyStyledDocument.fromSegment((Object)new LowConfidenceSegment(new LowConfidenceData(text, ((Float)style.wordConfidenceOptional.get()).floatValue(), WordAlternativesPopup.getWordsFromStyle((TextStyle)style))), (Object)paraStyle, (Object)TextStyle.EMPTY, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS) : ReadOnlyStyledDocument.fromSegment((Object)new StyledTextSegment((Object)text), (Object)paraStyle, (Object)style, (SegmentOps)TranscriptTextArea.STYLED_TEXT_OPS);
        return Pair.of((Object)style, (Object)ros);
    }

    private TextStyle getTextStyle(TextStyle previousStyle, Element styledText, String text) {
        if (!text.isEmpty()) {
            return TextStyle.fromNode((Element)styledText);
        }
        return previousStyle != null ? previousStyle : TranscriptTextArea.getDefaultTextStyle();
    }

    @Generated
    public DocumentDeserializer() {
    }
}

