/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentParser {
    private final String xmlContent;

    public DocumentParser(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    public Document parse() throws ParserConfigurationException, SAXException, IOException {
        String fixedXml = this.fixXML(this.xmlContent);
        return this.getXMLDocument(new StringReader(fixedXml));
    }

    private String fixXML(String xml) {
        String xml10pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
        xml = xml.replaceAll(xml10pattern, "");
        xml = xml.replaceAll("&#[0-8];", "");
        return xml;
    }

    private Document getXMLDocument(StringReader stringReader) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(stringReader));
        doc.getDocumentElement().normalize();
        return doc;
    }
}

