/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import eu.ewerkzeug.easytranscript3.commons.io.ProcessInputStream;
import eu.ewerkzeug.easytranscript3.commons.io.ProcessListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.FileSystemResource;

public class ObservableFileSystemResource
extends FileSystemResource {
    private ProcessListener listener;

    public ObservableFileSystemResource(Path filePath) {
        super(filePath);
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        try {
            ProcessInputStream processInputStream = new ProcessInputStream(Files.newInputStream(super.getFile().toPath(), new OpenOption[0]), this.getFile().length());
            processInputStream.addListener(this.listener);
            return processInputStream;
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Generated
    public void setListener(ProcessListener listener) {
        this.listener = listener;
    }
}

