/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import eu.ewerkzeug.easytranscript3.commons.io.ProcessListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ProcessInputStream
extends InputStream {
    private final InputStream in;
    private final long length;
    private final List<ProcessListener> processListeners;
    private int sumRead;
    private double percent;

    public ProcessInputStream(InputStream inputStream, long length) throws IOException {
        this.in = inputStream;
        this.processListeners = new ArrayList();
        this.sumRead = 0;
        this.length = length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readCount = this.in.read(b);
        this.evaluatePercent((long)readCount);
        return readCount;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readCount = this.in.read(b, off, len);
        this.evaluatePercent((long)readCount);
        return readCount;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.evaluatePercent(skip);
        return skip;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            this.evaluatePercent(1L);
        }
        return read;
    }

    public ProcessInputStream addListener(ProcessListener processListener) {
        this.processListeners.add(processListener);
        return this;
    }

    private void evaluatePercent(long readCount) {
        if (readCount != -1L) {
            this.sumRead = (int)((long)this.sumRead + readCount);
            this.percent = (double)this.sumRead * 1.0 / (double)this.length;
        }
        this.notifyListener();
    }

    private void notifyListener() {
        for (ProcessListener processListener : this.processListeners) {
            processListener.process(this.percent);
        }
    }
}

