/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.io.ETReplaceExistingFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.lingala.zip4j.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ZipService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZipService.class);

    public boolean isZipFile(Path path) {
        boolean bl;
        ZipFile file = new ZipFile(path.toFile());
        try {
            bl = file.isValidZipFile();
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.warn("Could not read file as a zip file.", (Throwable)e);
                return false;
            }
        }
        file.close();
        return bl;
    }

    public void unzipFile(Path zip, Path destination) throws IOException {
        log.debug("Unzipping file {} to {}...", (Object)zip.getFileName(), (Object)destination);
        try (ZipFile file = new ZipFile(zip.toFile());){
            file.extractAll(destination.toAbsolutePath().toString());
        }
    }

    public void zipFiles(List<File> filesToZip, File destination) throws IOException {
        File tempFile;
        block11: {
            log.debug("Zipping files to {}...", (Object)destination);
            tempFile = Main.getEasytranscriptTempDirectory().resolve(String.valueOf(UUID.randomUUID()) + ".ett").toFile();
            String path = tempFile.toString();
            try (ZipFile file = new ZipFile(path);){
                file.addFiles(filesToZip);
            }
            try {
                Files.createDirectories(destination.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) break block11;
                log.warn("Could not create the directories.", (Throwable)e);
            }
        }
        try {
            Files.move(tempFile.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileAlreadyExistsException e) {
            log.error("Attempted to zip files, but failed as destination is not writable.", (Throwable)e);
            throw new ETReplaceExistingFailedException();
        }
        catch (NoSuchFileException e) {
            log.error("Could not move zip file to destination.");
            throw e;
        }
    }
}

