/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.TableExporter;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class CSVExporter
implements TableExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CSVExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("timeTrackingScreen.csvExport") + " (*.csv)", new String[]{"*.csv"});

    public void export(ArrayList<TimeTrackingEntry> doc, Path file) throws Exception {
        log.debug("Exporting time tracking entries as a csv file...");
        log.debug("Path: {}", (Object)file.toString());
        try (ICSVWriter writer = new CSVWriterBuilder((Writer)new FileWriter(file.toFile())).withSeparator(';').build();){
            log.debug("Adding headers...");
            writer.writeNext(new String[]{Utils.getLocaleBundle().getString("timeTrackingScreen.start"), Utils.getLocaleBundle().getString("timeTrackingScreen.end"), Utils.getLocaleBundle().getString("timeTrackingScreen.duration")});
            log.debug("Adding lines for time tracking entries...");
            for (TimeTrackingEntry timeTrackingEntry : doc) {
                writer.writeNext(new String[]{timeTrackingEntry.getStartProperty(), timeTrackingEntry.getEndProperty(), timeTrackingEntry.getDurationProperty()});
            }
            log.info("Exported time tracking entries as csv file.");
        }
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

