/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.navigation.TextNavigation;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
@Lazy
public class ODTExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODTExporter.class);
    private static final char SIGN = '\u200b';
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("OpenDocument Text (*.odt)", new String[]{"*.odt"});

    public void export(StyledDocument<ParStyle, AbstractSegment, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a odt file...");
        TextDocument outputOdt = TextDocument.newTextDocument();
        log.debug("Processing paragraphs of document...");
        int i = 0;
        for (org.fxmisc.richtext.model.Paragraph documentParagraph : document.getParagraphs()) {
            log.debug("Processing paragraph {} of {}", (Object)i, (Object)document.getParagraphs().size());
            Paragraph odtParagraph = this.addParagraph(outputOdt);
            int j = 0;
            for (StyledSegment styledSegment : documentParagraph.getStyledSegments()) {
                TextStyle style;
                log.debug("Processing text segment {} of {}", (Object)j, (Object)documentParagraph.getStyledSegments().size());
                Object object = styledSegment.getSegment();
                if (object instanceof HasPreDefinedStyle) {
                    HasPreDefinedStyle hasPreDefinedStyle = (HasPreDefinedStyle)object;
                    style = hasPreDefinedStyle.getTextStyle();
                } else {
                    style = (TextStyle)styledSegment.getStyle();
                }
                AtomicReference<String> fontFamily = new AtomicReference<String>(Configuration.get().getFormattingFont());
                style.fontFamilyOptional.ifPresent(fontFamily::set);
                AtomicBoolean bold = new AtomicBoolean(false);
                AtomicBoolean italic = new AtomicBoolean(false);
                AtomicBoolean underlined = new AtomicBoolean(false);
                style.boldOptional.ifPresent(bold::set);
                style.italicOptional.ifPresent(italic::set);
                style.underlineOptional.ifPresent(underlined::set);
                StyleTypeDefinitions.FontStyle fontStyle = StyleTypeDefinitions.FontStyle.REGULAR;
                if (bold.get() && italic.get()) {
                    fontStyle = StyleTypeDefinitions.FontStyle.BOLDITALIC;
                } else if (bold.get()) {
                    fontStyle = StyleTypeDefinitions.FontStyle.BOLD;
                } else if (italic.get()) {
                    fontStyle = StyleTypeDefinitions.FontStyle.ITALIC;
                }
                Color textColor = Color.BLACK;
                this.addText(outputOdt, odtParagraph, ((AbstractSegment)styledSegment.getSegment()).getRealText(), fontFamily.get().replace("\"", ""), fontStyle, (double)style.fontSizeOptional.orElse(12).intValue(), textColor, underlined.get() ? StyleTypeDefinitions.TextLinePosition.UNDER : StyleTypeDefinitions.TextLinePosition.REGULAR);
                ++j;
            }
            ++i;
        }
        log.debug("Processed document. Writing to disk ...");
        TextNavigation navigation = new TextNavigation(Pattern.quote("\u200b"), (Document)outputOdt);
        while (navigation.hasNext()) {
            navigation.nextSelection().cut();
        }
        outputOdt.save(out.toFile());
        log.info("Exported document as odt file.");
    }

    private Paragraph addParagraph(TextDocument textDocument) {
        return textDocument.addParagraph("");
    }

    private void addText(TextDocument textDocument, Paragraph p, String text, String fontFamilyName, StyleTypeDefinitions.FontStyle fontStyle, double fontSize, Color color, StyleTypeDefinitions.TextLinePosition textLinePosition) {
        p.appendTextContent("\u200b" + text, false);
        TextNavigation navigation = new TextNavigation(Pattern.quote(text) + "\\z", (Document)textDocument);
        TextSelection sel = (TextSelection)navigation.nextSelection();
        Span span = Span.newSpan((TextSelection)sel);
        Font font = new Font(fontFamilyName, fontStyle, fontSize, color, textLinePosition);
        span.getStyleHandler().getTextPropertiesForWrite().setFont(font);
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

