/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.exporters;

import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.DocumentExporter;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
@Lazy
public class PDFExporter
implements DocumentExporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PDFExporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("PDF (*.pdf)", new String[]{"*.pdf"});

    public void export(StyledDocument<ParStyle, AbstractSegment, TextStyle> document, Path out) throws Exception {
        log.debug("Exporting document as a pdf file...");
        log.debug("Serialized content. Writing ...");
        try (FileOutputStream os = new FileOutputStream(out.toFile());){
            PdfRendererBuilder builder = new PdfRendererBuilder();
            String content = Transcript.documentToHtml((StyledDocument)TranscriptTextArea.get().getDocument());
            builder.withHtmlContent(content, "");
            builder.toStream((OutputStream)os);
            builder.run();
        }
        catch (Exception e) {
            log.error("Failed to write file.", (Throwable)e);
            throw e;
        }
        log.info("Exported document as pdf file.");
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

