/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.HTMLImporter;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import javafx.stage.FileChooser;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.rtf.RTFParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.xml.sax.ContentHandler;

@Component
@Lazy
public class RTFImporter
extends DocumentImporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RTFImporter.class);
    private final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter("Rich-Text-Format (*.rtf)", new String[]{"*.rtf"});
    private final HTMLImporter htmlImporter;

    public RTFImporter(HTMLImporter htmlImporter) {
        this.htmlImporter = htmlImporter;
    }

    public void importTranscript(Path file, String timestampFormat) throws IOException, TransformerConfigurationException {
        this.importTranscript(file, timestampFormat, Transcript.get());
    }

    public void importTranscript(Path file, String timestampFormat, Transcript transcript) throws IOException, TransformerConfigurationException {
        log.debug("Importing rtf file as a transcript document...");
        RTFParser rtfParser = new RTFParser();
        StringWriter sw = new StringWriter();
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("standalone", "yes");
        handler.getTransformer().setOutputProperty("method", "html");
        handler.getTransformer().setOutputProperty("indent", "no");
        handler.setResult(new StreamResult(sw));
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            rtfParser.parse((InputStream)fis, (ContentHandler)handler, new Metadata(), new ParseContext());
            String s = sw.toString();
            s = s.replace("<p/>", "<br/>");
            s = s.replace("<title/>", "<title></title>");
            transcript.setDocument(this.htmlImporter.htmlToTranscript(s, timestampFormat));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        log.info("Imported rtf file as a transcript document.");
    }

    @Generated
    public FileChooser.ExtensionFilter getFilter() {
        return this.filter;
    }
}

