/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.io.importers;

import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TimestampProcessor;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimestampProcessor.class);
    private final String timestampFormat;
    private Pattern pattern;
    private DateTimeFormatter dateTimeFormatter;

    public TimestampProcessor(String timestampFormat) {
        String regexPattern = DocumentImporter.getRegexForTimestamp((String)timestampFormat);
        log.debug("Regex pattern for timestamps: {}", (Object)regexPattern);
        log.debug("Timestamp format: {}", (Object)timestampFormat);
        this.timestampFormat = timestampFormat;
        if (!regexPattern.isEmpty()) {
            this.pattern = Pattern.compile(regexPattern);
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(timestampFormat).withZone(ZoneId.of("GMT"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Content> getContentParts(String text) {
        ArrayList<Content> returner = new ArrayList<Content>();
        if (this.timestampFormat.isEmpty()) {
            log.debug("No timestamp format set. Returning text as a single part.");
            returner.add((Content)new TextContent(text));
            return returner;
        }
        Matcher matcher = this.pattern.matcher(text);
        int start = 0;
        while (matcher.find()) {
            returner.add((Content)new TextContent(text.substring(start, matcher.start())));
            try {
                String group = matcher.group();
                long time = Instant.from(this.dateTimeFormatter.parse(group)).toEpochMilli();
                returner.add((Content)new TimestampContent(Long.toString(time)));
            }
            catch (Exception e) {
                log.warn("Could not parse and therefore ignored timestamp {}", (Object)matcher.group(), (Object)e);
                returner.add((Content)new TextContent(matcher.group()));
                ArrayList<Content> arrayList = returner;
                return arrayList;
            }
            finally {
                start = matcher.end();
            }
        }
        if (start != text.length()) {
            returner.add((Content)new TextContent(text.substring(start)));
        }
        return returner;
    }
}

