/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.tutorials;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Content;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.FlowControl;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Highlight;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialSection;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialStep;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerController;
import eu.ewerkzeug.easytranscript3.mvc.main.drawer.DrawerService;
import java.time.Duration;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawerTutorial
implements Tutorial {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DrawerTutorial.class);
    private final DrawerService drawerService;
    private final DrawerController drawerController;
    private final ResourceBundle tutorialBundle = Utils.getTutorialLocaleBundle();

    public TutorialSection get() {
        return TutorialSection.builder().step(this.getTextStyleStep()).step(this.getSpeakerStep()).step(this.getShortcutsStep()).step(this.finishStep()).build();
    }

    private TutorialStep finishStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().goingBackAllowed(false).build()).content(Content.builder().title(this.tutorialBundle.getString("tutorials.youDidIt")).description(this.tutorialBundle.getString("drawer.success.description")).build()).build();
    }

    private TutorialStep getTextStyleStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().beforeShow(() -> {
            this.drawerController.openDrawer();
            this.drawerController.getTextTitledPane().setExpanded(true);
        }).waitBeforeShow(Duration.ofMillis(400L)).build()).highlight(Highlight.builder().node(() -> ((DrawerController)this.drawerController).getTextTitledPane()).build()).content(Content.builder().title(this.tutorialBundle.getString("drawer.formattingStep.title")).description(this.tutorialBundle.getString("drawer.formattingStep.description")).build()).build();
    }

    private TutorialStep getShortcutsStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().beforeShow(() -> {
            this.drawerController.openDrawer();
            this.drawerController.getShortcutsTitledPane().setExpanded(true);
        }).build()).highlight(Highlight.builder().node(() -> ((DrawerController)this.drawerController).getShortcutsTitledPane()).build()).content(Content.builder().title(this.tutorialBundle.getString("drawer.shortcutsStep.title")).description(this.tutorialBundle.getString("drawer.shortcutsStep.description")).build()).build();
    }

    private TutorialStep getSpeakerStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().beforeShow(() -> {
            this.drawerController.openDrawer();
            this.drawerController.getChangeOfSpeakerTitledPane().setExpanded(true);
        }).build()).highlight(Highlight.builder().node(() -> ((DrawerController)this.drawerController).getChangeOfSpeakerTitledPane()).build()).content(Content.builder().title(this.tutorialBundle.getString("drawer.changeOfSpeakerStep.title")).description(this.tutorialBundle.getString("drawer.changeOfSpeakerStep.description")).build()).build();
    }

    public boolean isPopup() {
        return false;
    }

    @Generated
    public DrawerTutorial(DrawerService drawerService, DrawerController drawerController) {
        this.drawerService = drawerService;
        this.drawerController = drawerController;
    }
}

