/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.tutorials;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Content;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.FlowControl;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.Highlight;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialSection;
import eu.ewerkzeug.easytranscript3.commons.types.tutorialstep.TutorialStep;
import eu.ewerkzeug.easytranscript3.mvc.main.playerbar.PlayerBarController;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerBarTutorial
implements Tutorial {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerBarTutorial.class);
    private final PlayerBarController playerBarController;
    private final ResourceBundle tutorialBundle = Utils.getTutorialLocaleBundle();

    public TutorialSection get() {
        return TutorialSection.builder().step(this.getWindingAndSpeedStep()).step(this.getPlayerMiddleSectionStep()).step(this.getPlayerVolumeStep()).step(this.finishStep()).build();
    }

    private TutorialStep finishStep() {
        return TutorialStep.builder().flowControl(FlowControl.builder().goingBackAllowed(false).build()).content(Content.builder().title(this.tutorialBundle.getString("tutorials.youDidIt")).description(this.tutorialBundle.getString("playerBar.success.description")).build()).build();
    }

    private TutorialStep getPlayerVolumeStep() {
        return TutorialStep.builder().highlight(Highlight.builder().node(() -> ((PlayerBarController)this.playerBarController).getPlayerBarVolumeGridPane()).build()).content(Content.builder().title(this.tutorialBundle.getString("playerBar.volumeStep.title")).description(this.tutorialBundle.getString("playerBar.volumeStep.description")).build()).build();
    }

    private TutorialStep getPlayerMiddleSectionStep() {
        return TutorialStep.builder().highlight(Highlight.builder().node(() -> ((PlayerBarController)this.playerBarController).getPlayerBarControlsVBox()).build()).content(Content.builder().title(this.tutorialBundle.getString("playerBar.playerMiddleSectionStep.title")).description(this.tutorialBundle.getString("playerBar.playerMiddleSectionStep.description")).build()).build();
    }

    private TutorialStep getWindingAndSpeedStep() {
        return TutorialStep.builder().highlight(Highlight.builder().node(() -> ((PlayerBarController)this.playerBarController).getPlayerBarSpeedGridPane()).build()).content(Content.builder().title(this.tutorialBundle.getString("playerBar.windingAndSpeedStep.title")).description(this.tutorialBundle.getString("playerBar.windingAndSpeedStep.description")).build()).build();
    }

    public boolean isPopup() {
        return false;
    }

    @Generated
    public PlayerBarTutorial(PlayerBarController playerBarController) {
        this.playerBarController = playerBarController;
    }
}

