/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.commons.types.ChannelDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.Theme;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.input.KeyCombination;
import javafx.scene.text.TextAlignment;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Configuration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final String ET_TAG = "easytranscript3";
    public static final String ET_HOME = SystemUtils.USER_HOME + "/easytranscript3";
    @JsonIgnore
    public static final Theme DEFAULT_THEME = Theme.SYNC_WITH_OS;
    @JsonIgnore
    private static final String DEFAULT_TIMESTAMP_FORMAT = "#HH:mm:ss-SSS#";
    private static final StringProperty timestampsFormat = new SimpleStringProperty("#HH:mm:ss-SSS#");
    private static final int MAXIMUM_TRANSCRIPTS_IN_RECENT_LOADED = 19;
    private static final String PROGRAM_SETTINGS_NAME = "programSettings.json";
    @JsonIgnore
    static boolean malformed = false;
    private static Configuration configuration;
    @JsonDeserialize(using=ChannelDeserializer.class)
    private final ObjectProperty<Channel> channel = new SimpleObjectProperty((Object)Channel.STABLE);
    private final BooleanProperty timestampsOnBeginning = new SimpleBooleanProperty(false);
    private final BooleanProperty timestampsOnEnd = new SimpleBooleanProperty(true);
    private final BooleanProperty drawerExpanded = new SimpleBooleanProperty(true);
    private final StringProperty formattingFont = new SimpleStringProperty("Monospaced");
    private final IntegerProperty formattingSize = new SimpleIntegerProperty(12);
    private final BooleanProperty formattingBold = new SimpleBooleanProperty(false);
    private final BooleanProperty formattingItalic = new SimpleBooleanProperty(false);
    private final BooleanProperty formattingUnderlined = new SimpleBooleanProperty(false);
    private final ObjectProperty<TextAlignment> formattingParagraphAlignment = new SimpleObjectProperty((Object)TextAlignment.LEFT);
    private final BooleanProperty autocompletionActive = new SimpleBooleanProperty(false);
    private final IntegerProperty autocompletionThreshold = new SimpleIntegerProperty(3);
    private final BooleanProperty autoCorrectionActive = new SimpleBooleanProperty(false);
    private final BooleanProperty autoRecoverActive = new SimpleBooleanProperty(true);
    private final IntegerProperty autoRecoverTimer = new SimpleIntegerProperty(5);
    private final BooleanProperty autosaveActive = new SimpleBooleanProperty(true);
    private final IntegerProperty autosaveInterval = new SimpleIntegerProperty(5);
    private final IntegerProperty windingInterval = new SimpleIntegerProperty(4);
    private final BooleanProperty autoRewindAfterPause = new SimpleBooleanProperty(true);
    private final BooleanProperty additionalLineAfterEnter = new SimpleBooleanProperty(true);
    private final ObjectProperty<KeyCombination> playerRewind = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"F3"));
    private final ObjectProperty<KeyCombination> playerPlayPause = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"F4"));
    private final ObjectProperty<KeyCombination> playerFastForward = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"F5"));
    private final ObjectProperty<KeyCombination> playerQuieter = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Down"));
    private final ObjectProperty<KeyCombination> playerLouder = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Up"));
    private final ObjectProperty<KeyCombination> playerSlower = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Left"));
    private final ObjectProperty<KeyCombination> playerFaster = new SimpleObjectProperty((Object)KeyCombination.valueOf((String)"Shortcut+Shift+Right"));
    private final BooleanProperty useVLCPlayer = new SimpleBooleanProperty(true);
    private final StringProperty vlcPath = new SimpleStringProperty("");
    private final StringProperty programLanguage = new SimpleStringProperty(Locale.getDefault().getLanguage());
    private final BooleanProperty programAutomaticUpdateSearch = new SimpleBooleanProperty(true);
    private final ArrayList<String> programRecentLoaded = new ArrayList();
    private final StringProperty author = new SimpleStringProperty();
    private final BooleanProperty integrateVideoplayer = new SimpleBooleanProperty(true);
    private final BooleanProperty useSavedLastPlayerTime = new SimpleBooleanProperty(false);
    private final StringProperty theme = new SimpleStringProperty(DEFAULT_THEME.toString());
    private final DoubleProperty widthOfTextAreaInCm = new SimpleDoubleProperty(-1.0);
    private final BooleanProperty showParagraphNumbers = new SimpleBooleanProperty(false);
    private final LongProperty timestampOffset = new SimpleLongProperty(0L);
    private final HashSet<String> seenTutorials = new HashSet();
    @JsonIgnore
    private Version version = Version.of((long)0L);
    @JsonIgnore
    private String commitIdOfVersion = "unknown";
    @JsonIgnore
    private String commitDateOfVersion = "unknown";
    @JsonIgnore
    private ObservableList<String> programRecentLoadedObservableList;
    private String logLevel = Level.INFO.toString();
    private List<String> queuedLogs = new ArrayList();

    private Configuration() {
        InputStream is;
        log.debug("Reading version properties...");
        try {
            is = this.getClass().getResourceAsStream("/version.properties");
            try {
                Properties versionProp = new Properties();
                versionProp.load(is);
                this.version = this.getVersionFromString(versionProp.get("version").toString());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException | NullPointerException e) {
            log.error("", (Throwable)e);
        }
        log.debug("Reading git properties...");
        try {
            is = this.getClass().getResourceAsStream("/git.properties");
            try {
                Properties p = new Properties();
                p.load(is);
                this.commitIdOfVersion = p.getProperty("git.commit.id.abbrev");
                this.commitDateOfVersion = p.getProperty("git.commit.time");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    public static synchronized Configuration get() {
        if (configuration == null) {
            log.debug("Configuration not loaded yet.");
            configuration = new Configuration();
            Path configPath = Path.of(ET_HOME, new String[0]).resolve("programSettings.json");
            if (!Files.exists(configPath, new LinkOption[0])) {
                log.info("Configuration file does not exist yet in {}", (Object)configPath);
                configuration.initialize();
            } else {
                try {
                    configuration.load();
                    Utils.setLoggingLevel((String)configuration.getLogLevel());
                }
                catch (Exception e) {
                    configuration.initialize();
                    log.error("Malformed programSettings. Reinitialized.", (Throwable)e);
                }
            }
        }
        return configuration;
    }

    private Version getVersionFromString(String versionString) {
        try {
            return Version.parse((String)versionString);
        }
        catch (UnexpectedCharacterException e) {
            log.error("Could not read version from version.properties.", (Throwable)e);
            return Version.of((long)3L, (long)99L, (long)0L);
        }
    }

    public String getTimestampsFormat() {
        return timestampsFormat.getValue();
    }

    public void setTimestampsFormat(String timestampsFormat) {
        try {
            String escapedFormat = timestampsFormat.replaceAll("(?<!')#(?!')", "'#'");
            DateTimeFormatter.ofPattern(escapedFormat);
            Configuration.timestampsFormat.setValue(escapedFormat);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid timestamp format: {}", (Object)timestampsFormat, (Object)e);
        }
    }

    private synchronized void initialize() {
        log.debug("Initializing configuration...");
        this.save();
        log.info("Initialized Configuration.");
    }

    public synchronized void save() {
        log.debug("Saving Configuration ...");
        try {
            Utils.getObjectMapper().writeValue(Path.of(ET_HOME, new String[0]).resolve("programSettings.json").toFile(), (Object)configuration);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
        log.info("Saved Configuration.");
    }

    private synchronized void load() {
        File file = Path.of(ET_HOME, new String[0]).resolve("programSettings.json").toFile();
        log.debug("Loading Configuration from {}...", (Object)file.getAbsolutePath());
        try {
            String json = Files.readString(file.toPath());
            json = Utils.removeControlCharactersFromJSON((String)json);
            configuration = (Configuration)Utils.getObjectMapper().readValue(json, Configuration.class);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
            return;
        }
        try {
            DateTimeFormatter.ofPattern(Configuration.get().getTimestampsFormat());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.error("Timestamp pattern {} is invalid.", (Object)Configuration.get().getTimestampsFormat());
            Configuration.get().setTimestampsFormat("#HH:mm:ss-SSS#");
            malformed = true;
        }
        if (malformed) {
            log.warn("Configuration has been corrected and needs to get saved.");
            malformed = false;
            this.save();
        }
        log.info("Loaded configuration.");
    }

    public Version getVersion() {
        return this.version;
    }

    public String getCommitIdOfVersion() {
        return this.commitIdOfVersion;
    }

    public boolean isTimestampsOnBeginning() {
        return this.timestampsOnBeginning.getValue();
    }

    public void setTimestampsOnBeginning(boolean timestampsOnBeginning) {
        this.timestampsOnBeginning.setValue(Boolean.valueOf(timestampsOnBeginning));
    }

    public boolean isTimestampsOnEnd() {
        return this.timestampsOnEnd.getValue();
    }

    public void setTimestampsOnEnd(boolean timestampsOnEnd) {
        this.timestampsOnEnd.setValue(Boolean.valueOf(timestampsOnEnd));
    }

    public BooleanProperty timestampsOnEndProperty() {
        return this.timestampsOnEnd;
    }

    public StringProperty timestampsFormatProperty() {
        return timestampsFormat;
    }

    public String getFormattingFont() {
        return this.formattingFont.getValue();
    }

    public void setFormattingFont(String formattingFont) {
        this.formattingFont.setValue(formattingFont);
    }

    public StringProperty formattingFontProperty() {
        return this.formattingFont;
    }

    public int getFormattingSize() {
        return this.formattingSize.getValue();
    }

    public void setFormattingSize(int formattingSize) {
        this.formattingSize.setValue((Number)formattingSize);
    }

    public IntegerProperty formattingSizeProperty() {
        return this.formattingSize;
    }

    public boolean isFormattingBold() {
        return this.formattingBold.getValue();
    }

    public void setFormattingBold(boolean formattingBold) {
        this.formattingBold.setValue(Boolean.valueOf(formattingBold));
    }

    public BooleanProperty formattingBoldProperty() {
        return this.formattingBold;
    }

    public boolean isFormattingItalic() {
        return this.formattingItalic.getValue();
    }

    public void setFormattingItalic(boolean formattingItalic) {
        this.formattingItalic.setValue(Boolean.valueOf(formattingItalic));
    }

    public BooleanProperty formattingItalicProperty() {
        return this.formattingItalic;
    }

    public boolean isFormattingUnderlined() {
        return this.formattingUnderlined.getValue();
    }

    public void setFormattingUnderlined(boolean formattingUnderlined) {
        this.formattingUnderlined.setValue(Boolean.valueOf(formattingUnderlined));
    }

    public BooleanProperty formattingUnderlinedProperty() {
        return this.formattingUnderlined;
    }

    public boolean isAutocompletionActive() {
        return this.autocompletionActive.getValue();
    }

    public void setAutocompletionActive(boolean autocompletionActive) {
        this.autocompletionActive.setValue(Boolean.valueOf(autocompletionActive));
    }

    public BooleanProperty autocompletionActiveProperty() {
        return this.autocompletionActive;
    }

    public int getAutocompletionThreshold() {
        return this.autocompletionThreshold.getValue();
    }

    public void setAutocompletionThreshold(int autocompletionThreshold) {
        this.autocompletionThreshold.setValue((Number)autocompletionThreshold);
    }

    public IntegerProperty autocompletionThresholdProperty() {
        return this.autocompletionThreshold;
    }

    public boolean getAutoRecoverActive() {
        return this.autoRecoverActive.get();
    }

    public BooleanProperty autoRecoverActiveProperty() {
        return this.autoRecoverActive;
    }

    public boolean isAutoRecoverActive() {
        return this.autoRecoverActive.get();
    }

    public void setAutoRecoverActive(boolean autoRecoverActive) {
        this.autoRecoverActive.set(autoRecoverActive);
    }

    public int getAutoRecoverTimer() {
        return this.autoRecoverTimer.get();
    }

    public void setAutoRecoverTimer(int autoRecoverTimer) {
        this.autoRecoverTimer.set(autoRecoverTimer);
    }

    public IntegerProperty autoRecoverTimerProperty() {
        return this.autoRecoverTimer;
    }

    public boolean isAutosaveActive() {
        return this.autosaveActive.getValue();
    }

    public void setAutosaveActive(boolean autosaveActive) {
        this.autosaveActive.setValue(Boolean.valueOf(autosaveActive));
    }

    public BooleanProperty autosaveActiveProperty() {
        return this.autosaveActive;
    }

    public int getAutosaveInterval() {
        return this.autosaveInterval.getValue();
    }

    public void setAutosaveInterval(int autosaveInterval) {
        this.autosaveInterval.setValue((Number)autosaveInterval);
    }

    public IntegerProperty autosaveIntervalProperty() {
        return this.autosaveInterval;
    }

    public KeyCombination getPlayerRewind() {
        return (KeyCombination)this.playerRewind.getValue();
    }

    public void setPlayerRewind(KeyCombination playerRewind) {
        this.playerRewind.setValue((Object)playerRewind);
    }

    public ObjectProperty<KeyCombination> playerRewindProperty() {
        return this.playerRewind;
    }

    public KeyCombination getPlayerPlayPause() {
        return (KeyCombination)this.playerPlayPause.getValue();
    }

    public void setPlayerPlayPause(KeyCombination playerPlayPause) {
        this.playerPlayPause.setValue((Object)playerPlayPause);
    }

    public ObjectProperty<KeyCombination> playerPlayPauseProperty() {
        return this.playerPlayPause;
    }

    public KeyCombination getPlayerFastForward() {
        return (KeyCombination)this.playerFastForward.getValue();
    }

    public void setPlayerFastForward(KeyCombination playerFastForward) {
        this.playerFastForward.setValue((Object)playerFastForward);
    }

    public ObjectProperty<KeyCombination> playerFastForwardProperty() {
        return this.playerFastForward;
    }

    public KeyCombination getPlayerLouder() {
        return (KeyCombination)this.playerLouder.getValue();
    }

    public void setPlayerLouder(KeyCombination playerLouder) {
        this.playerLouder.setValue((Object)playerLouder);
    }

    public ObjectProperty<KeyCombination> playerLouderProperty() {
        return this.playerLouder;
    }

    public KeyCombination getPlayerQuieter() {
        return (KeyCombination)this.playerQuieter.getValue();
    }

    public void setPlayerQuieter(KeyCombination playerQuieter) {
        this.playerQuieter.setValue((Object)playerQuieter);
    }

    public ObjectProperty<KeyCombination> playerQuieterProperty() {
        return this.playerQuieter;
    }

    public KeyCombination getPlayerSlower() {
        return (KeyCombination)this.playerSlower.getValue();
    }

    public void setPlayerSlower(KeyCombination playerSlower) {
        this.playerSlower.setValue((Object)playerSlower);
    }

    public ObjectProperty<KeyCombination> playerSlowerProperty() {
        return this.playerSlower;
    }

    public KeyCombination getPlayerFaster() {
        return (KeyCombination)this.playerFaster.getValue();
    }

    public void setPlayerFaster(KeyCombination playerFaster) {
        this.playerFaster.setValue((Object)playerFaster);
    }

    public ObjectProperty<KeyCombination> playerFasterProperty() {
        return this.playerFaster;
    }

    public String getProgramLanguage() {
        return this.programLanguage.getValue();
    }

    public void setProgramLanguage(String programLanguage) {
        this.programLanguage.setValue(programLanguage);
    }

    public StringProperty programLanguageProperty() {
        return this.programLanguage;
    }

    public boolean isProgramAutomaticUpdateSearch() {
        return this.programAutomaticUpdateSearch.getValue();
    }

    public void setProgramAutomaticUpdateSearch(boolean programAutomaticUpdateSearch) {
        this.programAutomaticUpdateSearch.setValue(Boolean.valueOf(programAutomaticUpdateSearch));
    }

    public BooleanProperty programAutomaticUpdateSearchProperty() {
        return this.programAutomaticUpdateSearch;
    }

    public ObservableList<String> getProgramRecentLoadedObservableList() {
        if (this.programRecentLoadedObservableList == null) {
            log.debug("Created program recent loaded property.");
            this.programRecentLoadedObservableList = FXCollections.observableArrayList((Collection)this.programRecentLoaded);
            this.programRecentLoadedObservableList.addListener(change -> {
                this.programRecentLoaded.clear();
                this.programRecentLoaded.addAll(this.programRecentLoadedObservableList);
            });
        }
        return this.programRecentLoadedObservableList;
    }

    public void addToRecentLoaded(Transcript transcript) {
        if (transcript.getTranscriptLocation() == null) {
            log.warn("Could not add transcript to recent loaded because transcript location is empty.");
            return;
        }
        log.debug("Added transcript {} to recent loaded.", (Object)transcript.getUuid());
        while (this.programRecentLoadedObservableList.size() >= 19) {
            this.programRecentLoadedObservableList.remove(this.programRecentLoadedObservableList.size() - 1);
        }
        this.programRecentLoadedObservableList.remove((Object)transcript.getTranscriptLocation().toString());
        this.programRecentLoadedObservableList.add(0, (Object)transcript.getTranscriptLocation().toString());
    }

    public List<String> getProgramRecentLoaded() {
        return this.programRecentLoaded;
    }

    public int getWindingInterval() {
        return this.windingInterval.getValue();
    }

    public void setWindingInterval(int windingInterval) {
        this.windingInterval.setValue((Number)windingInterval);
    }

    public IntegerProperty windingIntervalProperty() {
        return this.windingInterval;
    }

    public String getCommitDateOfVersion() {
        return this.commitDateOfVersion;
    }

    public void setCommitDateOfVersion(String commitDateOfVersion) {
        this.commitDateOfVersion = commitDateOfVersion;
    }

    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    public void setChannel(Channel channel) {
        this.channel.setValue((Object)channel);
    }

    public ObjectProperty<Channel> channelProperty() {
        return this.channel;
    }

    public String getAuthor() {
        return this.author.getValueSafe();
    }

    public void setAuthor(String author) {
        this.author.setValue(author);
    }

    public StringProperty authorProperty() {
        return this.author;
    }

    public boolean isAdditionalLineAfterEnter() {
        return this.additionalLineAfterEnter.getValue();
    }

    public void setAdditionalLineAfterEnter(boolean additionalLineAfterEnter) {
        this.additionalLineAfterEnter.setValue(Boolean.valueOf(additionalLineAfterEnter));
    }

    public BooleanProperty additionalLineAfterEnterProperty() {
        return this.additionalLineAfterEnter;
    }

    public boolean isAutoRewindAfterPause() {
        return this.autoRewindAfterPause.getValue();
    }

    public void setAutoRewindAfterPause(boolean autoRewindAfterPause) {
        this.autoRewindAfterPause.setValue(Boolean.valueOf(autoRewindAfterPause));
    }

    public BooleanProperty autoRewindAfterPauseProperty() {
        return this.autoRewindAfterPause;
    }

    public BooleanProperty useVLCPlayerProperty() {
        return this.useVLCPlayer;
    }

    public boolean isUseVLCPlayer() {
        return this.useVLCPlayer.get();
    }

    public void setUseVLCPlayer(boolean useVLCPlayer) {
        this.useVLCPlayer.set(useVLCPlayer);
    }

    public StringProperty vlcPathProperty() {
        return this.vlcPath;
    }

    public String getVlcPath() {
        return (String)this.vlcPath.get();
    }

    public void setVlcPath(String vlcPath) {
        this.vlcPath.set((Object)vlcPath);
    }

    public List<String> getQueuedLogs() {
        return this.queuedLogs;
    }

    public void setQueuedLogs(List<String> queuedLogs) {
        this.queuedLogs = queuedLogs;
    }

    public boolean isIntegrateVideoplayer() {
        return this.integrateVideoplayer.get();
    }

    public void setIntegrateVideoplayer(boolean integrateVideoplayer) {
        this.integrateVideoplayer.set(integrateVideoplayer);
    }

    public BooleanProperty integrateVideoplayerProperty() {
        return this.integrateVideoplayer;
    }

    public boolean isUseSavedLastPlayerTime() {
        return this.useSavedLastPlayerTime.get();
    }

    public void setUseSavedLastPlayerTime(boolean useSavedLastPlayerTime) {
        this.useSavedLastPlayerTime.set(useSavedLastPlayerTime);
    }

    public BooleanProperty useSavedLastPlayerTimeProperty() {
        return this.useSavedLastPlayerTime;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        Utils.setLoggingLevel((String)logLevel);
    }

    public Theme getTheme() {
        try {
            return Theme.valueOf((String)((String)this.theme.get()));
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown theme setting: {}", this.theme.get());
            this.theme.set((Object)DEFAULT_THEME.toString());
            return DEFAULT_THEME;
        }
    }

    public void setTheme(Theme theme) {
        this.theme.set((Object)theme.toString());
    }

    public StringProperty themeProperty() {
        return this.theme;
    }

    public double getWidthOfTextAreaInCm() {
        return this.widthOfTextAreaInCm.get();
    }

    public void setWidthOfTextAreaInCm(double widthOfTextAreaInCm) {
        this.widthOfTextAreaInCm.set(widthOfTextAreaInCm);
    }

    public DoubleProperty widthOfTextAreaInCmProperty() {
        return this.widthOfTextAreaInCm;
    }

    public boolean getShowParagraphNumbers() {
        return this.showParagraphNumbers.get();
    }

    public void setShowParagraphNumbers(boolean showParagraphNumbers) {
        this.showParagraphNumbers.set(showParagraphNumbers);
    }

    public BooleanProperty showParagraphNumbersProperty() {
        return this.showParagraphNumbers;
    }

    public boolean isAutoCorrectionActive() {
        return this.autoCorrectionActive.get();
    }

    public void setAutoCorrectionActive(boolean autoCorrectionActive) {
        this.autoCorrectionActive.set(autoCorrectionActive);
    }

    public BooleanProperty autoCorrectionActiveProperty() {
        return this.autoCorrectionActive;
    }

    public long getTimestampOffset() {
        return this.timestampOffset.get();
    }

    public void setTimestampOffset(long offset) {
        this.timestampOffset.set(offset);
    }

    public LongProperty timestampOffsetProperty() {
        return this.timestampOffset;
    }

    public TextAlignment getFormattingParagraphAlignment() {
        return (TextAlignment)this.formattingParagraphAlignment.get();
    }

    public void setFormattingParagraphAlignment(TextAlignment formattingParagraphAlignment) {
        this.formattingParagraphAlignment.set((Object)formattingParagraphAlignment);
    }

    public ObjectProperty<TextAlignment> formattingParagraphAlignmentProperty() {
        return this.formattingParagraphAlignment;
    }

    public boolean isDrawerExpanded() {
        return this.drawerExpanded.get();
    }

    public void setDrawerExpanded(boolean drawerExpanded) {
        this.drawerExpanded.set(drawerExpanded);
    }

    public BooleanProperty drawerExpandedProperty() {
        return this.drawerExpanded;
    }

    @Generated
    public String toString() {
        return "Configuration(channel=" + String.valueOf(this.getChannel()) + ", timestampsOnBeginning=" + String.valueOf(this.timestampsOnBeginning) + ", timestampsOnEnd=" + String.valueOf(this.timestampsOnEnd) + ", drawerExpanded=" + String.valueOf(this.drawerExpanded) + ", formattingFont=" + this.getFormattingFont() + ", formattingSize=" + this.getFormattingSize() + ", formattingBold=" + String.valueOf(this.formattingBold) + ", formattingItalic=" + String.valueOf(this.formattingItalic) + ", formattingUnderlined=" + String.valueOf(this.formattingUnderlined) + ", formattingParagraphAlignment=" + String.valueOf(this.getFormattingParagraphAlignment()) + ", autocompletionActive=" + String.valueOf(this.autocompletionActive) + ", autocompletionThreshold=" + this.getAutocompletionThreshold() + ", autoCorrectionActive=" + String.valueOf(this.autoCorrectionActive) + ", autoRecoverActive=" + this.getAutoRecoverActive() + ", autoRecoverTimer=" + this.getAutoRecoverTimer() + ", autosaveActive=" + String.valueOf(this.autosaveActive) + ", autosaveInterval=" + this.getAutosaveInterval() + ", windingInterval=" + this.getWindingInterval() + ", autoRewindAfterPause=" + String.valueOf(this.autoRewindAfterPause) + ", additionalLineAfterEnter=" + String.valueOf(this.additionalLineAfterEnter) + ", playerRewind=" + String.valueOf(this.getPlayerRewind()) + ", playerPlayPause=" + String.valueOf(this.getPlayerPlayPause()) + ", playerFastForward=" + String.valueOf(this.getPlayerFastForward()) + ", playerQuieter=" + String.valueOf(this.getPlayerQuieter()) + ", playerLouder=" + String.valueOf(this.getPlayerLouder()) + ", playerSlower=" + String.valueOf(this.getPlayerSlower()) + ", playerFaster=" + String.valueOf(this.getPlayerFaster()) + ", useVLCPlayer=" + String.valueOf(this.useVLCPlayer) + ", vlcPath=" + this.getVlcPath() + ", programLanguage=" + this.getProgramLanguage() + ", programAutomaticUpdateSearch=" + String.valueOf(this.programAutomaticUpdateSearch) + ", programRecentLoaded=" + String.valueOf(this.getProgramRecentLoaded()) + ", author=" + this.getAuthor() + ", integrateVideoplayer=" + String.valueOf(this.integrateVideoplayer) + ", useSavedLastPlayerTime=" + String.valueOf(this.useSavedLastPlayerTime) + ", theme=" + String.valueOf(this.getTheme()) + ", widthOfTextAreaInCm=" + this.getWidthOfTextAreaInCm() + ", showParagraphNumbers=" + this.getShowParagraphNumbers() + ", timestampOffset=" + this.getTimestampOffset() + ", seenTutorials=" + String.valueOf(this.getSeenTutorials()) + ", version=" + String.valueOf(this.getVersion()) + ", commitIdOfVersion=" + this.getCommitIdOfVersion() + ", commitDateOfVersion=" + this.getCommitDateOfVersion() + ", programRecentLoadedObservableList=" + String.valueOf(this.getProgramRecentLoadedObservableList()) + ", logLevel=" + this.getLogLevel() + ", queuedLogs=" + String.valueOf(this.getQueuedLogs()) + ")";
    }

    @Generated
    public HashSet<String> getSeenTutorials() {
        return this.seenTutorials;
    }
}

