/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.commons.types;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.HasPreDefinedStyle;
import eu.ewerkzeug.easytranscript3.commons.io.ETFileNotFoundException;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import eu.ewerkzeug.easytranscript3.commons.types.VersionDeserializer;
import eu.ewerkzeug.easytranscript3.commons.types.VersionSerializer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.input.KeyCombination;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Transcript {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Transcript.class);
    public static final String ETT_FILE_EXTENSION = ".ett";
    public static final String ETP_FILE_EXTENSION = ".etp";
    public static final Pattern wordSeparator = Pattern.compile("[\\s\\p{Punct}]");
    public static final double WORD_CONFIDENCE_THRESHOLD = 0.5;
    private static final String PROPERTIES_FILENAME = "properties.json";
    private static final String DOCUMENT_FILENAME = "document.xml";
    private static final FileChooser.ExtensionFilter ettFilter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("mainScreen.filePickerETTranscript") + " (*.ett)", new String[]{"*.ett"});
    private static final FileChooser.ExtensionFilter etpFilter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("mainScreen.filePickerETPTranscript") + " (*.etp)", new String[]{"*.etp"});
    private static final FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(Utils.getLocaleBundle().getString("mainScreen.filePickerAllTranscripts") + " (*.ett, *.etp)", new String[]{"*.ett", "*.etp"});
    private static Transcript instance;
    @JsonIgnore
    private final List<Subscription> subscriptions = new ArrayList();
    @JsonSerialize(using=VersionSerializer.class)
    @JsonDeserialize(using=VersionDeserializer.class)
    private Version usedETVersion;
    private HashSet<String> author = new HashSet();
    private String description = "";
    @JsonIgnore
    private Path transcriptLocation = null;
    private Path mediaLocation = null;
    @JsonIgnore
    private Set<String> autocompletionWords = new HashSet();
    @JsonIgnore
    private String hash = "";
    private HashMap<String, String> customFields = new HashMap();
    private LinkedHashMap<String, String> keyCombinationFields = new LinkedHashMap();
    private String uuid = UUID.randomUUID().toString();
    @JsonIgnore
    private String unzipUuid = UUID.randomUUID().toString();
    private HashSet<Path> transcriptChildren = new HashSet();
    private ArrayList<TimeTrackingEntry> trackedTime = new ArrayList();
    private boolean supportsTimeTrackingEstimates = true;
    private List<Speaker> speakers = List.of(new Speaker("Person 1"), new Speaker("Person 2"));
    private StringProperty speakerFormattingFont = new SimpleStringProperty("Monospaced");
    private IntegerProperty speakerFormattingSize = new SimpleIntegerProperty(12);
    private BooleanProperty speakerFormattingBold = new SimpleBooleanProperty(false);
    private BooleanProperty speakerFormattingItalic = new SimpleBooleanProperty(false);
    private BooleanProperty speakerFormattingUnderlined = new SimpleBooleanProperty(false);
    @JsonIgnore
    private TextStyle speakerTextStyle = this.createSpeakerTextStyle();
    private BooleanProperty changeOfSpeaker = new SimpleBooleanProperty(true);
    private long lastPlayerTime;
    @JsonIgnore
    private boolean alreadyJumpedToLastPlayerTime;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @JsonAlias(value={"transcriptText"})
    private String document = "";

    public Transcript() {
        log.debug("Creating new transcript object...");
        this.uuid = UUID.randomUUID().toString();
    }

    public Transcript(Transcript transcript) {
        log.debug("Creating new transcript object based on transcript {}...", (Object)transcript.getUuid());
        this.reset(transcript);
    }

    public static Transcript get() {
        if (instance == null) {
            instance = new Transcript();
        }
        return instance;
    }

    public static void set(Transcript transcript) {
        instance = transcript;
    }

    public static List<FileChooser.ExtensionFilter> getTranscriptExtensionFilters() {
        return List.of(filter, ettFilter, etpFilter);
    }

    public static Path getTemporaryPropertiesLocation(String uuid) {
        return Transcript.getTemporaryTranscriptLocation((String)uuid).resolve("properties.json");
    }

    public static Transcript loadProperties(String unzipUuid, Path transcriptLocation) throws IOException {
        return Transcript.loadProperties((Path)Transcript.getTemporaryPropertiesLocation((String)unzipUuid), (String)unzipUuid, (Path)transcriptLocation);
    }

    public static Transcript loadProperties(Path unzippedPropertiesPath, String unzipUuid, Path transcriptLocation) throws IOException {
        Transcript transcript;
        log.debug("Loading Transcript properties ...");
        if (unzippedPropertiesPath == null) {
            log.warn("Transcript unzip properties path is empty.");
            return new Transcript();
        }
        if (!unzippedPropertiesPath.toFile().exists()) {
            throw new ETFileNotFoundException(Utils.getLocaleBundle().getString("problems.transcriptFileNotFound"), "Transcript %s does not exist".formatted(unzippedPropertiesPath.toString()));
        }
        try {
            String json = Files.readString(unzippedPropertiesPath);
            json = Utils.removeControlCharactersFromJSON((String)json);
            transcript = (Transcript)Utils.getObjectMapper().readValue(json, Transcript.class);
            transcript.setTranscriptLocation(transcriptLocation);
            transcript.setUnzipUuid(unzipUuid);
            List speakerList = transcript.getSpeakers();
            List speakers = speakerList.stream().distinct().toList();
            speakerList.clear();
            speakerList.addAll(speakers);
        }
        catch (IOException e) {
            log.error("Failed to load transcript properties from path: {}", (Object)unzippedPropertiesPath, (Object)e);
            throw e;
        }
        log.info("Loaded Transcript.");
        return transcript;
    }

    public static String documentToHtml(StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> doc) {
        return TagCreator.document((HtmlTag)TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)Transcript.get().getTranscriptLocation().getFileName().toString())}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.each((Collection)doc.getParagraphs(), paragraph -> TagCreator.p((DomContent[])new DomContent[]{TagCreator.each((Collection)paragraph.getStyledSegments(), segment -> TagCreator.span((String)((AbstractSegment)segment.getSegment()).getRealText()).withStyle(Transcript.getSegmentStyle((StyledSegment)segment).toRealCss()))}))})}));
    }

    private static TextStyle getSegmentStyle(StyledSegment<AbstractSegment<?>, TextStyle> segment) {
        TextStyle textStyle = (TextStyle)segment.getStyle();
        Object object = segment.getSegment();
        if (object instanceof HasPreDefinedStyle) {
            HasPreDefinedStyle hasPreDefinedStyle = (HasPreDefinedStyle)object;
            textStyle = hasPreDefinedStyle.getTextStyle();
        }
        textStyle = textStyle.updateTextColor(Color.BLACK);
        return textStyle;
    }

    public static Path getTemporaryTranscriptLocation(String uuid) {
        return Transcript.getTemporaryTranscriptsLocation().resolve(uuid);
    }

    public static Path getTemporaryTranscriptsLocation() {
        return Main.getEasytranscriptTempDirectory().resolve("transcripts");
    }

    public Transcript createShallowCopyForAutoRecover() {
        Transcript shallowCopy = new Transcript(Transcript.get());
        shallowCopy.setTranscriptLocation(Path.of(Configuration.ET_HOME + "/backups/" + shallowCopy.getUuid() + ".ett", new String[0]));
        return shallowCopy;
    }

    public String loadDocument() throws IOException {
        log.debug("Loading document ...");
        Path unzippedDocumentPath = this.getTemporaryDocumentLocation();
        if (unzippedDocumentPath.toFile().exists()) {
            return Files.readString(unzippedDocumentPath);
        }
        log.warn("Document %s does not exist".formatted(unzippedDocumentPath.toString()));
        return null;
    }

    private boolean saveProperties(File file) throws IOException {
        log.debug("Saving Transcript ...");
        this.setUsedETVersion(Configuration.get().getVersion());
        this.makeKeyCombinationFieldsPlatformIndependent();
        Path parent = file.toPath().getParent();
        Files.createDirectories(parent, new FileAttribute[0]);
        Utils.getObjectMapper().writeValue(file, (Object)this);
        log.info("Saved Transcript.");
        return true;
    }

    private void makeKeyCombinationFieldsPlatformIndependent() {
        LinkedHashMap snapshot = new LinkedHashMap(this.getKeyCombinationFields());
        LinkedHashMap<String, String> newKeyCombinationFields = new LinkedHashMap<String, String>();
        for (Map.Entry entry : snapshot.entrySet()) {
            try {
                KeyCombination.valueOf((String)((String)entry.getKey()));
                newKeyCombinationFields.put((String)entry.getKey(), (String)entry.getValue());
            }
            catch (IllegalArgumentException e) {
                String key = KeyCombinationTextField.replaceSpecificByPlatformIndependent((String)((String)entry.getKey()));
                newKeyCombinationFields.put(key, (String)entry.getValue());
            }
        }
        this.getKeyCombinationFields().clear();
        this.getKeyCombinationFields().putAll(newKeyCombinationFields);
    }

    public boolean saveProperties() throws IOException {
        return this.saveProperties(this.getTemporaryPropertiesLocation().toFile());
    }

    public void reset(Transcript transcript) {
        log.debug("Resetting transcript ...");
        this.usedETVersion = transcript.usedETVersion;
        this.author = transcript.author;
        this.description = transcript.description;
        this.transcriptLocation = transcript.transcriptLocation;
        this.mediaLocation = transcript.mediaLocation;
        this.customFields = transcript.customFields;
        this.keyCombinationFields = transcript.keyCombinationFields;
        this.uuid = transcript.uuid;
        this.transcriptChildren = transcript.transcriptChildren;
        this.trackedTime = transcript.trackedTime;
        this.supportsTimeTrackingEstimates = transcript.supportsTimeTrackingEstimates;
        this.document = transcript.document;
        this.speakers = transcript.speakers;
        this.speakerFormattingFont = transcript.speakerFormattingFont;
        this.speakerFormattingSize = transcript.speakerFormattingSize;
        this.speakerFormattingBold = transcript.speakerFormattingBold;
        this.speakerFormattingItalic = transcript.speakerFormattingItalic;
        this.speakerFormattingUnderlined = transcript.speakerFormattingUnderlined;
        this.changeOfSpeaker = transcript.changeOfSpeaker;
        this.lastPlayerTime = transcript.lastPlayerTime;
        this.alreadyJumpedToLastPlayerTime = transcript.alreadyJumpedToLastPlayerTime;
        this.hash = transcript.hash;
        this.autocompletionWords = transcript.autocompletionWords;
        this.speakerTextStyle = transcript.speakerTextStyle;
        this.unzipUuid = transcript.unzipUuid;
    }

    @JsonIgnore
    public Path getTemporaryDocumentLocation() {
        return this.getTemporaryTranscriptLocation().resolve("document.xml");
    }

    @JsonIgnore
    public Path getTemporaryPropertiesLocation() {
        return this.getTemporaryTranscriptLocation().resolve("properties.json");
    }

    @JsonIgnore
    public Path getTemporaryTranscriptLocation() {
        return Transcript.getTemporaryTranscriptLocation((String)this.getUnzipUuid());
    }

    public String getSpeakerFormattingFont() {
        return (String)this.speakerFormattingFont.get();
    }

    public void setSpeakerFormattingFont(String speakerFormattingFont) {
        this.speakerFormattingFont.set((Object)speakerFormattingFont);
    }

    public StringProperty speakerFormattingFontProperty() {
        return this.speakerFormattingFont;
    }

    public int getSpeakerFormattingSize() {
        return this.speakerFormattingSize.get();
    }

    public void setSpeakerFormattingSize(int speakerFormattingSize) {
        this.speakerFormattingSize.set(speakerFormattingSize);
    }

    public IntegerProperty speakerFormattingSizeProperty() {
        return this.speakerFormattingSize;
    }

    public boolean isSpeakerFormattingBold() {
        return this.speakerFormattingBold.get();
    }

    public void setSpeakerFormattingBold(boolean speakerFormattingBold) {
        this.speakerFormattingBold.set(speakerFormattingBold);
    }

    public BooleanProperty speakerFormattingBoldProperty() {
        return this.speakerFormattingBold;
    }

    public boolean isSpeakerFormattingItalic() {
        return this.speakerFormattingItalic.get();
    }

    public void setSpeakerFormattingItalic(boolean speakerFormattingItalic) {
        this.speakerFormattingItalic.set(speakerFormattingItalic);
    }

    public BooleanProperty speakerFormattingItalicProperty() {
        return this.speakerFormattingItalic;
    }

    public boolean isSpeakerFormattingUnderlined() {
        return this.speakerFormattingUnderlined.get();
    }

    public void setSpeakerFormattingUnderlined(boolean speakerFormattingUnderlined) {
        this.speakerFormattingUnderlined.set(speakerFormattingUnderlined);
    }

    public BooleanProperty speakerFormattingUnderlinedProperty() {
        return this.speakerFormattingUnderlined;
    }

    public void updateSpeakerTextStyle() {
        this.setSpeakerTextStyle(this.createSpeakerTextStyle());
    }

    private TextStyle createSpeakerTextStyle() {
        try {
            return new TextStyle().updateTextColor((Color)Utils.getCssVariable((String)"-fx-main-gradient-start")).updateFontFamily((String)this.speakerFormattingFont.get()).updateFontSize(this.speakerFormattingSize.get()).updateBold(this.speakerFormattingBold.get()).updateItalic(this.speakerFormattingItalic.get()).updateUnderline(this.speakerFormattingUnderlined.get());
        }
        catch (URISyntaxException e) {
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
            return TextStyle.EMPTY;
        }
    }

    @JsonIgnore
    public Speaker getNextSpeaker(int index) {
        index = (index + 1) % this.speakers.size();
        return (Speaker)this.speakers.get(index);
    }

    public boolean getChangeOfSpeaker() {
        return this.changeOfSpeaker.get();
    }

    public void setChangeOfSpeaker(boolean changeOfSpeaker) {
        this.changeOfSpeaker.set(changeOfSpeaker);
    }

    public BooleanProperty changeOfSpeakerProperty() {
        return this.changeOfSpeaker;
    }

    public void setLastPlayerTime(long lastPlayerTime) {
        log.info("Setting Last Player Time to {}", (Object)lastPlayerTime);
        this.lastPlayerTime = lastPlayerTime;
    }

    public void initializeWordCompletionList(String parsedText) {
        log.debug("Recreating word list ...");
        if (parsedText.length() < 2) {
            log.info("Text is empty, no words added to list.");
            return;
        }
        List<String> words = Arrays.stream(parsedText.split(wordSeparator.pattern())).map(word -> word.replace("\ufffc", "")).filter(word -> !word.isBlank()).toList();
        words = new ArrayList<String>(words);
        boolean endsWithSeparator = wordSeparator.matcher(parsedText.substring(parsedText.length() - 2, parsedText.length() - 1)).matches();
        if (!endsWithSeparator && !words.isEmpty()) {
            words.removeLast();
        }
        Set autocompletionWordSet = words.stream().filter(f -> f.length() >= Configuration.get().getAutocompletionThreshold()).collect(Collectors.toSet());
        Transcript.get().setAutocompletionWords(autocompletionWordSet);
        log.debug("Created word list. Found {} words matching the threshold of {} letters.", (Object)Transcript.get().getAutocompletionWords().size(), (Object)Configuration.get().getAutocompletionThreshold());
    }

    @Generated
    public String toString() {
        return "Transcript(subscriptions=" + String.valueOf(this.getSubscriptions()) + ", usedETVersion=" + String.valueOf(this.getUsedETVersion()) + ", author=" + String.valueOf(this.getAuthor()) + ", description=" + this.getDescription() + ", transcriptLocation=" + String.valueOf(this.getTranscriptLocation()) + ", mediaLocation=" + String.valueOf(this.getMediaLocation()) + ", autocompletionWords=" + String.valueOf(this.getAutocompletionWords()) + ", hash=" + this.getHash() + ", customFields=" + String.valueOf(this.getCustomFields()) + ", keyCombinationFields=" + String.valueOf(this.getKeyCombinationFields()) + ", uuid=" + this.getUuid() + ", unzipUuid=" + this.getUnzipUuid() + ", transcriptChildren=" + String.valueOf(this.getTranscriptChildren()) + ", trackedTime=" + String.valueOf(this.getTrackedTime()) + ", supportsTimeTrackingEstimates=" + this.isSupportsTimeTrackingEstimates() + ", speakers=" + String.valueOf(this.getSpeakers()) + ", speakerFormattingFont=" + this.getSpeakerFormattingFont() + ", speakerFormattingSize=" + this.getSpeakerFormattingSize() + ", speakerFormattingBold=" + String.valueOf(this.speakerFormattingBold) + ", speakerFormattingItalic=" + String.valueOf(this.speakerFormattingItalic) + ", speakerFormattingUnderlined=" + String.valueOf(this.speakerFormattingUnderlined) + ", speakerTextStyle=" + String.valueOf(this.getSpeakerTextStyle()) + ", changeOfSpeaker=" + this.getChangeOfSpeaker() + ", lastPlayerTime=" + this.getLastPlayerTime() + ", alreadyJumpedToLastPlayerTime=" + this.isAlreadyJumpedToLastPlayerTime() + ", document=" + this.getDocument() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transcript)) {
            return false;
        }
        Transcript other = (Transcript)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSupportsTimeTrackingEstimates() != other.isSupportsTimeTrackingEstimates()) {
            return false;
        }
        if (this.getLastPlayerTime() != other.getLastPlayerTime()) {
            return false;
        }
        if (this.isAlreadyJumpedToLastPlayerTime() != other.isAlreadyJumpedToLastPlayerTime()) {
            return false;
        }
        List this$subscriptions = this.getSubscriptions();
        List other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        Version this$usedETVersion = this.getUsedETVersion();
        Version other$usedETVersion = other.getUsedETVersion();
        if (this$usedETVersion == null ? other$usedETVersion != null : !this$usedETVersion.equals(other$usedETVersion)) {
            return false;
        }
        HashSet this$author = this.getAuthor();
        HashSet other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Path this$transcriptLocation = this.getTranscriptLocation();
        Path other$transcriptLocation = other.getTranscriptLocation();
        if (this$transcriptLocation == null ? other$transcriptLocation != null : !((Object)this$transcriptLocation).equals(other$transcriptLocation)) {
            return false;
        }
        Path this$mediaLocation = this.getMediaLocation();
        Path other$mediaLocation = other.getMediaLocation();
        if (this$mediaLocation == null ? other$mediaLocation != null : !((Object)this$mediaLocation).equals(other$mediaLocation)) {
            return false;
        }
        Set this$autocompletionWords = this.getAutocompletionWords();
        Set other$autocompletionWords = other.getAutocompletionWords();
        if (this$autocompletionWords == null ? other$autocompletionWords != null : !((Object)this$autocompletionWords).equals(other$autocompletionWords)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        HashMap this$customFields = this.getCustomFields();
        HashMap other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        LinkedHashMap this$keyCombinationFields = this.getKeyCombinationFields();
        LinkedHashMap other$keyCombinationFields = other.getKeyCombinationFields();
        if (this$keyCombinationFields == null ? other$keyCombinationFields != null : !((Object)this$keyCombinationFields).equals(other$keyCombinationFields)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$unzipUuid = this.getUnzipUuid();
        String other$unzipUuid = other.getUnzipUuid();
        if (this$unzipUuid == null ? other$unzipUuid != null : !this$unzipUuid.equals(other$unzipUuid)) {
            return false;
        }
        HashSet this$transcriptChildren = this.getTranscriptChildren();
        HashSet other$transcriptChildren = other.getTranscriptChildren();
        if (this$transcriptChildren == null ? other$transcriptChildren != null : !((Object)this$transcriptChildren).equals(other$transcriptChildren)) {
            return false;
        }
        ArrayList this$trackedTime = this.getTrackedTime();
        ArrayList other$trackedTime = other.getTrackedTime();
        if (this$trackedTime == null ? other$trackedTime != null : !((Object)this$trackedTime).equals(other$trackedTime)) {
            return false;
        }
        List this$speakers = this.getSpeakers();
        List other$speakers = other.getSpeakers();
        if (this$speakers == null ? other$speakers != null : !((Object)this$speakers).equals(other$speakers)) {
            return false;
        }
        String this$speakerFormattingFont = this.getSpeakerFormattingFont();
        String other$speakerFormattingFont = other.getSpeakerFormattingFont();
        if (this$speakerFormattingFont == null ? other$speakerFormattingFont != null : !this$speakerFormattingFont.equals(other$speakerFormattingFont)) {
            return false;
        }
        if (this.getSpeakerFormattingSize() != other.getSpeakerFormattingSize()) {
            return false;
        }
        BooleanProperty this$speakerFormattingBold = this.speakerFormattingBold;
        BooleanProperty other$speakerFormattingBold = other.speakerFormattingBold;
        if (this$speakerFormattingBold == null ? other$speakerFormattingBold != null : !this$speakerFormattingBold.equals(other$speakerFormattingBold)) {
            return false;
        }
        BooleanProperty this$speakerFormattingItalic = this.speakerFormattingItalic;
        BooleanProperty other$speakerFormattingItalic = other.speakerFormattingItalic;
        if (this$speakerFormattingItalic == null ? other$speakerFormattingItalic != null : !this$speakerFormattingItalic.equals(other$speakerFormattingItalic)) {
            return false;
        }
        BooleanProperty this$speakerFormattingUnderlined = this.speakerFormattingUnderlined;
        BooleanProperty other$speakerFormattingUnderlined = other.speakerFormattingUnderlined;
        if (this$speakerFormattingUnderlined == null ? other$speakerFormattingUnderlined != null : !this$speakerFormattingUnderlined.equals(other$speakerFormattingUnderlined)) {
            return false;
        }
        TextStyle this$speakerTextStyle = this.getSpeakerTextStyle();
        TextStyle other$speakerTextStyle = other.getSpeakerTextStyle();
        if (this$speakerTextStyle == null ? other$speakerTextStyle != null : !this$speakerTextStyle.equals(other$speakerTextStyle)) {
            return false;
        }
        if (this.getChangeOfSpeaker() != other.getChangeOfSpeaker()) {
            return false;
        }
        String this$document = this.getDocument();
        String other$document = other.getDocument();
        return !(this$document == null ? other$document != null : !this$document.equals(other$document));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transcript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSupportsTimeTrackingEstimates() ? 79 : 97);
        long $lastPlayerTime = this.getLastPlayerTime();
        result = result * 59 + (int)($lastPlayerTime >>> 32 ^ $lastPlayerTime);
        result = result * 59 + (this.isAlreadyJumpedToLastPlayerTime() ? 79 : 97);
        List $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        Version $usedETVersion = this.getUsedETVersion();
        result = result * 59 + ($usedETVersion == null ? 43 : $usedETVersion.hashCode());
        HashSet $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Path $transcriptLocation = this.getTranscriptLocation();
        result = result * 59 + ($transcriptLocation == null ? 43 : ((Object)$transcriptLocation).hashCode());
        Path $mediaLocation = this.getMediaLocation();
        result = result * 59 + ($mediaLocation == null ? 43 : ((Object)$mediaLocation).hashCode());
        Set $autocompletionWords = this.getAutocompletionWords();
        result = result * 59 + ($autocompletionWords == null ? 43 : ((Object)$autocompletionWords).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        HashMap $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        LinkedHashMap $keyCombinationFields = this.getKeyCombinationFields();
        result = result * 59 + ($keyCombinationFields == null ? 43 : ((Object)$keyCombinationFields).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $unzipUuid = this.getUnzipUuid();
        result = result * 59 + ($unzipUuid == null ? 43 : $unzipUuid.hashCode());
        HashSet $transcriptChildren = this.getTranscriptChildren();
        result = result * 59 + ($transcriptChildren == null ? 43 : ((Object)$transcriptChildren).hashCode());
        ArrayList $trackedTime = this.getTrackedTime();
        result = result * 59 + ($trackedTime == null ? 43 : ((Object)$trackedTime).hashCode());
        List $speakers = this.getSpeakers();
        result = result * 59 + ($speakers == null ? 43 : ((Object)$speakers).hashCode());
        String $speakerFormattingFont = this.getSpeakerFormattingFont();
        result = result * 59 + ($speakerFormattingFont == null ? 43 : $speakerFormattingFont.hashCode());
        result = result * 59 + this.getSpeakerFormattingSize();
        BooleanProperty $speakerFormattingBold = this.speakerFormattingBold;
        result = result * 59 + ($speakerFormattingBold == null ? 43 : $speakerFormattingBold.hashCode());
        BooleanProperty $speakerFormattingItalic = this.speakerFormattingItalic;
        result = result * 59 + ($speakerFormattingItalic == null ? 43 : $speakerFormattingItalic.hashCode());
        BooleanProperty $speakerFormattingUnderlined = this.speakerFormattingUnderlined;
        result = result * 59 + ($speakerFormattingUnderlined == null ? 43 : $speakerFormattingUnderlined.hashCode());
        TextStyle $speakerTextStyle = this.getSpeakerTextStyle();
        result = result * 59 + ($speakerTextStyle == null ? 43 : $speakerTextStyle.hashCode());
        result = result * 59 + (this.getChangeOfSpeaker() ? 79 : 97);
        String $document = this.getDocument();
        result = result * 59 + ($document == null ? 43 : $document.hashCode());
        return result;
    }

    @Generated
    public static FileChooser.ExtensionFilter getEttFilter() {
        return ettFilter;
    }

    @Generated
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public void setUsedETVersion(Version usedETVersion) {
        this.usedETVersion = usedETVersion;
    }

    @Generated
    public Version getUsedETVersion() {
        return this.usedETVersion;
    }

    @Generated
    public HashSet<String> getAuthor() {
        return this.author;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setTranscriptLocation(Path transcriptLocation) {
        this.transcriptLocation = transcriptLocation;
    }

    @Generated
    public Path getTranscriptLocation() {
        return this.transcriptLocation;
    }

    @Generated
    public void setMediaLocation(Path mediaLocation) {
        this.mediaLocation = mediaLocation;
    }

    @Generated
    public Path getMediaLocation() {
        return this.mediaLocation;
    }

    @Generated
    public void setAutocompletionWords(Set<String> autocompletionWords) {
        this.autocompletionWords = autocompletionWords;
    }

    @Generated
    public Set<String> getAutocompletionWords() {
        return this.autocompletionWords;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public HashMap<String, String> getCustomFields() {
        return this.customFields;
    }

    @Generated
    public LinkedHashMap<String, String> getKeyCombinationFields() {
        return this.keyCombinationFields;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getUnzipUuid() {
        return this.unzipUuid;
    }

    @Generated
    public void setUnzipUuid(String unzipUuid) {
        this.unzipUuid = unzipUuid;
    }

    @Generated
    public HashSet<Path> getTranscriptChildren() {
        return this.transcriptChildren;
    }

    @Generated
    public ArrayList<TimeTrackingEntry> getTrackedTime() {
        return this.trackedTime;
    }

    @Generated
    public void setSupportsTimeTrackingEstimates(boolean supportsTimeTrackingEstimates) {
        this.supportsTimeTrackingEstimates = supportsTimeTrackingEstimates;
    }

    @Generated
    public boolean isSupportsTimeTrackingEstimates() {
        return this.supportsTimeTrackingEstimates;
    }

    @Generated
    public List<Speaker> getSpeakers() {
        return this.speakers;
    }

    @Generated
    public TextStyle getSpeakerTextStyle() {
        return this.speakerTextStyle;
    }

    @Generated
    public void setSpeakerTextStyle(TextStyle speakerTextStyle) {
        this.speakerTextStyle = speakerTextStyle;
    }

    @Generated
    public long getLastPlayerTime() {
        return this.lastPlayerTime;
    }

    @Generated
    public boolean isAlreadyJumpedToLastPlayerTime() {
        return this.alreadyJumpedToLastPlayerTime;
    }

    @Generated
    public void setAlreadyJumpedToLastPlayerTime(boolean alreadyJumpedToLastPlayerTime) {
        this.alreadyJumpedToLastPlayerTime = alreadyJumpedToLastPlayerTime;
    }

    @Generated
    public void setDocument(String document) {
        this.document = document;
    }

    @Generated
    public String getDocument() {
        return this.document;
    }
}

