/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations;

import com.github.zafarkhaja.semver.Version;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.io.ZipService;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.migrations.ProgramMigration;
import eu.ewerkzeug.easytranscript3.migrations.TranscriptMigration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationService.class);
    private final List<TranscriptMigration> transcriptMigrations;
    private final List<ProgramMigration> programMigrations;

    public static void loadTranscriptProperties(ZipService zipService, Transcript transcript) throws IOException {
        Path transcriptPath = transcript.getTranscriptLocation();
        String unzipUUID = transcript.getUnzipUuid();
        if (zipService.isZipFile(transcriptPath)) {
            zipService.unzipFile(transcriptPath, Transcript.getTemporaryTranscriptLocation((String)unzipUUID));
            transcript = Transcript.loadProperties((String)unzipUUID, (Path)transcriptPath);
            String document = transcript.loadDocument();
            if (document != null) {
                transcript.setDocument(document);
            }
        } else {
            log.error("Transcript is not in the right format after migration.");
            ExceptionAlert.get().showModal();
        }
    }

    public void runProgramMigrations() {
        log.debug("Found {} program migrations ...", (Object)this.programMigrations.size());
        int numberOfApplicableMigrations = 0;
        this.programMigrations.sort(Comparator.comparing(ProgramMigration::getVersionOfChange));
        for (ProgramMigration programMigration : this.programMigrations) {
            if (!programMigration.isApplicable()) continue;
            try {
                programMigration.migrate();
                log.debug("Applied migration '{}'", (Object)programMigration.getDescription());
                ++numberOfApplicableMigrations;
            }
            catch (Exception e) {
                log.error("Failed to run migration '{}'", (Object)programMigration.getDescription(), (Object)e);
                ExceptionAlert.get().showModal();
                return;
            }
        }
        log.info("{} out of {} program migrations were applicable and were executed.", (Object)numberOfApplicableMigrations, (Object)this.programMigrations.size());
    }

    public boolean applyTranscriptMigrations(Transcript transcript) {
        log.debug("Applying migrations to transcript ...");
        if (transcript == null) {
            log.error("Cannot migrate because transcript is null.");
            return false;
        }
        if (transcript.getUsedETVersion() == null) {
            log.error("Cannot migrate because version of this transcript is null.");
            return false;
        }
        Version transcriptVersion = transcript.getUsedETVersion();
        Version programVersion = Configuration.get().getVersion();
        log.debug("Transcript to migrate: {}, Version {} to version {}", new Object[]{transcript.getUuid(), transcriptVersion, programVersion});
        List<TranscriptMigration> selectedMigrations = this.transcriptMigrations.stream().filter(migration -> migration.getTargetVersion().compareTo(programVersion) <= 0).filter(migration -> migration.getTargetVersion().compareTo(transcript.getUsedETVersion()) > 0).sorted().toList();
        log.debug("Selected {} out of {} migrations to apply.", (Object)selectedMigrations.size(), (Object)this.transcriptMigrations.size());
        for (int i = 0; i < selectedMigrations.size(); ++i) {
            TranscriptMigration migration2 = selectedMigrations.get(i);
            try {
                log.debug("{}: {} - {}", new Object[]{i, migration2.getTargetVersion(), migration2.getDescription()});
                migration2.migrate(transcript);
                continue;
            }
            catch (Exception e) {
                log.error("Failed to migrate transcript to version {}", (Object)migration2.getTargetVersion(), (Object)e);
                ExceptionAlert.get().showModal();
                return false;
            }
        }
        if (!selectedMigrations.isEmpty()) {
            log.info("Migrated transcript {} from version {} to version {}", new Object[]{transcript.getUuid(), transcriptVersion, Configuration.get().getVersion()});
            return true;
        }
        log.info("Transcript is up to date, no migrations to apply.");
        return false;
    }

    @Generated
    public MigrationService(List<TranscriptMigration> transcriptMigrations, List<ProgramMigration> programMigrations) {
        this.transcriptMigrations = transcriptMigrations;
        this.programMigrations = programMigrations;
    }
}

