/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.migrations.manualmigrations;

import eu.ewerkzeug.easytranscript3.commons.AESUtil;
import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class V3_1_0_BETA_1__Auth_flow_Migration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V3_1_0_BETA_1__Auth_flow_Migration.class);
    private static final Path OLD_TOKEN_PATH = Path.of(Configuration.ET_HOME, new String[0]).resolve("token");
    private static final String OLD_AUTH_TOKEN_HEADER = "x-auth-token";

    private static byte[] getToken() throws IOException {
        if (Files.exists(OLD_TOKEN_PATH, new LinkOption[0])) {
            return Files.readAllBytes(OLD_TOKEN_PATH);
        }
        return null;
    }

    public static HashMap<String, String> getAuthTokenHeaders() {
        String oldAuthToken = V3_1_0_BETA_1__Auth_flow_Migration.loadAuthToken();
        if (oldAuthToken != null) {
            HashMap<String, String> additionalHeaders = new HashMap<String, String>();
            additionalHeaders.put("x-auth-token", oldAuthToken);
            String deviceId = "";
            try {
                if (Files.exists(CredentialsUtils.DEVICE_ID_FILE, new LinkOption[0])) {
                    deviceId = (String)AESUtil.decrypt((byte[])Files.readAllBytes(CredentialsUtils.DEVICE_ID_FILE));
                }
            }
            catch (IOException e) {
                log.error("Could not decrypt deviceId", (Throwable)e);
            }
            additionalHeaders.put("X-Device-ID", deviceId);
            return additionalHeaders;
        }
        return null;
    }

    public static void deleteToken() {
        try {
            Files.deleteIfExists(OLD_TOKEN_PATH);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
    }

    public static String loadAuthToken() {
        if (!V3_1_0_BETA_1__Auth_flow_Migration.isApplicable()) {
            return null;
        }
        log.debug("Reading auth token.");
        String authToken = null;
        try {
            byte[] token = V3_1_0_BETA_1__Auth_flow_Migration.getToken();
            if (token == null) {
                log.info("Could not load auth token, byte array is empty.");
            } else {
                authToken = (String)AESUtil.decrypt((byte[])token);
            }
        }
        catch (Exception e) {
            log.error("Could not decrypt auth token.", (Throwable)e);
        }
        return authToken;
    }

    public static boolean isApplicable() {
        return Files.exists(OLD_TOKEN_PATH, new LinkOption[0]);
    }
}

