/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Service
public class KeyCombinationSubstitutionService
extends Service<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyCombinationSubstitutionService.class);
    private Map<String, String> misspellingCorrections = new HashMap();
    private HashMap<String, String> characterCombinations = new HashMap();
    private int caret = -1;

    @PostConstruct
    public void setup() {
        this.setOnFailed(workerStateEvent -> log.error("KeyCombinationSubstitutionService has failed.", this.getException()));
    }

    protected Task<Void> createTask() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void substituteWord(String text, String replacement) {
        Platform.runLater(() -> {
            int oldCaret = TranscriptTextArea.get().getCaretPosition();
            TranscriptTextArea.get().replaceTextWithoutMovingCaret(this.caret - text.length(), this.caret, replacement);
            TranscriptTextArea.get().moveTo(oldCaret + (replacement.length() - text.length()));
            if (Configuration.get().isAutocompletionActive()) {
                List<String> words = Arrays.stream(replacement.split(" ")).filter(word -> word.length() >= Configuration.get().getAutocompletionThreshold()).toList();
                Transcript.get().getAutocompletionWords().addAll(words);
            }
        });
    }

    public void initAutoCorrection() {
        this.misspellingCorrections = Utils.getMisspellingCorrections();
    }

    public void initKeyCombinations() {
        this.characterCombinations.clear();
        Transcript.get().getKeyCombinationFields().forEach((s, s2) -> {
            KeyCombination keyCombination;
            try {
                keyCombination = KeyCombination.valueOf((String)s);
            }
            catch (IllegalArgumentException e) {
                s = KeyCombinationTextField.replaceSpecificByPlatformIndependent((String)s);
                keyCombination = KeyCombination.valueOf((String)s);
            }
            if (keyCombination instanceof KeyCharacterCombination) {
                this.characterCombinations.put(s, s2);
            }
        });
    }

    public void disableAutoCorrection() {
        if (this.misspellingCorrections != null) {
            this.misspellingCorrections.clear();
        }
    }

    @Generated
    public Map<String, String> getMisspellingCorrections() {
        return this.misspellingCorrections;
    }

    @Generated
    public HashMap<String, String> getCharacterCombinations() {
        return this.characterCombinations;
    }

    @Generated
    public int getCaret() {
        return this.caret;
    }

    @Generated
    public void setMisspellingCorrections(Map<String, String> misspellingCorrections) {
        this.misspellingCorrections = misspellingCorrections;
    }

    @Generated
    public void setCharacterCombinations(HashMap<String, String> characterCombinations) {
        this.characterCombinations = characterCombinations;
    }

    @Generated
    public void setCaret(int caret) {
        this.caret = caret;
    }
}

