/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main;

import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.DocumentSerializer;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.TimeRecorder;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.EventStreams;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class TimerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimerService.class);
    private static final int TIMEOUT_MINUTES = 2;
    private final SaveTranscriptService saveTranscriptService;
    private final TimeRecorder timeRecorder;
    private final StatusService statusService;
    ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
    private Timer timeoutTimer;
    private ScheduledFuture<?> autoRecoverTimer;
    private ScheduledFuture<?> autoSaveTimer;

    @PostConstruct
    public void setup() {
        this.scheduler.initialize();
        this.timeoutTimer = this.createTimeoutTimer();
        this.createSaveTimers();
        log.debug("Created timers.");
        EventStreams.changesOf((ObservableValue)Configuration.get().autosaveIntervalProperty()).subscribe(changes -> {
            this.autoSaveTimer.cancel(false);
            this.autoSaveTimer = this.createAutoSaveTimer();
            log.info("Recreated auto save timer with new autosave interval: {} minutes.", (Object)Configuration.get().getAutosaveInterval());
        });
    }

    @PreDestroy
    public void shutdown() {
        this.autoSaveTimer.cancel(false);
        this.autoRecoverTimer.cancel(false);
        this.scheduler.shutdown();
    }

    private void createSaveTimers() {
        if (this.autoSaveTimer != null) {
            this.autoSaveTimer.cancel(false);
        }
        if (this.autoRecoverTimer != null) {
            this.autoRecoverTimer.cancel(false);
        }
        this.autoRecoverTimer = this.createAutoRecoverTimer();
        this.autoSaveTimer = this.createAutoSaveTimer();
    }

    private ScheduledFuture<?> createAutoSaveTimer() {
        Duration interval = Duration.ofMinutes(Configuration.get().getAutosaveInterval());
        Instant startTime = Instant.now().plus(interval);
        return this.scheduler.scheduleWithFixedDelay(() -> this.autoSave(), startTime, interval);
    }

    private void autoSave() {
        if (Configuration.get().isAutosaveActive()) {
            if (Transcript.get() != null && Transcript.get().getTranscriptLocation() != null && !this.statusService.isSaved() && LicenseService.isUserLicenseValid()) {
                log.debug("Auto saving ...");
                Platform.runLater(() -> this.saveTranscriptService.save(Transcript.get(), DocumentSerializer.serializeContent((StyledDocument)TranscriptTextArea.get().getDocument()), false));
            } else {
                log.debug("Did not auto save. Transcript location != null: {}, isSaved: {}, licenseValid: {}", new Object[]{Transcript.get().getTranscriptLocation() != null, this.statusService.isSaved(), LicenseService.isUserLicenseValid()});
            }
        }
    }

    private Timer createTimeoutTimer() {
        return FxTimer.create((Duration)Duration.ofMinutes(2L), () -> {
            log.debug("User has not typed for {} minutes. Pausing the time record.", (Object)2);
            TimeTrackingEntry timeTrackingEntry = this.timeRecorder.stop();
            if (timeTrackingEntry != null) {
                Transcript.get().getTrackedTime().add(timeTrackingEntry);
            }
        });
    }

    private ScheduledFuture<?> createAutoRecoverTimer() {
        Duration interval = Duration.ofMinutes(Configuration.get().getAutoRecoverTimer());
        Instant startTime = Instant.now().plus(interval);
        return this.scheduler.scheduleWithFixedDelay(() -> this.saveAutoRecover(), startTime, interval);
    }

    private void saveAutoRecover() {
        if (Transcript.get() != null) {
            if (!this.statusService.isSaved()) {
                if (Transcript.get().getTranscriptLocation() != null) {
                    if (!LicenseService.isUserLicenseValid()) {
                        log.debug("Could not create autoRecover because license is not valid.");
                        return;
                    }
                    log.debug("Saving auto recover ...");
                    Platform.runLater(() -> this.saveTranscriptService.save(Transcript.get().createShallowCopyForAutoRecover(), DocumentSerializer.serializeContent((StyledDocument)TranscriptTextArea.get().getDocument()), false, true, false, true));
                } else {
                    log.debug("Transcript location is unset. Could not create autoRecover.");
                }
            } else {
                log.debug("No need to save auto recover, transcript is saved.");
            }
        } else {
            log.warn("Could not save auto recover because transcript is null");
        }
    }

    void restartTimeoutTimerOnRichChanges() {
        TranscriptTextArea.get().richChanges().suppressWhen((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribe(f -> {
            this.timeoutTimer.restart();
            if (!this.timeRecorder.hasStarted()) {
                this.timeRecorder.start();
            }
        });
    }

    void listenToTranscriptLoadingForRestarting() {
        this.statusService.transcriptLoadingProperty().addListener((observableValue, oldVal, newVal) -> {
            log.debug("Transcript loading changed to: {}", newVal);
            if (Boolean.TRUE.equals(newVal)) {
                log.debug("Stopping auto save and auto recover timer.");
                if (this.autoSaveTimer != null) {
                    this.autoSaveTimer.cancel(false);
                }
                if (this.autoRecoverTimer != null) {
                    this.autoRecoverTimer.cancel(false);
                }
            } else {
                log.debug("Restarting auto save and auto recover timer.");
                this.createSaveTimers();
            }
        });
    }

    @Generated
    public TimerService(SaveTranscriptService saveTranscriptService, TimeRecorder timeRecorder, StatusService statusService) {
        this.saveTranscriptService = saveTranscriptService;
        this.timeRecorder = timeRecorder;
        this.statusService = statusService;
    }

    @Generated
    public Timer getTimeoutTimer() {
        return this.timeoutTimer;
    }
}

