/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import lombok.Generated;
import org.fxmisc.richtext.NavigationActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NavigationUtils.class);

    private NavigationUtils() {
    }

    public static void skipToPrevWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int caretPos = TranscriptTextArea.get().getCaretPosition();
        if (1 <= caretPos) {
            boolean prevCharIsWhiteSpace = Character.isWhitespace(TranscriptTextArea.get().getText(caretPos - 1, caretPos).charAt(0));
            TranscriptTextArea.get().wordBreaksBackwards(prevCharIsWhiteSpace ? 2 : 1, selectionPolicy);
        }
        TranscriptTextArea.get().requestFollowCaret();
    }

    public static void skipToNextWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int length;
        int caretPos = TranscriptTextArea.get().getCaretPosition();
        if (caretPos <= (length = TranscriptTextArea.get().getLength()) - 1) {
            boolean nextCharIsWhiteSpace = Character.isWhitespace(TranscriptTextArea.get().getText(caretPos, caretPos + 1).charAt(0));
            TranscriptTextArea.get().wordBreaksForwards(nextCharIsWhiteSpace ? 2 : 1, selectionPolicy);
        }
        TranscriptTextArea.get().requestFollowCaret();
    }

    public static void skipToPreviousParagraph(NavigationActions.SelectionPolicy selectionPolicy) {
        TranscriptTextArea.get().paragraphStart(selectionPolicy);
        TranscriptTextArea.get().moveTo(Math.max(0, TranscriptTextArea.get().getCaretPosition() - 1), selectionPolicy);
        TranscriptTextArea.get().paragraphStart(selectionPolicy);
        TranscriptTextArea.get().requestFollowCaret();
    }

    public static void skipToNextParagraph(NavigationActions.SelectionPolicy selectionPolicy) {
        TranscriptTextArea.get().paragraphEnd(selectionPolicy);
        TranscriptTextArea.get().moveTo(Math.min(TranscriptTextArea.get().getLength(), TranscriptTextArea.get().getCaretPosition() + 1), selectionPolicy);
        TranscriptTextArea.get().paragraphEnd(selectionPolicy);
        TranscriptTextArea.get().requestFollowCaret();
    }
}

