/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.AutoCompletionService;
import eu.ewerkzeug.easytranscript3.commons.TutorialService;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.TimestampSegment;
import eu.ewerkzeug.easytranscript3.commons.tutorials.ChangeOfSpeakerTutorial;
import eu.ewerkzeug.easytranscript3.commons.tutorials.Tutorial;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.KeyCombinationSubstitutionService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.SpeakerPopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.WordAlternativesPopup;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.reactfx.EventStreams;
import org.reactfx.util.FxTimer;
import org.reactfx.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TextAreaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextAreaService.class);
    private final KeyCombinationSubstitutionService keyCombinationSubstitutionService;
    private final TutorialService tutorialService;
    private final StatusService statusService;
    private final AutoCompletionService autoCompletionService;
    private InputMap<Event> transcriptKeyCombinationInputMap;
    private Timer autocompletionServiceTimer;

    public static void updateTimestampFormat() {
        log.debug("Updating format of timestamp segments ...");
        TranscriptTextArea.get().getParagraphs().stream().flatMap(paragraph -> paragraph.getStyledSegments().stream()).map(StyledSegment::getSegment).filter(TimestampSegment.class::isInstance).map(TimestampSegment.class::cast).forEach(TimestampSegment::updateFormat);
    }

    private static void setVisibleWhenEditable() {
        TranscriptTextArea.get().editableProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                TranscriptTextArea.get().setVisible(newValue != false || ((Integer)TranscriptTextArea.get().lengthProperty().getValue()).longValue() != 0L);
                TranscriptTextArea.get().requestFocus();
            }
        });
    }

    public static void hideAllContextPopups() {
        WordAlternativesPopup.getInstance().hide();
        SpeakerPopup.getInstance().hide();
        TranscriptTextArea.get().getAutocompletePopup().hide();
    }

    @PostConstruct
    public void postConstruct() {
        this.autocompletionServiceTimer = FxTimer.createPeriodic((Duration)Duration.ofSeconds(30L), () -> ((AutoCompletionService)this.autoCompletionService).restart());
    }

    public void initializeListeners() {
        this.disableOnLoading();
        TranscriptTextArea.get().richChanges().suppressWhen((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribe(f -> {
            TextAreaService.hideAllContextPopups();
            this.statusService.setSaved(false);
        });
        this.restartAutocompletionTimerAfterLoading();
        TextAreaService.setVisibleWhenEditable();
    }

    private void disableOnLoading() {
        TranscriptTextArea.get().disableProperty().bind((ObservableValue)this.statusService.transcriptLoadingProperty().or((ObservableBooleanValue)this.statusService.transcriptLoadedProperty().not()));
    }

    private void restartAutocompletionTimerAfterLoading() {
        EventStreams.changesOf((ObservableValue)this.statusService.transcriptLoadingProperty()).subscribe(change -> {
            if (Boolean.FALSE.equals(change.getNewValue())) {
                this.autocompletionServiceTimer.restart();
            } else {
                this.autocompletionServiceTimer.stop();
            }
        });
    }

    public void insertSpeaker() {
        Speaker speaker = this.findPreviousSpeaker();
        speaker = Transcript.get().getNextSpeaker(Transcript.get().getSpeakers().indexOf(speaker));
        if (speaker == null && !Transcript.get().getSpeakers().isEmpty()) {
            log.debug("No speaker found before caret. Inserting first speaker.");
            speaker = (Speaker)Transcript.get().getSpeakers().getFirst();
        }
        if (speaker != null) {
            SpeakerUtils.insertSpeaker((Speaker)speaker);
            this.showSpeakerTutorial();
        }
    }

    private Speaker findPreviousSpeaker() {
        List paragraphs = TranscriptTextArea.get().getParagraphs().subList(0, TranscriptTextArea.get().getCurrentParagraph());
        int caretPosition = TranscriptTextArea.get().getCaretPosition();
        int pos = paragraphs.stream().map(Paragraph::length).mapToInt(Integer::intValue).sum();
        for (int i = paragraphs.size() - 1; i >= 0; --i) {
            Paragraph paragraph = (Paragraph)paragraphs.get(i);
            List styledSegments = paragraph.getStyledSegments();
            for (int j = styledSegments.size() - 1; j >= 0; --j) {
                Object object;
                StyledSegment segment = (StyledSegment)styledSegments.get(j);
                if (pos <= caretPosition && (object = segment.getSegment()) instanceof SpeakerSegment) {
                    SpeakerSegment speakerSegment = (SpeakerSegment)object;
                    Optional<Speaker> first = Transcript.get().getSpeakers().stream().filter(s -> s.getUuid().toString().equals(speakerSegment.getUuid())).findFirst();
                    if (first.isPresent()) {
                        return first.get();
                    }
                }
                pos -= ((AbstractSegment)segment.getSegment()).length();
            }
        }
        return null;
    }

    private void showSpeakerTutorial() {
        if (!Configuration.get().getSeenTutorials().contains("ChangeOfSpeaker")) {
            FxTimer.runLater((Duration)Duration.ofMillis(200L), () -> this.tutorialService.show((Tutorial)new ChangeOfSpeakerTutorial()).subscribeForOne(ignored -> {
                Configuration.get().getSeenTutorials().add("ChangeOfSpeaker");
                Configuration.get().save();
            }));
        }
    }

    public void registerTranscriptKeyCombinationSubstitution() {
        Nodes.removeInputMap((Node)TranscriptTextArea.get(), (InputMap)this.transcriptKeyCombinationInputMap);
        this.keyCombinationSubstitutionService.initKeyCombinations();
        if (Configuration.get().isAutoCorrectionActive()) {
            this.keyCombinationSubstitutionService.initAutoCorrection();
        } else {
            this.keyCombinationSubstitutionService.disableAutoCorrection();
        }
        ArrayList maps = new ArrayList();
        Transcript.get().getKeyCombinationFields().forEach((s, s2) -> {
            if (!(KeyCombination.valueOf((String)(s = KeyCombinationTextField.replaceSpecificByPlatformIndependent((String)s))) instanceof KeyCharacterCombination)) {
                maps.add(InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)KeyCombination.valueOf((String)s)), e -> {
                    if (TranscriptTextArea.get().getSelection().getLength() == 0) {
                        TranscriptTextArea.get().insertText(TranscriptTextArea.get().getCaretPosition(), s2);
                    } else {
                        TranscriptTextArea.get().replaceSelection(s2);
                    }
                    TranscriptTextArea.get().requestFollowCaret();
                }));
            }
        });
        InputMap[] array = maps.toArray(new InputMap[0]);
        this.transcriptKeyCombinationInputMap = InputMap.sequence((InputMap[])array);
        Nodes.addInputMap((Node)TranscriptTextArea.get(), (InputMap)this.transcriptKeyCombinationInputMap);
    }

    @Generated
    public TextAreaService(KeyCombinationSubstitutionService keyCombinationSubstitutionService, TutorialService tutorialService, StatusService statusService, AutoCompletionService autoCompletionService) {
        this.keyCombinationSubstitutionService = keyCombinationSubstitutionService;
        this.tutorialService = tutorialService;
        this.statusService = statusService;
        this.autoCompletionService = autoCompletionService;
    }
}

