/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentCodec;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SegmentOps;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.StyledTextSegment;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.CustomClipboardActions;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.CustomUndoActions;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ParagraphStyleManager;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyleManager;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.UndoUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.ZoomUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AutocompletePopup;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.TextFlow;
import lombok.Generated;
import org.fxmisc.flowless.ScaledVirtualized;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.reactfx.SuspendableYes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TranscriptTextArea
extends GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>
implements CustomClipboardActions<ParStyle, AbstractSegment<?>, TextStyle>,
CustomUndoActions {
    static final Logger log = LoggerFactory.getLogger(TranscriptTextArea.class);
    public static final SegmentOps STYLED_TEXT_OPS = new SegmentOps();
    public static final String PARAGRAPH_TAG = "Paragraph";
    public static final double MAX_ZOOM = 5.0;
    public static final double MIN_ZOOM = 0.8;
    private static final TranscriptTextArea textArea = TranscriptTextArea.createTranscriptTextArea();
    private static final ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>> scaledVirtualized = new ScaledVirtualized((Node)textArea);
    private static final VirtualizedScrollPane<ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>>> vsPane = new VirtualizedScrollPane((Region)scaledVirtualized);
    private final SuspendableYes undoSuspendable = new SuspendableYes();
    private final AutocompletePopup autocompletePopup = new AutocompletePopup();
    private final TextStyleManager textStyleManager;
    private final ParagraphStyleManager paragraphStyleManager;

    private TranscriptTextArea(ParStyle initialParagraphStyle, BiConsumer<TextFlow, ParStyle> applyParagraphStyle, TextStyle initialTextStyle, TextOps<AbstractSegment<?>, TextStyle> segmentOps, Function<StyledSegment<AbstractSegment<?>, TextStyle>, Node> nodeFactory) {
        super((Object)initialParagraphStyle, applyParagraphStyle, (Object)initialTextStyle, segmentOps, true, nodeFactory);
        log.debug("Initializing transcriptTextArea.");
        this.setUndoManager(UndoUtils.richTextUncheckedUndoManager((GenericStyledArea)this, (SuspendableYes)this.undoSuspendable));
        this.addZoomOnScroll();
        log.debug("Adding listeners and setting configuration.");
        this.caretPositionProperty().addListener((observable, oldValue, newValue) -> this.requestFollowCaret());
        this.setShowCaret(Caret.CaretVisibility.AUTO);
        this.setWrapText(true);
        log.debug("Setting style codecs.");
        this.setStyleCodecs(ParStyle.CODEC, (Codec)new SegmentCodec());
        this.textStyleManager = new TextStyleManager(this);
        this.paragraphStyleManager = new ParagraphStyleManager(this);
        log.info("TranscriptTextArea initialized.");
    }

    private void addZoomOnScroll() {
        this.addEventFilter(ScrollEvent.ANY, e -> {
            if (e.isShortcutDown()) {
                e.consume();
                ZoomUtils.zoom((e.getDeltaY() > 0.0 ? 1 : 0) != 0);
            }
        });
    }

    private static TranscriptTextArea createTranscriptTextArea() {
        return new TranscriptTextArea(TranscriptTextArea.getDefaultParagraphStyle(), (paragraph, style) -> paragraph.setStyle(style.toCss()), TranscriptTextArea.getDefaultTextStyle(), (TextOps)STYLED_TEXT_OPS, styledSeg -> ((AbstractSegment)styledSeg.getSegment()).createNode((TextStyle)styledSeg.getStyle()));
    }

    public static TranscriptTextArea get() {
        return textArea;
    }

    public static TextStyle getDefaultTextStyle() {
        return TextStyle.EMPTY.updateFontSize(Configuration.get().getFormattingSize()).updateFontFamily(Configuration.get().getFormattingFont()).updateBold(Configuration.get().isFormattingBold()).updateItalic(Configuration.get().isFormattingItalic()).updateUnderline(Configuration.get().isFormattingUnderlined()).updateTextColor(null);
    }

    public static ParStyle getDefaultParagraphStyle() {
        return ParStyle.EMPTY.updateAlignment(Configuration.get().getFormattingParagraphAlignment());
    }

    public void runInPreventUndoMerge(Runnable runnable) {
        this.getUndoManager().preventMerge();
        runnable.run();
        this.getUndoManager().preventMerge();
    }

    public void commitMultiChange(MultiChangeBuilder<?, ?, ?> multiChange) {
        TranscriptTextArea.get().runInPreventUndoMerge(() -> multiChange.commit());
    }

    public IndexRange getSelection() {
        int end;
        IndexRange selection = super.getSelection();
        int maxEnd = this.getLength();
        int start = Math.min(Math.max(selection.getStart(), 0), maxEnd);
        if (start > (end = Math.max(0, Math.min(selection.getEnd(), maxEnd)))) {
            end = start;
        }
        return new IndexRange(start, end);
    }

    public void replaceTextWithoutMovingCaret(int start, int end, String text) {
        ReadOnlyStyledDocument doc = ReadOnlyStyledDocument.fromSegment((Object)new StyledTextSegment((Object)text), (Object)((ParStyle)this.getParagraphStyleForInsertionAt(start)), (Object)((TextStyle)this.getStyleAtPosition(start)), (org.fxmisc.richtext.model.SegmentOps)STYLED_TEXT_OPS);
        this.replaceWithoutMovingCaret(start, end, (StyledDocument)doc);
    }

    public void replaceWithoutMovingCaret(int start, int end, StyledDocument<ParStyle, AbstractSegment<?>, TextStyle> doc) {
        ((EditableStyledDocument)textArea.getDocument()).replace(start, end, doc);
    }

    @Generated
    public static ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>> getScaledVirtualized() {
        return scaledVirtualized;
    }

    @Generated
    public static VirtualizedScrollPane<ScaledVirtualized<GenericStyledArea<ParStyle, AbstractSegment<?>, TextStyle>>> getVsPane() {
        return vsPane;
    }

    @Generated
    public AutocompletePopup getAutocompletePopup() {
        return this.autocompletePopup;
    }

    @Generated
    public TextStyleManager getTextStyleManager() {
        return this.textStyleManager;
    }

    @Generated
    public ParagraphStyleManager getParagraphStyleManager() {
        return this.paragraphStyleManager;
    }

    static {
        vsPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
    }
}

