/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor;

import eu.ewerkzeug.easytranscript3.commons.fx.controls.MultiChangeUndoManagerNoCheck;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextChange;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;
import org.fxmisc.undo.impl.ChangeQueue;
import org.fxmisc.undo.impl.UnlimitedChangeQueue;
import org.reactfx.SuspendableYes;

/*
 * Exception performing whole class analysis ignored.
 */
public final class UndoUtils {
    public static final Duration DEFAULT_PREVENT_MERGE_DELAY = Duration.ofMillis(500L);

    private UndoUtils() {
        throw new IllegalStateException("UndoUtils cannot be instantiated");
    }

    public static <PS, SEG, S> UndoManager defaultUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return area.isPreserveStyle() ? UndoUtils.richTextUndoManager(area) : UndoUtils.plainTextUndoManager(area);
    }

    public static UndoManager noOpUndoManager() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return UndoUtils.richTextUndoManager(area, (UndoManagerFactory)UndoManagerFactory.unlimitedHistoryFactory());
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay) {
        return UndoUtils.richTextUndoManager(area, (UndoManagerFactory)UndoManagerFactory.unlimitedHistoryFactory(), (Duration)preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory) {
        return UndoUtils.richTextUndoManager(area, (UndoManagerFactory)factory, (Duration)DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory, Duration preventMergeDelay) {
        return factory.createMultiChangeUM(area.multiRichChanges(), TextChange::invert, UndoUtils.applyMultiRichTextChange(area), TextChange::mergeWith, TextChange::isIdentity, preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUncheckedUndoManager(GenericStyledArea<PS, SEG, S> area, SuspendableYes suspendUndo) {
        return UndoUtils.richTextUncheckedUndoManager(area, (Duration)DEFAULT_PREVENT_MERGE_DELAY, (SuspendableYes)suspendUndo);
    }

    public static <PS, SEG, S> UndoManager<List<RichTextChange<PS, SEG, S>>> richTextUncheckedUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay, SuspendableYes suspendUndo) {
        return new MultiChangeUndoManagerNoCheck((ChangeQueue)new UnlimitedChangeQueue(), TextChange::invert, UndoUtils.applyMultiRichTextChange(area), TextChange::mergeWith, TextChange::isIdentity, area.multiRichChanges().conditionOn((ObservableValue)suspendUndo), preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return UndoUtils.plainTextUndoManager(area, (Duration)DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay) {
        return UndoUtils.plainTextUndoManager(area, (UndoManagerFactory)UndoManagerFactory.unlimitedHistoryFactory(), (Duration)preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory) {
        return UndoUtils.plainTextUndoManager(area, (UndoManagerFactory)factory, (Duration)DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<List<PlainTextChange>> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory, Duration preventMergeDelay) {
        return factory.createMultiChangeUM(area.multiPlainChanges(), TextChange::invert, UndoUtils.applyMultiPlainTextChange(area), TextChange::mergeWith, TextChange::isIdentity, preventMergeDelay);
    }

    public static <PS, SEG, S> Consumer<PlainTextChange> applyPlainTextChange(GenericStyledArea<PS, SEG, S> area) {
        return change -> area.replaceText(change.getPosition(), change.getRemovalEnd(), (String)change.getInserted());
    }

    public static <PS, SEG, S> Consumer<RichTextChange<PS, SEG, S>> applyRichTextChange(GenericStyledArea<PS, SEG, S> area) {
        return change -> area.replace(change.getPosition(), change.getRemovalEnd(), (StyledDocument)change.getInserted());
    }

    public static <PS, SEG, S> Consumer<List<PlainTextChange>> applyMultiPlainTextChange(GenericStyledArea<PS, SEG, S> area) {
        return changeList -> {
            MultiChangeBuilder builder = area.createMultiChange(changeList.size());
            for (PlainTextChange c : changeList) {
                builder.replaceTextAbsolutely(c.getPosition(), c.getRemovalEnd(), (String)c.getInserted());
            }
            builder.commit();
        };
    }

    public static <PS, SEG, S> Consumer<List<RichTextChange<PS, SEG, S>>> applyMultiRichTextChange(GenericStyledArea<PS, SEG, S> area) {
        return changeList -> {
            MultiChangeBuilder builder = area.createMultiChange(changeList.size());
            for (RichTextChange c : changeList) {
                builder.replaceAbsolutely(c.getPosition(), c.getRemovalEnd(), (StyledDocument)c.getInserted());
            }
            builder.commit();
        };
    }
}

