/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AutocompleteWord;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PartialHighlightedListCell;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PositioningReferencePopup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutocompletePopup
extends PositioningReferencePopup<AutocompleteWord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutocompletePopup.class);
    private String lastPrefix;

    public AutocompletePopup() {
        this.listView.setCellFactory(stringListView -> new PartialHighlightedListCell());
    }

    public void insert(AutocompleteWord word) {
        log.debug("Selected auto complete word, inserting.");
        TranscriptTextArea.get().insertText(TranscriptTextArea.get().getCaretPosition(), word.getText().substring(this.lastPrefix.length()));
    }

    public boolean findWordSuggestions(Set<String> wordSet, String prefix) {
        this.lastPrefix = prefix;
        if (prefix.length() < Configuration.get().getAutocompletionThreshold()) {
            this.hide();
            return false;
        }
        List<AutocompleteWord> collect = wordSet.stream().filter(highlightable -> !highlightable.equals(prefix) && highlightable.startsWith(prefix)).map(f -> new AutocompleteWord(f, prefix.length())).sorted(Comparator.comparingInt(f -> f.getText().length())).toList();
        if (collect.isEmpty()) {
            this.hide();
            return false;
        }
        this.listView.setItems(FXCollections.observableList(new ArrayList<AutocompleteWord>(collect)));
        return true;
    }
}

