/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerListCell;
import eu.ewerkzeug.easytranscript3.commons.fx.SpeakerUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.SpeakerSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.AbstractPopup;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.Speaker;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.geometry.Bounds;
import lombok.Generated;
import org.fxmisc.richtext.model.StyledSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeakerPopup
extends AbstractPopup<Speaker, SpeakerSegment> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpeakerPopup.class);
    private static final SpeakerPopup instance = new SpeakerPopup();
    SpeakerSegment speakerSegment = null;

    private SpeakerPopup() {
        this.listView.setCellFactory(stringListView -> new SpeakerListCell());
    }

    public void show(SpeakerSegment speakerSegment) {
        Platform.runLater(() -> {
            this.speakerSegment = speakerSegment;
            if (speakerSegment.getLabel() != null) {
                Bounds boundsOfTextArea = speakerSegment.getLabel().localToScreen(speakerSegment.getLabel().getBoundsInLocal());
                double x = 0.0;
                double y = 0.0;
                if (boundsOfTextArea != null) {
                    x = boundsOfTextArea.getMinX();
                    y = boundsOfTextArea.getMaxY();
                }
                this.showAt(x, y);
                return;
            }
            TranscriptTextArea textArea = TranscriptTextArea.get();
            Optional caretBounds = textArea.getCaretBounds();
            Bounds boundsOfTextArea = textArea.localToScreen(textArea.getBoundsInLocal());
            double x = boundsOfTextArea.getMinX();
            double y = boundsOfTextArea.getMinY();
            if (caretBounds.isPresent()) {
                x = ((Bounds)caretBounds.get()).getMaxX();
                y = ((Bounds)caretBounds.get()).getMaxY();
            }
            this.showAt(x, y);
        });
    }

    public void setSpeakers(List<Speaker> speakers) {
        this.listView.setItems(FXCollections.observableArrayList(speakers));
    }

    void insert(Speaker speaker) {
        int pos = 0;
        List styledSegments = TranscriptTextArea.get().getParagraph(TranscriptTextArea.get().getCurrentParagraph()).getStyledSegments();
        for (StyledSegment s : styledSegments) {
            SpeakerSegment speakerSeg;
            pos += ((AbstractSegment)s.getSegment()).length();
            Object object = s.getSegment();
            if (!(object instanceof SpeakerSegment) || (speakerSeg = (SpeakerSegment)object).getLabel() != this.speakerSegment.getLabel()) continue;
            break;
        }
        int moveBy = pos - TranscriptTextArea.get().getCaretColumn();
        TranscriptTextArea.get().moveTo(TranscriptTextArea.get().getCaretPosition() + moveBy);
        TranscriptTextArea.get().getUndoManager().preventMerge();
        TranscriptTextArea.get().deletePreviousChar();
        SpeakerUtils.insertSpeaker((Speaker)speaker, (boolean)false);
        TranscriptTextArea.get().getUndoManager().preventMerge();
    }

    @Generated
    public static SpeakerPopup getInstance() {
        return instance;
    }
}

