/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.editor.popup;

import eu.ewerkzeug.easytranscript3.commons.fx.FXUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.AbstractSegment;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceData;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.textfield.LowConfidenceSegment;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextStyle;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntry;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PopupEntryListCell;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.popup.PositioningReferencePopup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordAlternativesPopup
extends PositioningReferencePopup<PopupEntry> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WordAlternativesPopup.class);
    private static final WordAlternativesPopup instance = new WordAlternativesPopup();
    private LowConfidenceSegment lowConfidenceSegment;

    public WordAlternativesPopup() {
        this.listView.setCellFactory(stringListView -> new PopupEntryListCell());
        SpacedText spacedText = new SpacedText("Leider konnte keine Alternative gefunden werden.", Double.valueOf(0.8));
        spacedText.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.listView.setPlaceholder((Node)spacedText);
    }

    public static ArrayList<String> getWordsFromStyle(TextStyle textStyle) {
        String wordsRaw = textStyle.wordAlternativesOptional.orElse("[]");
        return new ArrayList<String>(Arrays.stream(wordsRaw.replaceAll("[\\[\\]\"]", "").split(",")).map(String::trim).map(StringEscapeUtils::unescapeJava).toList());
    }

    void insert(PopupEntry alternative) {
        int index = FXUtils.findAbsolutePositionOfSegment((AbstractSegment)this.lowConfidenceSegment);
        String selected = ((PopupEntry)this.listView.getSelectionModel().getSelectedItem()).getText();
        TranscriptTextArea area = TranscriptTextArea.get();
        LowConfidenceSegment replacementSegment = this.getLowConfidenceReplacementSegment(selected);
        area.replace(index, index + this.lowConfidenceSegment.length(), (Object)replacementSegment, (Object)((TextStyle)area.getTextInsertionStyle()));
    }

    @NotNull
    private LowConfidenceSegment getLowConfidenceReplacementSegment(String selected) {
        LowConfidenceData lowConfidenceData = new LowConfidenceData();
        ArrayList<String> alternatives = new ArrayList<String>(this.lowConfidenceSegment.getAlternatives());
        alternatives.add(this.lowConfidenceSegment.getRealText());
        alternatives.remove(selected);
        lowConfidenceData.setWord(selected);
        lowConfidenceData.setAlternatives(alternatives);
        lowConfidenceData.setConfidence(lowConfidenceData.getConfidence());
        return new LowConfidenceSegment(lowConfidenceData, true);
    }

    public void show(LowConfidenceSegment lowConfidenceSegment) {
        this.lowConfidenceSegment = lowConfidenceSegment;
        if (lowConfidenceSegment == null) {
            log.warn("No low confidence segment set.");
            return;
        }
        Bounds bounds = lowConfidenceSegment.getTextNode().localToScreen(lowConfidenceSegment.getTextNode().getLayoutBounds());
        this.showAt(bounds.getMinX(), bounds.getMaxY());
    }

    public void addWordAlternativesToPopup(List<String> words) {
        this.listView.getItems().clear();
        if (!words.isEmpty()) {
            this.listView.setPrefHeight(-1.0);
            List<PopupEntry> popupEntries = words.stream().map(PopupEntry::new).toList();
            this.listView.getItems().addAll(popupEntries);
            this.listView.refresh();
        } else {
            this.listView.setPrefHeight(60.0);
        }
    }

    @Generated
    public static WordAlternativesPopup getInstance() {
        return instance;
    }
}

