/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.menubar;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.TimestampUtils;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.main.menubar.searchbar.SearchbarService;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCombination;
import lombok.Generated;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MenuBarService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MenuBarService.class);
    private final BooleanProperty useSystemBarMenu = new SimpleBooleanProperty(false);
    private final TextAreaService textAreaService;
    private final SearchbarService searchbarService;

    public List<MenuItem> createEditMenuItems(boolean withAccelerator) {
        ResourceBundle bundle = Utils.getLocaleBundle();
        Action undoAction = new Action(bundle.getString("mainScreen.undo"), event -> this.undo());
        TranscriptTextArea.get().undoAvailableProperty().addListener((observableValue, aBoolean, t1) -> undoAction.setDisabled(t1 == false));
        if (withAccelerator) {
            undoAction.setAccelerator((KeyCombination)new KeyCharacterCombination("Z", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action redoAction = new Action(bundle.getString("mainScreen.redo"), event -> this.redo());
        TranscriptTextArea.get().redoAvailableProperty().addListener((observableValue, aBoolean, t1) -> redoAction.setDisabled(t1 == false));
        if (withAccelerator) {
            redoAction.setAccelerator((KeyCombination)new KeyCharacterCombination("Y", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action boldAction = new Action(bundle.getString("mainScreen.bold"), event -> this.toggleBold());
        if (withAccelerator) {
            boldAction.setAccelerator((KeyCombination)new KeyCharacterCombination("B", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action italicAction = new Action(bundle.getString("mainScreen.italic"), event -> this.toggleItalic());
        if (withAccelerator) {
            italicAction.setAccelerator((KeyCombination)new KeyCharacterCombination("I", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action underlinedAction = new Action(bundle.getString("mainScreen.underline"), event -> this.toggleUnderline());
        if (withAccelerator) {
            underlinedAction.setAccelerator((KeyCombination)new KeyCharacterCombination("U", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action copyAction = new Action(bundle.getString("mainScreen.copy"), event -> this.copy());
        copyAction.disabledProperty().bind((ObservableValue)this.getSelectionBinding());
        if (withAccelerator) {
            copyAction.setAccelerator((KeyCombination)new KeyCharacterCombination("C", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action cutAction = new Action(bundle.getString("mainScreen.cut"), event -> this.cut());
        cutAction.disabledProperty().bind((ObservableValue)this.getSelectionBinding());
        if (withAccelerator) {
            cutAction.setAccelerator((KeyCombination)new KeyCharacterCombination("X", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action pasteAction = new Action(bundle.getString("mainScreen.paste"), event -> this.paste());
        if (withAccelerator) {
            pasteAction.setAccelerator((KeyCombination)new KeyCharacterCombination("V", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action searchAndReplaceAction = new Action(bundle.getString("mainScreen.searchAndReplaceMenuItem"), event -> this.showSearch());
        if (withAccelerator) {
            searchAndReplaceAction.setAccelerator((KeyCombination)new KeyCharacterCombination("F", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action insertTimestampAction = new Action(bundle.getString("mainScreen.insertTimestamp"), event -> this.insertTimestamp());
        if (withAccelerator) {
            insertTimestampAction.setAccelerator((KeyCombination)new KeyCharacterCombination("T", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        }
        Action insertSpeakerAction = new Action(bundle.getString("mainScreen.insertSpeaker"), event -> this.insertSpeaker());
        if (withAccelerator) {
            insertSpeakerAction.setAccelerator((KeyCombination)new KeyCharacterCombination("P", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}));
        }
        Menu wordAlternativesMenu = new Menu(bundle.getString("mainScreen.wordAlternatives"));
        wordAlternativesMenu.getItems().addListener(change -> wordAlternativesMenu.setDisable(wordAlternativesMenu.getItems().isEmpty()));
        wordAlternativesMenu.setDisable(true);
        return List.of(ActionUtils.createMenuItem((Action)undoAction), ActionUtils.createMenuItem((Action)redoAction), new SeparatorMenuItem(), ActionUtils.createMenuItem((Action)boldAction), ActionUtils.createMenuItem((Action)italicAction), ActionUtils.createMenuItem((Action)underlinedAction), new SeparatorMenuItem(), ActionUtils.createMenuItem((Action)copyAction), ActionUtils.createMenuItem((Action)cutAction), ActionUtils.createMenuItem((Action)pasteAction), new SeparatorMenuItem(), ActionUtils.createMenuItem((Action)searchAndReplaceAction), new SeparatorMenuItem(), ActionUtils.createMenuItem((Action)insertTimestampAction), new SeparatorMenuItem(), ActionUtils.createMenuItem((Action)insertSpeakerAction));
    }

    @NotNull
    public BooleanBinding getSelectionBinding() {
        return Bindings.createBooleanBinding(() -> !((String)TranscriptTextArea.get().textProperty().getValue()).isEmpty() && ((IndexRange)TranscriptTextArea.get().selectionProperty().getValue()).getLength() == 0, (Observable[])new Observable[]{TranscriptTextArea.get().selectionProperty()});
    }

    public void undo() {
        if (GUIState.getMainStage().isFocused()) {
            TranscriptTextArea.get().undo();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void redo() {
        if (GUIState.getMainStage().isFocused()) {
            TranscriptTextArea.get().redo();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void toggleBold() {
        if (GUIState.getMainStage().isFocused() && TranscriptTextArea.get().isEditable()) {
            TranscriptTextArea.get().getTextStyleManager().toggleBold();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void toggleItalic() {
        if (GUIState.getMainStage().isFocused() && TranscriptTextArea.get().isEditable()) {
            TranscriptTextArea.get().getTextStyleManager().toggleItalic();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void toggleUnderline() {
        if (GUIState.getMainStage().isFocused() && TranscriptTextArea.get().isEditable()) {
            TranscriptTextArea.get().getTextStyleManager().toggleUnderline();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void copy() {
        if (GUIState.getMainStage().isFocused()) {
            TranscriptTextArea.get().copy();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void cut() {
        if (GUIState.getMainStage().isFocused()) {
            TranscriptTextArea.get().cut();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void paste() {
        if (GUIState.getMainStage().isFocused()) {
            TranscriptTextArea.get().paste();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void showSearch() {
        if (GUIState.getMainStage().isFocused() && TranscriptTextArea.get().isVisible()) {
            this.searchbarService.getSearchBarOpenedProperty().set(false);
            this.searchbarService.getSearchBarOpenedProperty().set(true);
        }
    }

    public void insertTimestamp() {
        if (GUIState.getMainStage().isFocused() && TranscriptTextArea.get().isEditable()) {
            TimestampUtils.insertTimestamp();
            TranscriptTextArea.get().requestFocus();
        }
    }

    public void insertSpeaker() {
        if (GUIState.getMainStage().isFocused() && TranscriptTextArea.get().isEditable()) {
            this.textAreaService.insertSpeaker();
            TranscriptTextArea.get().requestFocus();
        }
    }

    @Generated
    public MenuBarService(TextAreaService textAreaService, SearchbarService searchbarService) {
        this.textAreaService = textAreaService;
        this.searchbarService = searchbarService;
    }

    @Generated
    public BooleanProperty getUseSystemBarMenu() {
        return this.useSystemBarMenu;
    }
}

