/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.main.playerbar;

import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETProgressBar;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerService;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import eu.ewerkzeug.easytranscript3.mvc.player.fx.FXPlayer;
import eu.ewerkzeug.easytranscript3.mvc.player.vlcj.VLCJPlayer;
import java.time.Instant;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.SVGPath;
import javafx.util.Duration;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;

@FxmlView(value="playerBar.fxml")
@Component
@Lazy
public class PlayerBarController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlayerBarController.class);
    private final PlayerService playerService;
    private final StatusService statusService;
    private final ChangeListener<Number> volumeSliderListener = (observable, oldValue, newValue) -> Main.getPlayer().setVolume(Utils.round2Places((double)(newValue.doubleValue() / 100.0)));
    @FXML
    private GridPane playerBarVolumeGridPane;
    @FXML
    private GridPane playerBarSpeedGridPane;
    @FXML
    private VBox playerBarControlsVBox;
    @FXML
    private Slider windingIntervalSlider;
    @FXML
    private Slider speedSlider;
    @FXML
    private Label currentTimeLabel;
    @FXML
    private Label totalTimeLabel;
    @FXML
    private Slider volumeSlider;
    private final ChangeListener<Number> volumePropertyListener = (observableValue, number, t1) -> this.volumeSlider.setValue(t1.doubleValue() * 100.0);
    @FXML
    private Label currentVolumeLabel;
    @FXML
    private Label windingIntervalLabel;
    @FXML
    private Label speedIntervalLabel;
    @FXML
    private SVGPath playButtonSVGPath;
    private final ChangeListener<PlayerState> playerStateButtonListener = (observableValue, playerState, state) -> {
        if (state.equals((Object)PlayerState.LOADED) || state.equals((Object)PlayerState.PAUSED) || state.equals((Object)PlayerState.STOPPED)) {
            this.setPlayButtonIcon();
        } else if (state.equals((Object)PlayerState.PLAYING)) {
            this.setPauseButtonIcon();
        }
    };
    @FXML
    private ETProgressBar playerProgressBar;
    private final ChangeListener<Boolean> valueChangingProgressSliderChangeListener = (observable, oldValue, newValue) -> {
        if (oldValue.booleanValue() && !newValue.booleanValue()) {
            Main.getPlayer().setTime((long)((int)Duration.millis((double)this.playerProgressBar.getValue()).toMillis()));
        }
    };
    private ChangeListener<Number> progressSliderValueListener;

    public void reset() {
    }

    public void initializeController() {
        this.progressSliderValueListener = (observable, oldValue, newValue) -> Platform.runLater(() -> this.currentTimeLabel.setText(this.playerService.getTimeFormat().format(Instant.ofEpochMilli((long)this.playerProgressBar.getValue()))));
        Platform.runLater(() -> {
            this.volumeSlider.valueProperty().addListener((arg_0, arg_1, arg_2) -> this.sliderValueChanged(arg_0, arg_1, arg_2));
            this.currentVolumeLabel.textProperty().bind((ObservableValue)this.volumeSlider.valueProperty().asString("%.0f"));
            this.windingIntervalLabel.textProperty().bind((ObservableValue)this.windingIntervalSlider.valueProperty().asString("%.0f"));
            this.speedIntervalLabel.textProperty().bind((ObservableValue)this.speedSlider.valueProperty().asString("%.1f"));
            Configuration.get().playerRewindProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            Configuration.get().playerPlayPauseProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            Configuration.get().playerFastForwardProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            Configuration.get().playerFasterProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            Configuration.get().playerSlowerProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            Configuration.get().playerQuieterProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            Configuration.get().playerLouderProperty().addListener((observable, oldValue, newValue) -> this.registerPlayerShortcuts());
            this.registerPlayerShortcuts();
            this.root.disableProperty().bind((ObservableValue)this.statusService.transcriptLoadedProperty().not());
        });
    }

    private void sliderValueChanged(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
        if (oldValue.intValue() == 0 && newValue.intValue() > 0) {
            this.volumeSlider.getStyleClass().add((Object)"active-slider");
        } else if (oldValue.intValue() > 0 && newValue.intValue() == 0) {
            this.volumeSlider.getStyleClass().remove((Object)"active-slider");
        }
    }

    public void playPause() {
        if (Main.getPlayer() != null && Transcript.get().getMediaLocation() != null) {
            this.playerService.playPause();
        }
    }

    public void resetSliders() {
        this.volumeSlider.maxProperty().unbind();
        this.volumeSlider.maxProperty().bind((ObservableValue)Main.getPlayer().maximumVolumeProperty());
        this.volumeSlider.setValue(100.0);
        this.speedSlider.setValue(1.0);
        this.playerProgressBar.setValue(0.0);
    }

    public void initializePlayerBar() {
        this.addPlayerListeners();
        this.playerProgressBar.valueProperty().removeListener(this.progressSliderValueListener);
        this.playerProgressBar.valueProperty().addListener(this.progressSliderValueListener);
        this.playerProgressBar.valueChangingProperty().removeListener(this.valueChangingProgressSliderChangeListener);
        this.playerProgressBar.valueChangingProperty().addListener(this.valueChangingProgressSliderChangeListener);
        this.volumeSlider.valueProperty().removeListener(this.volumeSliderListener);
        this.volumeSlider.valueProperty().addListener(this.volumeSliderListener);
        Main.getPlayer().volumeProperty().removeListener(this.volumePropertyListener);
        Main.getPlayer().volumeProperty().addListener(this.volumePropertyListener);
        Main.getPlayer().stateProperty().removeListener(this.playerStateButtonListener);
        Main.getPlayer().stateProperty().addListener(this.playerStateButtonListener);
        this.windingIntervalSlider.valueProperty().bindBidirectional((Property)Configuration.get().windingIntervalProperty());
        this.speedSlider.valueProperty().bindBidirectional((Property)Main.getPlayer().rateProperty());
    }

    public void rewind() {
        if (Main.getPlayer() != null && Transcript.get().getMediaLocation() != null) {
            this.playerService.changeTime(false);
        }
    }

    public void fastForward() {
        if (Main.getPlayer() != null && Transcript.get().getMediaLocation() != null) {
            this.playerService.changeTime(true);
        }
    }

    public void faster() {
        Main.getPlayer().setRate(Math.min(2.0, Main.getPlayer().rateProperty().getValue() + 0.1));
    }

    public void slower() {
        Main.getPlayer().setRate(Math.max(0.5, Main.getPlayer().rateProperty().getValue() - 0.1));
    }

    public void louder() {
        Main.getPlayer().setVolume(Math.min((double)((float)Main.getPlayer().maximumVolumeProperty().get() / 100.0f), Main.getPlayer().volumeProperty().getValue() + 0.1));
    }

    public void quieter() {
        Main.getPlayer().setVolume(Math.max(0.0, Main.getPlayer().volumeProperty().getValue() - 0.1));
    }

    private void addPlayerListeners() {
        log.debug("Adding time related Listeners ...");
        Runnable onCompleted = () -> {
            log.debug("Determining Duration: {}", (Object)Main.getPlayer().getDuration());
            this.playerProgressBar.getProgressSlider().maxProperty().unbind();
            this.playerProgressBar.getProgressSlider().maxProperty().bind((ObservableValue)Main.getPlayer().durationProperty());
            this.totalTimeLabel.textProperty().bind(Main.getPlayer().durationProperty().map(duration -> this.playerService.getTimeFormat().format(Instant.ofEpochMilli(duration.longValue()))));
            this.volumeSlider.setValue(100.0);
            Main.getPlayer().logMediaDebugInformation();
        };
        log.debug("Time listeners already added: {}", (Object)Main.getPlayer().doesInterfaceListenToStatusChanges());
        if (Main.getPlayer() instanceof FXPlayer) {
            if (!Main.getPlayer().doesInterfaceListenToStatusChanges()) {
                this.addListenersForFXPlayer();
            }
            log.debug("Player state: {}", Main.getPlayer().stateProperty().get());
            if (Main.getPlayer().stateProperty().getValue() == PlayerState.INITIALIZED || Main.getPlayer().stateProperty().getValue() == PlayerState.NOT_INITIALIZED) {
                log.debug("Player not yet ready, waiting.");
                ((FXPlayer)Main.getPlayer()).getMediaPlayer().setOnReady(onCompleted);
            } else {
                log.debug("Player already ready.");
                onCompleted.run();
            }
        } else {
            if (!Main.getPlayer().doesInterfaceListenToStatusChanges()) {
                this.addListenersForVLCJPlayer();
            }
            Platform.runLater((Runnable)onCompleted);
        }
        if (!Main.getPlayer().doesInterfaceListenToStatusChanges()) {
            this.addGenericPlayerListenersForInterface();
        }
        Main.getPlayer().setInterfaceListensToStatusChanges(true);
        log.debug("Player listeners added.");
    }

    private void addGenericPlayerListenersForInterface() {
        Main.getPlayer().volumeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.doubleValue() <= 1.0) {
                this.volumeSlider.setValue(Utils.round2Places((double)(newValue.doubleValue() * 100.0)));
            } else {
                Main.getPlayer().setVolume(newValue.doubleValue());
            }
        });
        Main.getPlayer().rateProperty().addListener((observable, oldValue, newValue) -> this.speedSlider.setValue(newValue.doubleValue()));
        Main.getPlayer().stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals((Object)PlayerState.STOPPED)) {
                this.playerProgressBar.setValue(0.0);
            }
        });
        Main.getPlayer().stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals((Object)PlayerState.ERROR)) {
                Platform.runLater(() -> {
                    log.warn("PlayerState changed to ERROR.");
                    ETDialog.get((String)Utils.getLocaleBundle().getString("problems.mediaFileNotFound"), (Alert.AlertType)Alert.AlertType.WARNING).showAndWait();
                });
            }
        });
    }

    private void addListenersForVLCJPlayer() {
        log.debug("Adding listeners for vlcj player...");
        VLCJPlayer vlcjPlayer = (VLCJPlayer)Main.getPlayer();
        vlcjPlayer.getMediaPlayer().events().addMediaPlayerEventListener((MediaPlayerEventListener)new /* Unavailable Anonymous Inner Class!! */);
        vlcjPlayer.getTimeProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.playerProgressBar.isValueChanging()) {
                Platform.runLater(() -> this.playerProgressBar.setValue((double)newValue.intValue()));
            }
        });
    }

    private void addListenersForFXPlayer() {
        log.debug("Time Listeners not yet added.");
        if (Main.getPlayer() != null && Main.getPlayer().getMediaPlayer() != null) {
            ((FXPlayer)Main.getPlayer()).getMediaPlayer().currentTimeProperty().addListener((observable, oldValue, newValue) -> {
                if (!this.playerProgressBar.isValueChanging()) {
                    this.playerProgressBar.setValue(newValue.toMillis());
                }
            });
            ((FXPlayer)Main.getPlayer()).getMediaPlayer().setOnEndOfMedia(() -> {
                ((FXPlayer)Main.getPlayer()).getMediaPlayer().stop();
                Main.getPlayer().stateProperty().setValue((Object)PlayerState.STOPPED);
            });
        }
    }

    public void setPlayButtonIcon() {
        this.playButtonSVGPath.setContent("M4.60330263,0.564681692 L32.936636,21.0048625 C34.3544547,22.0277027 34.3544547,23.9722973 32.936636,24.9951375 L4.60330263,45.4353183 C2.74813982,46.7736664 0,45.5825832 0,43.4401808 L0,2.55981915 C0,0.417416835 2.74813982,-0.773666425 4.60330263,0.564681692 ZM4.60330263,0.564681692 L32.936636,21.0048625 C34.3544547,22.0277027 34.3544547,23.9722973 32.936636,24.9951375 L4.60330263,45.4353183 C2.74813982,46.7736664 0,45.5825832 0,43.4401808 L0,2.55981915 C0,0.417416835 2.74813982,-0.773666425 4.60330263,0.564681692 Z");
    }

    public void setPauseButtonIcon() {
        this.playButtonSVGPath.setContent("M 0 2.5 l 0 46 a 2.5 2 0 0 0 8 0 l 0 -46 a 2.5 2 0 0 0 -8 0 M 16 2.5 l 0 46 a 2.5 2 0 0 0 8 0 l 0 -46 a 2.5 2 0 0 0 -8 0");
    }

    private void registerPlayerShortcuts() {
        log.debug("Going to register Player shortcuts.");
        Configuration conf = Configuration.get();
        KeyCombination rewind = conf.getPlayerRewind();
        KeyCombination playpause = conf.getPlayerPlayPause();
        KeyCombination fastForward = conf.getPlayerFastForward();
        KeyCombination faster = conf.getPlayerFaster();
        KeyCombination slower = conf.getPlayerSlower();
        KeyCombination quieter = conf.getPlayerQuieter();
        KeyCombination louder = conf.getPlayerLouder();
        GUIState.getMainStage().getScene().getAccelerators().put((Object)rewind, () -> this.rewind());
        GUIState.getMainStage().getScene().getAccelerators().put((Object)playpause, () -> this.playPause());
        GUIState.getMainStage().getScene().getAccelerators().put((Object)fastForward, () -> this.fastForward());
        GUIState.getMainStage().getScene().getAccelerators().put((Object)slower, () -> this.slower());
        GUIState.getMainStage().getScene().getAccelerators().put((Object)faster, () -> this.faster());
        GUIState.getMainStage().getScene().getAccelerators().put((Object)quieter, () -> this.quieter());
        GUIState.getMainStage().getScene().getAccelerators().put((Object)louder, () -> this.louder());
        log.debug("Registered Player shortcuts.");
    }

    @Generated
    public PlayerBarController(PlayerService playerService, StatusService statusService) {
        this.playerService = playerService;
        this.statusService = statusService;
    }

    @Generated
    public GridPane getPlayerBarVolumeGridPane() {
        return this.playerBarVolumeGridPane;
    }

    @Generated
    public GridPane getPlayerBarSpeedGridPane() {
        return this.playerBarSpeedGridPane;
    }

    @Generated
    public VBox getPlayerBarControlsVBox() {
        return this.playerBarControlsVBox;
    }
}

