/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.player;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerState;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.layout.Pane;

public interface Player {
    public static final String BLACK_BACKGROUND_STYLE = "-fx-background-color: transparent";

    public Pane getPlayerPane();

    public void loadMedia(Path var1) throws FileNotFoundException;

    public void play();

    public void pause();

    public void stop();

    public void release();

    public void rewind(long var1);

    public void fastForward(long var1);

    public long getTime();

    public void setTime(long var1);

    public long getDuration();

    public LongProperty durationProperty();

    public long getDurationOf(Path var1);

    public void setVolume(double var1);

    public void setRate(double var1);

    public ObjectProperty<Path> mediaPathProperty();

    public ObjectProperty<PlayerState> stateProperty();

    public DoubleProperty volumeProperty();

    public IntegerProperty maximumVolumeProperty();

    public DoubleProperty rateProperty();

    public Object getMediaPlayer();

    public boolean isMediaLoaded();

    public boolean doesInterfaceListenToStatusChanges();

    public boolean isVideo();

    public void setInterfaceListensToStatusChanges(boolean var1);

    public void logMediaDebugInformation();

    public Dimension getVideoDimension();

    default public boolean isPlayerReady() {
        PlayerState playerState = (PlayerState)this.stateProperty().get();
        return Main.getPlayer() != null && (playerState.equals((Object)PlayerState.PAUSED) || playerState.equals((Object)PlayerState.LOADED) || playerState.equals((Object)PlayerState.PLAYING) || playerState.equals((Object)PlayerState.STOPPED) || playerState.equals((Object)PlayerState.INITIALIZED));
    }
}

