/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.programsettings;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.validation.RequiredFieldValidator;
import com.jfoenix.validation.base.ValidatorBase;
import com.jthemedetecor.OsThemeDetector;
import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.AutoCompletionService;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.NoDuplicatesTextFieldValidator;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ErrorLabel;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.KeyCombinationTextField;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.TextFormattingControl;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.TimestampFormattingControl;
import eu.ewerkzeug.easytranscript3.commons.types.Channel;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Theme;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TextAreaService;
import eu.ewerkzeug.easytranscript3.mvc.player.PlayerService;
import eu.ewerkzeug.easytranscript3.mvc.player.fx.FXPlayer;
import eu.ewerkzeug.easytranscript3.mvc.player.vlcj.VLCJPlayer;
import eu.ewerkzeug.easytranscript3.mvc.programsettings.ProgramSettingsController;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="programSettingsScreen.fxml")
@Component
@StageTitle(value="%programSettings.Title")
@Lazy
public class ProgramSettingsController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgramSettingsController.class);
    private final AutoCompletionService autoCompletionService;
    private final PlayerService playerService;
    private final StatusService statusService;
    private final Configuration conf = Configuration.get();
    @FXML
    private JFXComboBox<Label> themeComboBox;
    @FXML
    private HBox autosaveDetailsHBox;
    @FXML
    private JFXCheckBox timestampsAtBeginningCheckBox;
    @FXML
    private JFXCheckBox timestampsAtEndCheckBox;
    @FXML
    private TimestampFormattingControl timestampFormattingControl;
    @FXML
    private JFXCheckBox useAutocompletionCheckBox;
    @FXML
    private JFXComboBox<Integer> characterCountSuggestionComboBox;
    @FXML
    private JFXCheckBox autosaveCheckBox;
    @FXML
    private JFXComboBox<Integer> autosaveMinutesComboBox;
    @FXML
    private KeyCombinationTextField rewindTextField;
    @FXML
    private KeyCombinationTextField playPauseTextField;
    @FXML
    private KeyCombinationTextField fastForwardTextField;
    @FXML
    private KeyCombinationTextField quieterTextField;
    @FXML
    private KeyCombinationTextField louderTextField;
    @FXML
    private KeyCombinationTextField slowerTextField;
    @FXML
    private KeyCombinationTextField fasterTextField;
    @FXML
    private JFXCheckBox autoRewindCheckBox;
    @FXML
    private JFXComboBox<String> languageComboBox;
    @FXML
    private JFXCheckBox autoSearchUpdateCheckBox;
    @FXML
    private JFXCheckBox betaUpdatesCheckBox;
    @FXML
    private Button cancelButton;
    @FXML
    private Button applyButton;
    @FXML
    private JFXCheckBox useVLCCheckBox;
    @FXML
    private Label javaBitLabel;
    @FXML
    private Label duplicateEntryLabel;
    @FXML
    private GridPane playerKeysGridPane;
    @FXML
    private JFXCheckBox useLastPlayerPositionCheckBox;
    @FXML
    private JFXCheckBox debugCheckBox;
    @FXML
    private JFXCheckBox useAutoCorrectionCheckBox;
    @FXML
    private JFXTabPane tabPane;
    @FXML
    private TextFormattingControl standardTextFormattingControl;
    @FXML
    private ErrorLabel applyErrorLabel;

    public void initializeController() {
        log.debug("Initializing program settings screen...");
        this.tabPane.getTabs().forEach(tabs -> tabs.setText(tabs.getText().toUpperCase()));
        this.characterCountSuggestionComboBox.visibleProperty().bind((ObservableValue)this.useAutocompletionCheckBox.selectedProperty());
        this.autosaveDetailsHBox.visibleProperty().bind((ObservableValue)this.autosaveCheckBox.selectedProperty());
        this.timestampFormattingControl.visibleProperty().bind((ObservableValue)this.timestampsAtBeginningCheckBox.selectedProperty().or((ObservableBooleanValue)this.timestampsAtEndCheckBox.selectedProperty()));
        this.timestampFormattingControl.managedProperty().bind((ObservableValue)this.timestampsAtBeginningCheckBox.selectedProperty().or((ObservableBooleanValue)this.timestampsAtEndCheckBox.selectedProperty()));
        this.characterCountSuggestionComboBox.getItems().addAll((Object[])new Integer[]{3, 4, 5, 6, 7, 8, 9, 10});
        this.autosaveMinutesComboBox.getItems().addAll((Object[])new Integer[]{3, 5, 7, 10, 15, 20, 30});
        String arch = System.getProperty("os.arch");
        arch = arch.equals("aarch64") ? "Apple Silicon (Arm64)" : (arch.contains("64") ? "64 bit" : "32 bit");
        this.javaBitLabel.setText(arch);
        this.languageComboBox.getItems().addAll((Object[])new String[]{"Deutsch", "English"});
        if ("de".equals(this.conf.getProgramLanguage())) {
            this.languageComboBox.getSelectionModel().select((Object)"Deutsch");
        } else {
            this.languageComboBox.getSelectionModel().select((Object)"English");
        }
        this.autoSearchUpdateCheckBox.setSelected(this.conf.isProgramAutomaticUpdateSearch());
        this.betaUpdatesCheckBox.setSelected(this.conf.getChannel().equals((Object)Channel.BETA));
        ObservableList children = this.playerKeysGridPane.getChildren();
        for (Node c : children) {
            if (!(c instanceof KeyCombinationTextField)) continue;
            KeyCombinationTextField keyCombinationTextField = (KeyCombinationTextField)c;
            NoDuplicatesTextFieldValidator validator = new NoDuplicatesTextFieldValidator();
            validator.setMessage(Utils.getLocaleBundle().getString("drawer.duplicateError"));
            keyCombinationTextField.getValidators().addAll((Object[])new ValidatorBase[]{validator, new RequiredFieldValidator()});
            keyCombinationTextField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    keyCombinationTextField.validate();
                }
            });
        }
        this.themeComboBox.getItems().addAll(Arrays.stream(Theme.values()).filter(theme -> theme != Theme.SYNC_WITH_OS || OsThemeDetector.isSupported()).map(theme -> {
            Label label = new Label(Utils.getLocaleBundle().getString(theme.getLabel()));
            label.setUserData(theme);
            return label;
        }).toList());
        this.applyButton.disableProperty().bind((ObservableValue)this.rewindTextField.activeValidatorProperty().isNotNull().or((ObservableBooleanValue)this.playPauseTextField.activeValidatorProperty().isNotNull()).or((ObservableBooleanValue)this.fastForwardTextField.activeValidatorProperty().isNotNull()).or((ObservableBooleanValue)this.quieterTextField.activeValidatorProperty().isNotNull()).or((ObservableBooleanValue)this.louderTextField.activeValidatorProperty().isNotNull()).or((ObservableBooleanValue)this.slowerTextField.activeValidatorProperty().isNotNull()).or((ObservableBooleanValue)this.fasterTextField.activeValidatorProperty().isNotNull()));
        this.applyErrorLabel.visibleProperty().bind((ObservableValue)this.applyButton.disabledProperty());
    }

    public void cancel() {
        ((Stage)this.cancelButton.getScene().getWindow()).close();
    }

    public void save() {
        log.debug("Saving and applying properties ...");
        try {
            DateTimeFormatter.ofPattern(this.timestampFormattingControl.getTimestampsFormatTextField().getText());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.tabPane.getSelectionModel().select(0);
            ETDialog.get((String)Utils.getLocaleBundle().getString("problems.timestampPatternInvalid")).showAndWait();
            log.warn("Invalid timestamp pattern: " + this.timestampFormattingControl.getTimestampsFormatTextField().getText(), (Throwable)e);
            return;
        }
        this.standardTextFormattingControl.ensureSetFontExists();
        this.conf.setFormattingFont((String)this.standardTextFormattingControl.getTextFontComboBox().getSelectionModel().getSelectedItem());
        this.conf.setFormattingSize(this.standardTextFormattingControl.getFontSizeValue());
        this.conf.setFormattingBold(this.standardTextFormattingControl.getTextBoldToggleButton().isSelected());
        this.conf.setFormattingItalic(this.standardTextFormattingControl.getTextItalicToggleButton().isSelected());
        this.conf.setFormattingUnderlined(this.standardTextFormattingControl.getTextUnderlineToggleButton().isSelected());
        if (this.standardTextFormattingControl.getTextLeftToRightToggleButton().isSelected()) {
            this.conf.setFormattingParagraphAlignment(TextAlignment.LEFT);
        } else if (this.standardTextFormattingControl.getTextRightToLeftToggleButton().isSelected()) {
            this.conf.setFormattingParagraphAlignment(TextAlignment.RIGHT);
        } else if (this.standardTextFormattingControl.getTextCenterToggleButton().isSelected()) {
            this.conf.setFormattingParagraphAlignment(TextAlignment.CENTER);
        } else if (this.standardTextFormattingControl.getTextJustifyToggleButton().isSelected()) {
            this.conf.setFormattingParagraphAlignment(TextAlignment.JUSTIFY);
        }
        this.conf.setTimestampsOnBeginning(this.timestampsAtBeginningCheckBox.isSelected());
        this.conf.setTimestampsOnEnd(this.timestampsAtEndCheckBox.isSelected());
        String oldTimestampFormat = this.conf.getTimestampsFormat();
        this.conf.setTimestampsFormat(this.timestampFormattingControl.getTimestampsFormatTextField().getText());
        this.conf.setAutocompletionActive(this.useAutocompletionCheckBox.isSelected());
        this.conf.setAutoCorrectionActive(this.useAutoCorrectionCheckBox.isSelected());
        this.conf.setAutocompletionThreshold(((Integer)this.characterCountSuggestionComboBox.getSelectionModel().getSelectedItem()).intValue());
        this.conf.setAutosaveActive(this.autosaveCheckBox.isSelected());
        if (this.autosaveCheckBox.isSelected() && this.autosaveMinutesComboBox.getSelectionModel().getSelectedItem() != null) {
            this.conf.setAutosaveInterval(((Integer)this.autosaveMinutesComboBox.getSelectionModel().getSelectedItem()).intValue());
        }
        this.conf.setUseSavedLastPlayerTime(this.useLastPlayerPositionCheckBox.isSelected());
        this.conf.setAutoRewindAfterPause(this.autoRewindCheckBox.isSelected());
        this.conf.setUseVLCPlayer(this.useVLCCheckBox.isSelected());
        this.conf.setPlayerRewind(this.rewindTextField.validateText());
        this.conf.setPlayerPlayPause(this.playPauseTextField.validateText());
        this.conf.setPlayerFastForward(this.fastForwardTextField.validateText());
        this.conf.setPlayerLouder(this.louderTextField.validateText());
        this.conf.setPlayerQuieter(this.quieterTextField.validateText());
        this.conf.setPlayerSlower(this.slowerTextField.validateText());
        this.conf.setPlayerFaster(this.fasterTextField.validateText());
        this.conf.setLogLevel(this.debugCheckBox.isSelected() ? "DEBUG" : "INFO");
        Theme oldTheme = this.conf.getTheme();
        this.conf.setTheme((Theme)((Label)this.themeComboBox.getValue()).getUserData());
        String oldLang = this.conf.getProgramLanguage();
        this.conf.setProgramLanguage(((String)this.languageComboBox.getSelectionModel().getSelectedItem()).substring(0, 2).toLowerCase());
        this.conf.setProgramAutomaticUpdateSearch(this.autoSearchUpdateCheckBox.isSelected());
        this.conf.setChannel(this.betaUpdatesCheckBox.isSelected() ? Channel.BETA : Channel.STABLE);
        this.conf.save();
        if (!oldLang.equals(this.conf.getProgramLanguage())) {
            this.showRestartDialog();
        }
        if (!oldTimestampFormat.equals(this.conf.getTimestampsFormat())) {
            TextAreaService.updateTimestampFormat();
        }
        if (Main.getPlayer() instanceof VLCJPlayer && !this.useVLCCheckBox.isSelected() || Main.getPlayer() instanceof FXPlayer && this.useVLCCheckBox.isSelected()) {
            this.playerService.createPlayer();
            if (this.statusService.isTranscriptLoaded()) {
                this.statusService.setMediaNeedsReload(true);
            }
        }
        if (Transcript.get() != null && this.useAutocompletionCheckBox.isSelected() && Transcript.get().getAutocompletionWords().isEmpty()) {
            this.autoCompletionService.restart();
        }
        if (oldTheme != this.conf.getTheme()) {
            Utils.reapplyTheme();
        }
        ((Stage)this.applyButton.getScene().getWindow()).close();
    }

    private void showRestartDialog() {
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        buttons.add(new ETButtonType(new ButtonType(ButtonType.OK.getText(), ButtonBar.ButtonData.OK_DONE), true, false));
        ButtonType buttonType = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("programSettings.changingTheLanguageNeedsRestartTitle"), (String)Utils.getLocaleBundle().getString("programSettings.changingTheLanguageNeedsRestart"), (Modality)Modality.WINDOW_MODAL, buttons).showAndWait();
    }

    public void reset() {
        log.debug("Opened program settings controller.");
        if (VLCJPlayer.discover()) {
            this.useVLCCheckBox.setDisable(false);
        } else {
            this.useVLCCheckBox.setDisable(true);
            this.useVLCCheckBox.setSelected(false);
        }
        this.standardTextFormattingControl.getTextFontComboBox().getSelectionModel().select((Object)this.conf.getFormattingFont());
        this.standardTextFormattingControl.ensureSetFontExists();
        this.standardTextFormattingControl.setFontSizeValue(this.conf.getFormattingSize());
        this.standardTextFormattingControl.getTextBoldToggleButton().setSelected(this.conf.isFormattingBold());
        this.standardTextFormattingControl.getTextItalicToggleButton().setSelected(this.conf.isFormattingItalic());
        this.standardTextFormattingControl.getTextUnderlineToggleButton().setSelected(this.conf.isFormattingUnderlined());
        switch (1.$SwitchMap$javafx$scene$text$TextAlignment[this.conf.getFormattingParagraphAlignment().ordinal()]) {
            case 1: {
                this.standardTextFormattingControl.getTextLeftToRightToggleButton().setSelected(true);
                break;
            }
            case 2: {
                this.standardTextFormattingControl.getTextRightToLeftToggleButton().setSelected(true);
                break;
            }
            case 3: {
                this.standardTextFormattingControl.getTextCenterToggleButton().setSelected(true);
                break;
            }
            case 4: {
                this.standardTextFormattingControl.getTextJustifyToggleButton().setSelected(true);
            }
        }
        this.timestampsAtBeginningCheckBox.setSelected(this.conf.isTimestampsOnBeginning());
        this.timestampsAtEndCheckBox.setSelected(this.conf.isTimestampsOnEnd());
        this.timestampFormattingControl.getTimestampsFormatTextField().setText(Configuration.get().getTimestampsFormat());
        this.useAutocompletionCheckBox.setSelected(this.conf.isAutocompletionActive());
        this.useAutoCorrectionCheckBox.setSelected(this.conf.isAutoCorrectionActive());
        this.characterCountSuggestionComboBox.getSelectionModel().select((Object)this.conf.getAutocompletionThreshold());
        if (LicenseService.isUserLicenseValid()) {
            this.autosaveCheckBox.setDisable(false);
            this.autosaveMinutesComboBox.setDisable(false);
            this.autosaveCheckBox.setSelected(this.conf.isAutosaveActive());
            this.autosaveMinutesComboBox.getSelectionModel().select((Object)this.conf.getAutosaveInterval());
        } else {
            this.autosaveCheckBox.setDisable(true);
            this.autosaveCheckBox.setSelected(false);
            this.autosaveMinutesComboBox.setDisable(true);
        }
        this.playPauseTextField.setKeyCombinationFieldText(this.conf.getPlayerPlayPause());
        this.rewindTextField.setKeyCombinationFieldText(this.conf.getPlayerRewind());
        this.fastForwardTextField.setKeyCombinationFieldText(this.conf.getPlayerFastForward());
        this.quieterTextField.setKeyCombinationFieldText(this.conf.getPlayerQuieter());
        this.louderTextField.setKeyCombinationFieldText(this.conf.getPlayerLouder());
        this.slowerTextField.setKeyCombinationFieldText(this.conf.getPlayerSlower());
        this.fasterTextField.setKeyCombinationFieldText(this.conf.getPlayerFaster());
        this.autoRewindCheckBox.setSelected(this.conf.isAutoRewindAfterPause());
        this.useVLCCheckBox.setSelected(this.conf.isUseVLCPlayer());
        this.useLastPlayerPositionCheckBox.setSelected(this.conf.isUseSavedLastPlayerTime());
        this.debugCheckBox.setSelected(!this.conf.getLogLevel().equals("INFO"));
        this.themeComboBox.setValue((Object)this.themeComboBox.getItems().stream().filter(item -> item.getUserData() == this.conf.getTheme()).findFirst().orElse((Label)this.themeComboBox.getItems().getFirst()));
    }

    @Generated
    public ProgramSettingsController(AutoCompletionService autoCompletionService, PlayerService playerService, StatusService statusService) {
        this.autoCompletionService = autoCompletionService;
        this.playerService = playerService;
        this.statusService = statusService;
    }

    @Generated
    public TimestampFormattingControl getTimestampFormattingControl() {
        return this.timestampFormattingControl;
    }
}

