/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.timetracking;

import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TimeRecorder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeRecorder.class);
    private LocalDateTime start = null;

    public void start() {
        this.start = LocalDateTime.now();
        log.debug("Started recording.");
    }

    public boolean hasStarted() {
        return this.start != null;
    }

    public TimeTrackingEntry stop() {
        if (this.start == null) {
            log.debug("Time tracking not started.");
            return null;
        }
        TimeTrackingEntry timeTrackingEntry = new TimeTrackingEntry(this.start, LocalDateTime.now());
        this.start = null;
        if (timeTrackingEntry.getDateDiff((TemporalUnit)ChronoUnit.MINUTES) >= 1L) {
            return timeTrackingEntry;
        }
        log.debug("Time tracked is less than a minute. Returning null.");
        return null;
    }

    @Generated
    public LocalDateTime getStart() {
        return this.start;
    }
}

