/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.timetracking;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.io.exporters.ExportUtils;
import eu.ewerkzeug.easytranscript3.commons.types.TimeTrackingEntry;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.main.editor.TranscriptTextArea;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.StatsFeature;
import eu.ewerkzeug.easytranscript3.mvc.timetracking.TimeRecorder;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;
import javafx.util.Duration;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="timeTrackingScreen.fxml")
@Component
@StageTitle(value="%timeTrackingScreen.Title")
@Lazy
public class TimeTrackingController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeTrackingController.class);
    private final ExportUtils exportUtils;
    private final TimeRecorder timeRecorder;
    SimpleDoubleProperty minTranscriptProperty = new SimpleDoubleProperty(0.0);
    SimpleIntegerProperty strokesPerMinuteProperty = new SimpleIntegerProperty(0);
    SimpleLongProperty estimatedRemainingTimeProperty = new SimpleLongProperty(0L);
    SimpleLongProperty totalTimeProperty = new SimpleLongProperty(0L);
    @FXML
    private TableView<TimeTrackingEntry> timeTableView;
    @FXML
    private TableColumn<TimeTrackingEntry, String> startTableColumn;
    @FXML
    private TableColumn<TimeTrackingEntry, String> endTableColumn;
    @FXML
    private TableColumn<TimeTrackingEntry, String> durationTableColumn;
    @FXML
    private StatsFeature minTranscriptMinMediumStatsFeature;
    @FXML
    private StatsFeature strokesPerMinuteStatsFeature;
    @FXML
    private StatsFeature estimatedRemainingTimeStatsFeature;
    @FXML
    private StatsFeature totalTimeStatsFeature;

    public void initializeController() {
        log.debug("Initializing time tracking screen...");
        this.startTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("startProperty"));
        this.endTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("endProperty"));
        this.durationTableColumn.setCellValueFactory((Callback)new PropertyValueFactory("durationProperty"));
        this.startTableColumn.prefWidthProperty().bind((ObservableValue)this.timeTableView.widthProperty().multiply(0.3));
        this.endTableColumn.prefWidthProperty().bind((ObservableValue)this.timeTableView.widthProperty().multiply(0.3));
        this.durationTableColumn.prefWidthProperty().bind((ObservableValue)this.timeTableView.widthProperty().multiply(0.3));
        this.timeTableView.getColumns().forEach(c -> c.setReorderable(false));
        this.timeTableView.getColumns().forEach(c -> c.setSortable(false));
        this.minTranscriptProperty.addListener((observableValue, number, t1) -> {
            if (this.isMediaLoaded()) {
                this.minTranscriptMinMediumStatsFeature.setTitle("" + (int)t1.doubleValue());
            } else {
                this.minTranscriptMinMediumStatsFeature.setTitle("?");
            }
        });
        this.strokesPerMinuteProperty.addListener((observableValue, number, t1) -> this.strokesPerMinuteStatsFeature.setTitle(String.valueOf(t1)));
        this.estimatedRemainingTimeProperty.addListener((observableValue, number, minutes) -> this.estimatedRemainingTimeStatsFeature.setTitle(String.format("%d:%02d", minutes.longValue() / 60L, minutes.longValue() % 60L)));
        this.totalTimeProperty.addListener((observableValue, number, seconds) -> this.totalTimeStatsFeature.setTitle(String.format("%d:%02d:%02d", TimeUnit.SECONDS.toHours(seconds.longValue()), TimeUnit.SECONDS.toMinutes(seconds.longValue()) - TimeUnit.HOURS.toMinutes(TimeUnit.SECONDS.toHours(seconds.longValue())), TimeUnit.SECONDS.toSeconds(seconds.longValue()) - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(seconds.longValue())))));
    }

    public void reset() {
        this.minTranscriptProperty.setValue((Number)0);
        this.totalTimeProperty.setValue((Number)0);
        this.estimatedRemainingTimeProperty.setValue((Number)0);
        this.strokesPerMinuteProperty.setValue((Number)0);
        ArrayList<TimeTrackingEntry> trackedTime = new ArrayList<TimeTrackingEntry>(Transcript.get().getTrackedTime());
        if (this.timeRecorder.hasStarted()) {
            trackedTime.add(new TimeTrackingEntry(this.timeRecorder.getStart(), null));
        }
        this.timeTableView.setItems(FXCollections.observableList(trackedTime));
        long lastTimestamp = Utils.getLastTimestamp();
        long millis = 0L;
        for (TimeTrackingEntry timeTrackingEntry : trackedTime) {
            millis += timeTrackingEntry.getDateDiff((TemporalUnit)ChronoUnit.MILLIS);
        }
        java.time.Duration duration = java.time.Duration.ofMillis(millis);
        int minutesPerMediumMinuteRatio = (int)((double)duration.toMinutes() / ((double)lastTimestamp / 1000.0 / 60.0));
        java.time.Duration minutesPerMediumMinute = java.time.Duration.ofMinutes(minutesPerMediumMinuteRatio);
        if (minutesPerMediumMinute.toMinutes() > 0L && minutesPerMediumMinute.toMinutes() <= 60L) {
            double minTranscriptMinMediumVal = Math.round((double)minutesPerMediumMinute.toSeconds() / 60.0);
            Timeline minTranscriptMinMediumTimeline = this.createTimeline((WritableValue)this.minTranscriptProperty, (Number)minTranscriptMinMediumVal);
            minTranscriptMinMediumTimeline.playFromStart();
        } else {
            this.minTranscriptMinMediumStatsFeature.setTitle("?");
        }
        Timeline totalTimeTimeline = this.createTimeline((WritableValue)this.totalTimeProperty, (Number)duration.toSeconds());
        totalTimeTimeline.playFromStart();
        if (this.isMediaLoaded() && minutesPerMediumMinute.toMinutes() > 0L && lastTimestamp != 0L) {
            long totalDuration = Main.getPlayer().getDuration();
            java.time.Duration remainingDuration = java.time.Duration.ofMillis((totalDuration - lastTimestamp) / 1000L / 60L * (long)minutesPerMediumMinuteRatio);
            Timeline remainingTimeline = this.createTimeline((WritableValue)this.estimatedRemainingTimeProperty, (Number)remainingDuration.toMillis());
            remainingTimeline.playFromStart();
        } else {
            this.estimatedRemainingTimeStatsFeature.setTitle("?");
        }
        long lengthOfText = TranscriptTextArea.get().getLength();
        long strokes = 0L;
        if (duration.toMinutes() > 0L) {
            strokes = lengthOfText / duration.toMinutes();
        }
        if (duration.toMinutes() > 0L && strokes <= 500L) {
            Timeline strokesTimeline = this.createTimeline((WritableValue)this.strokesPerMinuteProperty, (Number)((int)(lengthOfText / duration.toMinutes())));
            strokesTimeline.playFromStart();
        } else {
            this.strokesPerMinuteStatsFeature.setTitle("?");
        }
        this.strokesPerMinuteStatsFeature.setManaged(Transcript.get().isSupportsTimeTrackingEstimates());
        this.strokesPerMinuteStatsFeature.setVisible(Transcript.get().isSupportsTimeTrackingEstimates());
        this.estimatedRemainingTimeStatsFeature.setManaged(Transcript.get().isSupportsTimeTrackingEstimates());
        this.estimatedRemainingTimeStatsFeature.setVisible(Transcript.get().isSupportsTimeTrackingEstimates());
        this.minTranscriptMinMediumStatsFeature.setManaged(Transcript.get().isSupportsTimeTrackingEstimates());
        this.minTranscriptMinMediumStatsFeature.setVisible(Transcript.get().isSupportsTimeTrackingEstimates());
    }

    private boolean isMediaLoaded() {
        return Main.getPlayer() != null && Main.getPlayer().isMediaLoaded() && Main.getPlayer().getDuration() > 0L;
    }

    public void print() {
        log.debug("Printing time tracking entries ...");
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null && job.showPrintDialog(this.timeTableView.getScene().getWindow())) {
            boolean success = job.printPage((Node)this.timeTableView);
            if (success) {
                job.endJob();
            } else {
                ETDialog.get((String)Utils.getLocaleBundle().getString("problems.cannotPrint")).showAndWait();
            }
        }
    }

    public void export() {
        this.exportUtils.showExportDialog((List)Transcript.get().getTrackedTime());
    }

    private Timeline createTimeline(WritableValue<Number> writableValue, Number number) {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue kv = new KeyValue(writableValue, (Object)number, Interpolator.EASE_BOTH);
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.seconds((double)2.0), new KeyValue[]{kv}));
        return timeline;
    }

    @Generated
    public TimeTrackingController(ExportUtils exportUtils, TimeRecorder timeRecorder) {
        this.exportUtils = exportUtils;
        this.timeRecorder = timeRecorder;
    }
}

