/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.GenerationState;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.SpeakerFileEntry;
import eu.ewerkzeug.easytranscript3.mvc.transcript.createtranscript.ValidationUtils;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.model.TransferException;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDeletionService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTDialogService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.utils.STTUtils;
import eu.ewerkzeug.easytranscript3.networking.license.LicenseInvalidException;
import eu.ewerkzeug.easytranscript3.networking.license.service.LicenseService;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

@Service
public class JobCreationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobCreationService.class);
    private final STTService sttService;
    private final STTStatusService sttStatusService;
    private final STTDeletionService sttDeletionService;
    private final STTDialogService sttDialogService;
    private final LicenseService licenseService;
    private final StatusService statusService;

    @NotNull
    private static Person getPerson(SpeakerFileEntry entry) {
        Person speaker = new Person();
        String name = entry.getSpeakerNameTextField().getText().trim();
        if (name.isEmpty()) {
            name = "Person 1";
        }
        if (name.contains(" ")) {
            speaker.setFirstname(name.substring(0, name.lastIndexOf(" ")));
            speaker.setLastname(name.substring(name.lastIndexOf(" ") + 1));
        } else {
            speaker.setFirstname(name);
        }
        speaker.setUuid(UUID.randomUUID().toString());
        speaker.setMediaPath(Path.of(entry.getMediaPathLabel().getText(), new String[0]));
        speaker.getProperties().setStartOffset(entry.getDurationPicker().getDuration().toMillis());
        return speaker;
    }

    public Mono<Tuple2<Boolean, Boolean>> canCreateAutomaticTranscript(AutomaticTranscriptCreationInfo meta, long totalSize) {
        if (!LicenseService.isUserLicenseValid()) {
            this.licenseService.showLicenseNotValidDialog();
            return Mono.error((Throwable)new LicenseInvalidException("License not valid."));
        }
        if (ValidationUtils.isTranscriptLocationNotWritable((Path)meta.getTranscriptLocation().getParent())) {
            return Mono.error((Throwable)new IOException("Not writable"));
        }
        if (this.checkIfCurrentlyUpOrDownloading()) {
            return Mono.error((Throwable)new TransferException("Currently transfer in progress.", 0));
        }
        Mono tooBig = this.sttService.getMaxUploadSize().map(maxUploadSize -> totalSize > maxUploadSize);
        return Mono.zip((Mono)tooBig, (Mono)this.isAutomaticTranscriptionAlreadyRunning());
    }

    private boolean checkIfCurrentlyUpOrDownloading() {
        ETDialog dialog = STTDialogService.createUploadDownloadCancelAlert((boolean)this.sttStatusService.isDownloading(), (boolean)this.sttStatusService.isUploading());
        if (dialog != null) {
            ButtonType buttonType = dialog.showAndWait();
            if (buttonType != ButtonType.YES) {
                return true;
            }
            this.sttDeletionService.cancelAllOngoingTransfers();
        }
        return false;
    }

    private Mono<Boolean> isAutomaticTranscriptionAlreadyRunning() {
        return this.sttService.getJobStatus().doOnError(e -> {
            log.error("Got error when trying to get job status.", e);
            String title = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToGetStatusTitle");
            String content = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToGetStatus");
            this.showSimpleDialog(title, content);
        }).map(res -> {
            log.info("Result: {}", res);
            return res.getBody() != null && GenerationState.isTranscriptGenerationInProgress((GenerationState)((AutomaticTranscriptStatus)res.getBody()).getStatus());
        });
    }

    ButtonType showAlreadyRunningWarning() {
        log.debug("Transcription job already exists. Showing cancel dialog ...");
        ETButtonType yesButtonType = new ETButtonType(ButtonType.YES, false, true);
        return ETDialog.createDialog((String)Utils.getLocaleBundle().getString("createTranscriptScreen.projectAlreadyRunningTitle"), (String)Utils.getLocaleBundle().getString("createTranscriptScreen.projectAlreadyRunning"), (Modality)Modality.APPLICATION_MODAL, Arrays.asList(yesButtonType, new ETButtonType(ButtonType.NO, true, false))).showAndWait();
    }

    public Mono<ResponseEntity<Void>> deleteAutomaticTranscriptionJob() {
        return this.sttDeletionService.deleteTranscriptionJob().doOnError(WebClientResponseException.class, e -> {
            log.error("", (Throwable)e);
            if (e.getStatusCode().value() == HttpStatus.UNAUTHORIZED.value()) {
                this.sttDialogService.showUnauthorizedError();
            } else if (e.getStatusCode().value() >= 400 && e.getStatusCode().value() < 500) {
                this.showSimpleDialog(Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToDeleteProjectTitle"), Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToDeleteProject"));
            } else {
                Utils.showGenericResponseServerErrorDialog();
            }
        }).doOnError(WebClientRequestException.class, e -> Utils.showGenericRequestErrorDialog());
    }

    Mono<String> createAutomaticTranscriptionJob(AutomaticTranscriptCreationInfo meta) {
        log.debug("Creating automatic transcription job ...");
        this.statusService.setShowProgressForSaving(true);
        return this.sttService.createAutomaticTranscriptionJob(meta).flatMap(arg_0 -> this.handleAutomaticTranscriptionJobCreationErrorCases(arg_0)).doOnError(WebClientResponseException.class, e -> {
            log.error("Could not create job because of an unknown reason.", (Throwable)e);
            Utils.showGenericResponseServerErrorDialog();
            this.sttStatusService.resetCurrentProcess();
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
        }).doOnError(WebClientRequestException.class, e -> {
            log.error("Could not create job because of an unknown reason.", (Throwable)e);
            Utils.showGenericRequestErrorDialog();
            this.sttStatusService.resetCurrentProcess();
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
        }).doOnError(Exception.class, e -> {
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
            this.sttStatusService.resetCurrentProcess();
        }).doOnNext(uuid -> {
            this.statusService.setSaving(false);
            this.statusService.setShowProgressForSaving(false);
            if (uuid == null) {
                log.error("Creation of transcription job failed.");
            } else {
                log.info("Created transcription job {}", uuid);
                try {
                    meta.setUuid(uuid);
                    this.sttStatusService.startUploadOfMediaFiles();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    throw e;
                }
            }
        });
    }

    private Mono<String> handleAutomaticTranscriptionJobCreationErrorCases(ResponseEntity<String> response) {
        if (response == null || response.getStatusCode().value() >= 500) {
            Utils.showGenericResponseServerErrorDialog();
            this.sttStatusService.resetCurrentProcess();
        } else if (response.getStatusCode().value() == HttpStatus.BAD_REQUEST.value()) {
            log.error("Transcription job already exists. Showing cancel dialog ...");
            String title = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle");
            String content = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectGenericClientError");
            this.showSimpleDialog(title, content);
            this.sttStatusService.resetCurrentProcess();
        } else if (response.getStatusCode().value() == HttpStatus.UNAUTHORIZED.value()) {
            this.sttDialogService.showUnauthorizedError();
            this.sttStatusService.resetCurrentProcess();
        } else if (response.getStatusCode().value() == HttpStatus.TOO_MANY_REQUESTS.value()) {
            String title = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectTitle");
            String content = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToCreateProjectAlreadyRunning");
            this.showSimpleDialog(title, content);
            this.sttStatusService.resetCurrentProcess();
        }
        if (response == null || !response.getStatusCode().is2xxSuccessful()) {
            log.error("Could not create job: " + (response != null ? response.getStatusCode().toString() : "-1"));
            return Mono.empty();
        }
        return Mono.justOrEmpty((Object)((String)response.getBody()));
    }

    long calculateCombinedSize(AutomaticTranscriptCreationInfo meta) {
        long totalSize = 0L;
        for (Person p : meta.getPersons()) {
            try {
                FileChannel imageFileChannel = FileChannel.open(p.getMediaPath(), new OpenOption[0]);
                try {
                    totalSize += imageFileChannel.size();
                }
                finally {
                    if (imageFileChannel == null) continue;
                    imageFileChannel.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to read media file for calculating total size.", (Throwable)e);
                this.showSimpleDialog(Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToReadMediaFile"));
                return -1L;
            }
        }
        return totalSize;
    }

    @NotNull
    List<Person> getAllPersons(VBox addedFilesAutomaticVBox) {
        return addedFilesAutomaticVBox.getChildren().stream().map(SpeakerFileEntry.class::cast).filter(e -> !ValidationUtils.mediaFileDoesNotExist((Path)Path.of(e.getMediaPathLabel().getText(), new String[0]))).map(JobCreationService::getPerson).toList();
    }

    @NotNull
    Set<String> getDictionaryWords(GridPane dictionaryGridPane) {
        return dictionaryGridPane.getChildren().stream().filter(TextField.class::isInstance).map(TextField.class::cast).map(TextInputControl::getText).filter(text -> !text.isBlank()).collect(Collectors.toSet());
    }

    void showTooBigError(long totalSize, Long maxSize) {
        log.warn("Selected media files are too big to be uploaded ({}, allowed: {}).", (Object)totalSize, (Object)maxSize);
        String content = Utils.getLocaleBundle().getString("automaticTranscriptionStatus.quotaExceededBeforeUploading");
        MessageFormat formatter = new MessageFormat(content, Utils.getLocaleBundle().getLocale());
        Platform.runLater(() -> ETDialog.createDialog((String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.failedToUploadTitle"), (String)formatter.format(new Object[]{STTUtils.humanReadableByteCountSI((long)totalSize), STTUtils.humanReadableByteCountSI((long)maxSize)}), (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    private void showSimpleDialog(String title, String content) {
        Platform.runLater(() -> ETDialog.createDialog((String)title, (String)content, (Modality)Modality.APPLICATION_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    @Generated
    public JobCreationService(STTService sttService, STTStatusService sttStatusService, STTDeletionService sttDeletionService, STTDialogService sttDialogService, LicenseService licenseService, StatusService statusService) {
        this.sttService = sttService;
        this.sttStatusService = sttStatusService;
        this.sttDeletionService = sttDeletionService;
        this.sttDialogService = sttDialogService;
        this.licenseService = licenseService;
        this.statusService = statusService;
    }
}

