/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.transcript.importtranscript;

import eu.ewerkzeug.easytranscript3.Main;
import eu.ewerkzeug.easytranscript3.StageTitle;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.SpacedText;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.TimestampFormattingControl;
import eu.ewerkzeug.easytranscript3.commons.io.LoadTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.SaveTranscriptService;
import eu.ewerkzeug.easytranscript3.commons.io.importers.DocumentImporter;
import eu.ewerkzeug.easytranscript3.commons.io.importers.Importer;
import eu.ewerkzeug.easytranscript3.commons.io.importers.TXTImporter;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.commons.types.Transcript;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.StatusService;
import eu.ewerkzeug.easytranscript3.mvc.main.CloseDialog;
import eu.ewerkzeug.easytranscript3.mvc.transcript.TranscriptCreationUIHelperService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import lombok.Generated;
import net.rgielen.fxweaver.core.FxmlView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@FxmlView(value="importScreen.fxml")
@Component
@StageTitle(value="%importScreen.Title")
@Lazy
public class ImportTranscriptController
extends ExtendedController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportTranscriptController.class);
    private final TranscriptCreationUIHelperService transcriptCreationUIHelperService;
    private final SaveTranscriptService saveTranscriptService;
    private final TXTImporter fallbackTXTImporter;
    private final List<DocumentImporter> documentImporterList;
    private final StatusService statusService;
    private final CloseDialog closeDialog;
    private final LoadTranscriptService loadTranscriptService;
    private final Pattern dateFormatSymbolsPattern = Pattern.compile(".*[GyMdkHmsSEDFwWahKzZYuXL].*");
    public Label vlcIntegrationManualLabel;
    public SpacedText mediaLocationSpacedText;
    @FXML
    private Button finishButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button mediaFileButton;
    @FXML
    private Button timestampHelpButton;
    @FXML
    private Button documentFileButton;
    @FXML
    private Button createTranscriptButton;
    @FXML
    private CheckBox importTimestampsCheckbox;
    @FXML
    private HBox timestampHBox;
    @FXML
    private Label transcriptPathLabel;
    @FXML
    private Label documentPathLabel;
    @FXML
    private Label mediaPathLabel;
    @FXML
    private GridPane mediaPathGridPane;
    @FXML
    private GridPane documentPathGridPane;
    @FXML
    private GridPane transcriptPathGridPane;
    @FXML
    private TimestampFormattingControl timestampFormattingControl;

    public void initializeController() {
        log.debug("Initializing import transcript screen...");
        this.mediaPathLabel.textProperty().addListener((observable, oldValue, newValue) -> this.transcriptCreationUIHelperService.updateGridPanesOfTranscriptPropertyScreen(newValue, this.mediaPathGridPane));
        this.transcriptPathLabel.textProperty().addListener((observable, oldValue, newValue) -> this.transcriptCreationUIHelperService.updateGridPanesOfTranscriptPropertyScreen(newValue, this.transcriptPathGridPane));
        this.documentPathLabel.textProperty().addListener((observable, oldValue, newValue) -> this.transcriptCreationUIHelperService.updateGridPanesOfTranscriptPropertyScreen(newValue, this.documentPathGridPane));
        this.mediaFileButton.setText(this.mediaFileButton.getText() + " \u203a");
        this.createTranscriptButton.setText(this.createTranscriptButton.getText() + " \u203a");
        this.documentFileButton.setText(this.documentFileButton.getText() + " \u203a");
        this.vlcIntegrationManualLabel.managedProperty().bind((ObservableValue)Configuration.get().useVLCPlayerProperty().not());
        this.vlcIntegrationManualLabel.visibleProperty().bind((ObservableValue)Configuration.get().useVLCPlayerProperty().not());
        VBox.setMargin((Node)this.mediaLocationSpacedText, (Insets)new Insets(0.0, 0.0, Configuration.get().isUseVLCPlayer() ? 30.0 : 15.0, 0.0));
        this.timestampHBox.managedProperty().bind((ObservableValue)this.documentPathLabel.textProperty().isEmpty().not());
        this.timestampHBox.visibleProperty().bind((ObservableValue)this.documentPathLabel.textProperty().isEmpty().not());
        this.timestampFormattingControl.visibleProperty().bind((ObservableValue)this.importTimestampsCheckbox.selectedProperty());
        ChangeListener changeListener = (observable, newVal, oldVal) -> Platform.runLater(() -> {
            double pos = this.getStage().getY();
            double oldHeight = this.getStage().getHeight();
            log.info("Size of scene after change: " + this.getStage().getScene().getHeight());
            this.getStage().sizeToScene();
            this.getStage().setMinHeight(Math.max(this.getStage().getMinHeight(), this.getStage().getHeight()));
            double heightDiff = this.getStage().getHeight() - oldHeight;
            this.getStage().setY(pos -= heightDiff / 2.0);
        });
        this.finishButton.disableProperty().bind((ObservableValue)this.transcriptPathLabel.textProperty().isEmpty().or((ObservableBooleanValue)this.mediaPathLabel.textProperty().isEmpty()).or((ObservableBooleanValue)this.documentPathLabel.textProperty().isEmpty()));
        this.timestampHBox.visibleProperty().addListener(changeListener);
    }

    public void reset() {
        this.mediaPathLabel.setText("");
        this.documentPathLabel.setText("");
        this.transcriptPathLabel.setText("");
        this.importTimestampsCheckbox.setSelected(false);
        this.timestampFormattingControl.getTimestampsFormatTextField().setText(Configuration.get().getTimestampsFormat());
        Platform.runLater(() -> {
            this.getStage().setMinHeight(0.0);
            this.getStage().sizeToScene();
            this.getStage().setMinHeight(this.getStage().getHeight());
            this.getStage().centerOnScreen();
        });
    }

    public void finish() {
        this.closeDialog.showAndWait(false, () -> this.createManualTranscript());
    }

    public void createManualTranscript() {
        DocumentImporter suitableImporter;
        List<DocumentImporter> suitableImporterList;
        File file;
        log.debug("Finished importing transcript...");
        Transcript.get().reset(new Transcript());
        if (!this.transcriptPathLabel.getText().endsWith(".ett") && !this.transcriptPathLabel.getText().isBlank()) {
            this.transcriptPathLabel.setText(this.transcriptPathLabel.getText() + ".ett");
        }
        if (!(file = Path.of(this.documentPathLabel.getText(), new String[0]).toFile()).exists()) {
            ETDialog.get((String)Utils.getLocaleBundle().getString("importScreen.documentDoesNotExist")).showAndWait();
            return;
        }
        file = Path.of(this.mediaPathLabel.getText(), new String[0]).toFile();
        if (!file.exists()) {
            ETDialog.get((String)Utils.getLocaleBundle().getString("problems.mediaFileNotFound")).showAndWait();
            return;
        }
        file = Path.of(this.transcriptPathLabel.getText(), new String[0]).getParent().toFile();
        if (!file.exists() || !file.isDirectory()) {
            ETDialog.get((String)Utils.getLocaleBundle().getString("problems.locationOfTranscriptDoesNotExist")).showAndWait();
            return;
        }
        Transcript.get().setMediaLocation(Path.of(this.mediaPathLabel.getText(), new String[0]));
        Transcript.get().setTranscriptLocation(Path.of(this.transcriptPathLabel.getText(), new String[0]));
        Transcript.get().setSupportsTimeTrackingEstimates(false);
        log.debug("Importing transcript...");
        this.statusService.setShowProgressForSaving(true);
        this.saveTranscriptService.setOnFailed(event -> {
            log.error("Failed to save", event.getSource().getException());
            ExceptionAlert.get().showModal();
            this.statusService.setShowProgressForSaving(false);
        });
        this.saveTranscriptService.setOnSucceeded(event -> {
            this.statusService.setShowProgressForSaving(false);
            this.saveTranscriptService.setOnSucceeded(null);
            if (Files.exists(Transcript.get().getTranscriptLocation(), new LinkOption[0])) {
                this.loadTranscriptService.openTranscript(Transcript.get().getTranscriptLocation());
            } else {
                log.error("Newly created transcript does not exist.");
                ExceptionAlert.get().showModal();
            }
            this.close();
            this.saveTranscriptService.setOnSucceeded(null);
        });
        String timestampFormat = "";
        if (this.importTimestampsCheckbox.isSelected()) {
            timestampFormat = this.timestampFormattingControl.getTimestampsFormatTextField().getText();
        }
        if (!(suitableImporterList = this.documentImporterList.stream().filter(f -> f.getFilter().getExtensions().contains("*." + this.documentPathLabel.getText().substring(this.documentPathLabel.getText().lastIndexOf(".") + 1))).toList()).isEmpty()) {
            suitableImporter = suitableImporterList.getFirst();
        } else {
            log.warn("No suitable importer found. Going to import as plain text.");
            suitableImporter = this.fallbackTXTImporter;
        }
        if (this.importTimestampsCheckbox.isSelected()) {
            try {
                DateTimeFormatter.ofPattern(timestampFormat);
                if (timestampFormat.trim().isEmpty()) {
                    throw new NullPointerException("String contains only whitespace");
                }
                if (!this.dateFormatSymbolsPattern.matcher(timestampFormat).matches()) {
                    throw new IllegalArgumentException("Pattern does not contain any date format symbols.");
                }
            }
            catch (IllegalArgumentException | NullPointerException e) {
                ETDialog.get((String)Utils.getLocaleBundle().getString("problems.timestampPatternInvalid")).showAndWait();
                log.warn("Invalid timestamp pattern: {}. Cause: {}", (Object)this.timestampFormattingControl.getTimestampsFormatTextField().getText(), (Object)e.getMessage());
                return;
            }
        }
        try {
            log.info("Importing document {} with importer {}", (Object)this.documentPathLabel.getText(), (Object)suitableImporter.getClass().getName());
            suitableImporter.importTranscript(Path.of(this.documentPathLabel.getText(), new String[0]), timestampFormat);
            this.saveTranscriptService.save(Transcript.get(), Transcript.get().getDocument(), false, false, true, false);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            ETDialog.get((String)(Utils.getLocaleBundle().getString("problems.cannotRead") + "\n\n" + Utils.getLocaleBundle().getString("general.error") + ": " + e.getLocalizedMessage()), (Alert.AlertType)Alert.AlertType.ERROR).showAndWait();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ExceptionAlert.get().showModal();
        }
    }

    public void close() {
        ((Stage)this.cancelButton.getScene().getWindow()).close();
    }

    public void setImportLocation() {
        Stage stage = (Stage)this.documentPathLabel.getScene().getWindow();
        FileChooser fileChooser = new FileChooser();
        if (Main.getRecentOpenedFileChooserPath() != null) {
            fileChooser.setInitialDirectory(Main.getRecentOpenedFileChooserPath());
        }
        fileChooser.getExtensionFilters().clear();
        StringBuilder descriptionBuilder = new StringBuilder();
        descriptionBuilder.append(Utils.getLocaleBundle().getString("importScreen.allDocuments")).append(" (");
        ArrayList extensions = new ArrayList();
        this.documentImporterList.forEach(f -> {
            descriptionBuilder.append(String.join((CharSequence)", ", f.getFilter().getExtensions())).append(", ");
            extensions.addAll(f.getFilter().getExtensions());
        });
        descriptionBuilder.delete(descriptionBuilder.length() - 2, descriptionBuilder.length() - 1).append(")");
        FileChooser.ExtensionFilter allExtensionFilters = new FileChooser.ExtensionFilter(descriptionBuilder.toString(), extensions);
        fileChooser.getExtensionFilters().add((Object)allExtensionFilters);
        fileChooser.getExtensionFilters().addAll(this.documentImporterList.stream().map(Importer::getFilter).toList());
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            this.documentPathLabel.setText(file.toString());
        }
    }

    public void setMediaFile() {
        String media = TranscriptCreationUIHelperService.openMediaFile((Stage)((Stage)this.documentPathLabel.getScene().getWindow()));
        if (!media.isEmpty()) {
            this.mediaPathLabel.setText(media);
        }
    }

    public void setTranscriptLocation() {
        this.transcriptCreationUIHelperService.setTranscriptLocation(this.transcriptPathLabel, true);
    }

    @Generated
    public ImportTranscriptController(TranscriptCreationUIHelperService transcriptCreationUIHelperService, SaveTranscriptService saveTranscriptService, TXTImporter fallbackTXTImporter, List<DocumentImporter> documentImporterList, StatusService statusService, CloseDialog closeDialog, LoadTranscriptService loadTranscriptService) {
        this.transcriptCreationUIHelperService = transcriptCreationUIHelperService;
        this.saveTranscriptService = saveTranscriptService;
        this.fallbackTXTImporter = fallbackTXTImporter;
        this.documentImporterList = documentImporterList;
        this.statusService = statusService;
        this.closeDialog = closeDialog;
        this.loadTranscriptService = loadTranscriptService;
    }
}

