/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.mvc.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import javafx.concurrent.Task;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTask
extends Task<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadTask.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final URL downloadURL;
    private final Path localInstallerTmpPath;
    private InputStream downloadInputStream;

    public DownloadTask(URL downloadURL, Path localInstallerTmpPath) {
        this.downloadURL = downloadURL;
        this.localInstallerTmpPath = localInstallerTmpPath;
    }

    protected Void call() throws Exception {
        log.debug("Starting to download update: {}", (Object)this.downloadURL.toString());
        this.updateProgress(-1.0, 100.0);
        try {
            URLConnection urlConnection = this.downloadURL.openConnection();
            urlConnection.connect();
            int fileSize = urlConnection.getContentLength();
            log.debug("FileSize of update: " + fileSize);
            if (fileSize < 100) {
                throw new IOException("Update file seems to be damaged.");
            }
            try (FileOutputStream output = FileUtils.openOutputStream((File)this.localInstallerTmpPath.toFile());){
                int n;
                byte[] buffer = new byte[4096];
                long count = 0L;
                this.downloadInputStream = this.downloadURL.openStream();
                while (-1 != (n = this.downloadInputStream.read(buffer))) {
                    if (this.isCancelled()) {
                        break;
                    }
                    output.write(buffer, 0, n);
                    this.updateProgress((count += (long)n) / 1000L, (long)(fileSize / 1000));
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to download binary.", (Throwable)e);
            throw e;
        }
        return null;
    }

    @Generated
    public InputStream getDownloadInputStream() {
        return this.downloadInputStream;
    }
}

