/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.model;

import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import javafx.beans.property.SimpleLongProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferProgressInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransferProgressInfo.class);
    private final ObservableList<String> completedUploads = FXCollections.observableArrayList();
    private final ObservableList<Long> writtenPerSecond = FXCollections.observableArrayList();
    private long writtenPerSecondTmp = 0L;
    private long transferred = 0L;
    private Date secondsDate = new Date();
    private long totalLength = 0L;
    SimpleLongProperty etaFromGenerationServer = new SimpleLongProperty(0L);

    public void resetStats() {
        log.debug("Resetting transfer progress info stats.");
        this.writtenPerSecondTmp = 0L;
        this.transferred = 0L;
        this.secondsDate = new Date();
        this.totalLength = 0L;
        this.writtenPerSecond.clear();
        this.completedUploads.clear();
        this.etaFromGenerationServer.set(-1L);
    }

    public void calculateTotalLength() throws IOException {
        AutomaticTranscriptCreationInfo automaticTranscriptCreationInfo = AutomaticTranscriptCreationInfo.get();
        for (Path p : automaticTranscriptCreationInfo.getPersons().stream().map(Person::getMediaPath).toList()) {
            this.totalLength += Files.size(p);
        }
    }

    public SimpleLongProperty etaFromGenerationServerProperty() {
        return this.etaFromGenerationServer;
    }

    public void setEtaFromGenerationServer(long etaFromGenerationServer) {
        this.etaFromGenerationServer.set(etaFromGenerationServer);
    }

    @Generated
    public ObservableList<String> getCompletedUploads() {
        return this.completedUploads;
    }

    @Generated
    public ObservableList<Long> getWrittenPerSecond() {
        return this.writtenPerSecond;
    }

    @Generated
    public long getWrittenPerSecondTmp() {
        return this.writtenPerSecondTmp;
    }

    @Generated
    public void setWrittenPerSecondTmp(long writtenPerSecondTmp) {
        this.writtenPerSecondTmp = writtenPerSecondTmp;
    }

    @Generated
    public long getTransferred() {
        return this.transferred;
    }

    @Generated
    public void setTransferred(long transferred) {
        this.transferred = transferred;
    }

    @Generated
    public Date getSecondsDate() {
        return this.secondsDate;
    }

    @Generated
    public void setSecondsDate(Date secondsDate) {
        this.secondsDate = secondsDate;
    }

    @Generated
    public long getTotalLength() {
        return this.totalLength;
    }

    @Generated
    public void setTotalLength(long totalLength) {
        this.totalLength = totalLength;
    }
}

