/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.automatictranscription.websocket;

import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptCreationInfo;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.AutomaticTranscriptStatus;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.GenerationState;
import eu.ewerkzeug.easytranscript3.commons.types.automatictranscript.Person;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTStatusService;
import eu.ewerkzeug.easytranscript3.networking.automatictranscription.service.STTWebSocketService;
import java.lang.reflect.Type;
import java.util.Collections;
import javafx.application.Platform;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.ConnectionLostException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;

public class StompSessionHandler
extends StompSessionHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StompSessionHandler.class);
    private final String uuid;
    private final STTStatusService statusService;
    private final STTWebSocketService sttWebSocketService;
    private StompSession.Subscription subscription;
    private StompSession session;
    private int currentPerson = 0;

    public void afterConnected(StompSession session, @NotNull StompHeaders connectedHeaders) {
        log.info("Connected to websocket.");
        log.debug("Subscribing ...");
        this.session = session;
        this.subscription = session.subscribe("/topic/projects/" + this.uuid, (StompFrameHandler)this);
        this.statusService.setReconnectTriesLeft(3);
        AutomaticTranscriptStatus automaticTranscriptStatus = (AutomaticTranscriptStatus)this.statusService.getLatestStatus().get();
        if (automaticTranscriptStatus != null && automaticTranscriptStatus.getUuid().equals(this.uuid)) {
            this.handleFrame(connectedHeaders, (Object)automaticTranscriptStatus);
        }
    }

    public void handleTransportError(@NotNull StompSession stompSession, @NotNull Throwable throwable) {
        log.error("", throwable);
        if (throwable instanceof ConnectionLostException) {
            log.error("Client has lost connection to WS server.");
            this.statusService.setReconnectTriesLeft(this.statusService.getReconnectTriesLeft() - 1);
            if (this.statusService.getReconnectTriesLeft() > 0) {
                log.info("Reconnecting to websocket ({} retry) ...", (Object)(3 - this.statusService.getReconnectTriesLeft()));
                this.sttWebSocketService.connectToWebSocket(this.uuid);
            } else {
                this.showLostConnectionDialog();
            }
        } else {
            this.showLostConnectionDialog();
        }
    }

    public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable exception) {
        log.error("", exception);
    }

    private void showLostConnectionDialog() {
        Platform.runLater(() -> ETDialog.createDialog((String)Utils.getLocaleBundle().getString("exceptionAlert.Title"), (String)Utils.getLocaleBundle().getString("automaticTranscriptionStatus.connectionLost"), (Modality)Modality.WINDOW_MODAL, Collections.singletonList(new ETButtonType(ButtonType.OK, true, false))).showAndWait());
    }

    @NotNull
    public Type getPayloadType(@NotNull StompHeaders stompHeaders) {
        return AutomaticTranscriptStatus.class;
    }

    public void handleFrame(@NotNull StompHeaders stompHeaders, Object o) {
        AutomaticTranscriptStatus p = (AutomaticTranscriptStatus)o;
        this.statusService.getLatestStatus().set((Object)p);
        if (p == null) {
            log.error("Received frame is empty.");
            return;
        }
        log.info("Status from STT: {}", (Object)p);
        this.statusService.getTransferProgressInfo().setEtaFromGenerationServer((long)p.getEta());
        if (p.getCurrentPerson() > this.currentPerson) {
            if (this.currentPerson < 0) {
                log.error("Unexpected ID for current person.");
            } else {
                this.statusService.getTransferProgressInfo().getCompletedUploads().add((Object)((Person)AutomaticTranscriptCreationInfo.get().getPersons().get(this.currentPerson)).getUuid());
            }
            this.currentPerson = p.getCurrentPerson();
        }
        if (p.getStatus().equals((Object)GenerationState.ERROR) || p.getStatus().equals((Object)GenerationState.FINISHED)) {
            log.debug("Unsubscribing. Status: {}", (Object)p.getStatus());
            this.subscription.unsubscribe();
            this.session.disconnect();
        }
        if (p.getStatus().equals((Object)GenerationState.ERROR)) {
            log.error("Transcript generation failed.");
            this.statusService.resetCurrentProcess();
            Utils.showGenericResponseServerErrorDialog();
        } else if (p.getStatus().equals((Object)GenerationState.FINISHED)) {
            log.info("Transcript generation finished.");
            this.statusService.startDownloadOfTranscript();
        }
    }

    @Generated
    public StompSessionHandler(String uuid, STTStatusService statusService, STTWebSocketService sttWebSocketService) {
        this.uuid = uuid;
        this.statusService = statusService;
        this.sttWebSocketService = sttWebSocketService;
    }
}

