/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.license.service;

import com.kstruct.gethostname4j.Hostname;
import eu.ewerkzeug.easytranscript3.GUIState;
import eu.ewerkzeug.easytranscript3.SpringBootJavaFxApplication;
import eu.ewerkzeug.easytranscript3.commons.AESUtil;
import eu.ewerkzeug.easytranscript3.commons.CredentialsUtils;
import eu.ewerkzeug.easytranscript3.commons.Utils;
import eu.ewerkzeug.easytranscript3.commons.fx.FXUtils;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETButtonType;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ETDialog;
import eu.ewerkzeug.easytranscript3.commons.fx.alerts.ExceptionAlert;
import eu.ewerkzeug.easytranscript3.commons.fx.controls.ETPopOver;
import eu.ewerkzeug.easytranscript3.commons.types.Configuration;
import eu.ewerkzeug.easytranscript3.migrations.manualmigrations.V3_1_0_BETA_1__Auth_flow_Migration;
import eu.ewerkzeug.easytranscript3.mvc.ExtendedController;
import eu.ewerkzeug.easytranscript3.mvc.license.LicenseController;
import eu.ewerkzeug.easytranscript3.networking.license.model.DeviceInformation;
import eu.ewerkzeug.easytranscript3.networking.license.model.UserLicense;
import eu.ewerkzeug.easytranscript3.networking.license.service.NTPService;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SignatureException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Modality;
import javafx.stage.Window;
import javax.security.auth.login.AccountExpiredException;
import javax0.license3j.License;
import javax0.license3j.io.LicenseReader;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LicenseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseService.class);
    public static final String LICENSE_PATH = Configuration.ET_HOME + "/.license.bin";
    public static final String X_DEVICE_ID_HEADER = "X-Device-ID";
    private static final HashMap<String, Disposable> disposableHashMap = new HashMap();
    private static final SimpleBooleanProperty loading = new SimpleBooleanProperty(true);
    private static final String FIXED_LICENSE_KEY_USER = "licensekeylogin";
    private static UserLicense userLicense;
    private static Pair<String, String> licenseCredentials;
    private static ETPopOver pleaseWaitPopOver;
    private final byte[] key = new byte[]{82, 83, 65, 0, 48, -126, 2, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 2, 15, 0, 48, -126, 2, 10, 2, -126, 2, 1, 0, -51, -34, 4, 100, 18, 57, -91, 80, -126, 63, -74, 84, 92, -122, 71, -87, -44, 67, -86, 109, -16, 11, -51, 54, 3, 97, -109, -105, 53, -70, -26, -93, 45, 40, 59, 15, -7, -107, -79, 126, -95, -3, 46, 14, -81, -36, 117, -100, -99, 96, 113, -85, -19, -119, -113, -65, -69, -101, -69, -88, 113, -126, 59, -38, 77, -59, 89, 60, 107, -14, 37, -85, -115, 109, -98, -72, 12, -33, 30, 109, 56, -13, 71, -29, -103, -123, 105, 105, -19, -6, -128, -98, -23, 52, 124, -107, -47, 66, -99, 112, 70, -119, 118, 109, 110, -94, 62, 52, 6, 13, -102, 42, -69, -80, 46, -77, 87, -49, -34, -7, 51, 68, 52, -96, 66, -44, -99, -61, -88, -47, 125, 36, 61, 32, -64, -111, -79, -101, -75, 4, 95, -69, -71, -122, 65, 30, -114, 20, -94, 24, -102, 73, -82, -36, 40, 15, -87, -100, 110, -57, 25, 39, -9, 67, 10, 8, 61, 63, -33, -90, 20, 99, -124, 109, -116, 36, 125, -65, 108, -24, 52, 46, 50, 114, 20, 61, -81, -120, 6, -91, -114, -92, -101, -11, 96, 94, -75, -128, -26, -52, -52, 116, -111, 110, 53, -71, -70, -107, 116, -122, -112, 103, 69, -85, -28, 96, 39, -96, -126, -55, 50, -101, 13, 65, -105, -45, 84, -66, 68, 115, 82, 3, 41, -86, -80, -14, 90, -45, -112, -96, -33, -97, 73, 8, -102, -66, 116, -25, 25, -74, 53, -84, 62, -10, -119, -31, 48, -31, 106, 72, 84, 45, 61, -51, 18, -29, -37, -6, -95, 27, 121, 114, 101, 85, 76, -53, 89, -100, -121, 52, 24, 87, 76, -50, -67, 28, 71, -16, 72, 114, -53, -49, 74, 87, -26, -32, -102, 89, -100, 50, 10, -33, -13, 70, 73, 68, 14, -56, 62, -40, 125, -9, 115, -81, 2, -45, 71, -40, -86, -106, 48, -97, -46, -10, 90, 114, 10, -8, -23, 71, 106, -122, -121, 90, -64, 86, 110, 43, -126, -26, 62, -50, 53, 21, 21, 56, 1, -51, 95, -86, -17, 97, -4, 25, 21, -74, -117, 55, 76, -127, -63, -112, -112, -8, 1, 92, 37, -56, 72, 108, 91, -35, 103, 74, -37, 93, 39, -12, 12, 33, 33, -94, -85, 106, 88, -12, -88, 27, -76, -87, 95, 87, 112, -122, -122, -83, 115, -49, -31, 103, -57, 42, -118, -88, -55, 26, 11, 20, 9, 40, 60, -93, -1, -68, -63, -61, 106, -110, -112, -39, -106, 98, 82, 87, -51, -12, 73, 60, -16, -3, 99, -54, 86, -15, -112, 105, 107, -119, 8, 54, -96, 95, -18, -34, 57, 101, -113, -32, -80, 25, -80, -1, -24, 35, -80, 108, 23, -75, 89, -121, -46, 95, 57, -99, 102, 102, -16, 45, 52, 57, -55, -29, 95, -42, 107, 16, -17, 84, -26, 29, -27, 63, -82, -76, 69, -22, -10, 39, 0, -56, -90, 10, -27, 11, -89, -101, -32, 27, -82, -108, -5, 5, 107, 57, -56, 33, -60, -53, -7, -31, -16, 3, 2, 3, 1, 0, 1};
    WebClient webClient;
    @Value(value="${easytranscript.license-server-url}")
    private String licenseServerUrl;
    private boolean trialDialogShown = false;
    private ETDialog trialDialog;

    public static void deleteLocalLicense() throws IOException {
        log.debug("Removing license...");
        Files.deleteIfExists(Path.of(LICENSE_PATH, new String[0]));
        LicenseService.clearCredentials();
        userLicense = null;
        licenseCredentials = null;
        log.info("Removed license.");
    }

    public static boolean isUserLicenseValid() {
        log.debug("Checking if user license is valid.");
        if (userLicense == null) {
            log.warn("User License is null!");
            return false;
        }
        log.debug("Expiry date is: {}", (Object)userLicense.getExpiryDate());
        log.debug("Received date is: {}", (Object)userLicense.getReceivedDate());
        log.debug("Maximum offline duration is: {}", (Object)userLicense.getMaxOfflineDuration());
        boolean notExpired = LicenseService.isLicenseNotExpired();
        boolean receivedBeforeCurrentDate = LicenseService.isReceivedDateBeforeCurrentDate();
        boolean offsetTolerable = NTPService.isOffsetTolerable();
        boolean offlineTimeTolerable = LicenseService.isOfflineDurationTolerable();
        if (!notExpired) {
            log.warn("User license has expired.");
        }
        if (userLicense.getReceivedDate() != null) {
            if (!receivedBeforeCurrentDate) {
                log.warn("Received date of license is after current date!");
            }
            if (!offlineTimeTolerable) {
                log.warn("User has been offline for longer than {} days ({} ms)", (Object)(userLicense.getMaxOfflineDuration() / 1000L / 60L / 60L / 24L), (Object)userLicense.getMaxOfflineDuration());
            }
        } else {
            log.warn("No received date found!");
        }
        if (!offsetTolerable) {
            log.warn("System clock offset is {}, too big!", (Object)NTPService.getLatestOffset());
        }
        boolean returner = notExpired && offsetTolerable && offlineTimeTolerable;
        log.debug("License is{}valid.", (Object)(returner ? " " : " not "));
        return returner;
    }

    private static Date getReceivedWithTolerance() {
        return new Date(userLicense.getReceivedDate().getTime() - Math.max(0L, NTPService.getLatestOffset()));
    }

    private static boolean isReceivedDateBeforeCurrentDate() {
        return userLicense.getReceivedDate() != null && !LicenseService.getReceivedWithTolerance().after(new Date());
    }

    private static boolean isLicenseNotExpired() {
        return userLicense.getExpiryDate() == null || userLicense.getExpiryDate().after(new Date());
    }

    private static boolean isOfflineDurationTolerable() {
        return new Date(LicenseService.getReceivedWithTolerance().getTime() + userLicense.getMaxOfflineDuration()).after(new Date());
    }

    public static Pair<String, String> getLicenseCredentials() {
        if (licenseCredentials != null) {
            return licenseCredentials;
        }
        log.debug("Loading license credentials...");
        try {
            byte[] credentials = CredentialsUtils.getCredentials();
            if (credentials != null) {
                licenseCredentials = (Pair)AESUtil.decrypt((byte[])credentials);
                log.debug("Credentials loaded.");
                return licenseCredentials;
            }
            log.info("Could not read credentials, byte array is null.");
        }
        catch (Exception e) {
            log.error("Could not decrypt credentials.", (Throwable)e);
        }
        return null;
    }

    public static boolean showLicenseNotValidDialog(boolean showDialogIfLicenseMissing) {
        ButtonType result;
        if (showDialogIfLicenseMissing && loading.get()) {
            if (pleaseWaitPopOver == null) {
                pleaseWaitPopOver = ETPopOver.showSnackbar((String)Utils.getLocaleBundle().getString("general.pleaseWaitLicenseTitle"), (String)Utils.getLocaleBundle().getString("general.pleaseWaitLicense"), (Duration)Duration.ofSeconds(5L));
            } else {
                pleaseWaitPopOver.show();
            }
            return false;
        }
        log.debug("Showing license not valid dialog.");
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType toShop = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("licenseScreen.goToShop"), ButtonBar.ButtonData.HELP), false, false);
        ETButtonType enterLicense = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("licenseScreen.enterLicense"), ButtonBar.ButtonData.NEXT_FORWARD), true, true);
        buttons.add(toShop);
        buttons.add(enterLicense);
        ETDialog etDialog = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("general.licenseNeeded"), (String)"", (Modality)Modality.WINDOW_MODAL, buttons);
        if (userLicense == null) {
            log.debug("Reason: user license is null.");
            etDialog.setText(Utils.getLocaleBundle().getString("general.licenseNeededDetails"));
            if (!showDialogIfLicenseMissing) {
                return false;
            }
        } else if (!LicenseService.isLicenseNotExpired()) {
            log.debug("Reason: user license is expired.");
            try {
                LicenseService.deleteLocalLicense();
            }
            catch (IOException e) {
                log.error("Could not delete license.", (Throwable)e);
            }
            etDialog.setText(Utils.getLocaleBundle().getString("general.licenseExpiredDetails"));
        } else if (!NTPService.isOffsetTolerable() || !LicenseService.isReceivedDateBeforeCurrentDate()) {
            log.debug("Reason: system clock is not set correctly.");
            log.debug("NTP Time offset tolerable: {}", (Object)NTPService.isOffsetTolerable());
            log.debug("Offset: {}", (Object)NTPService.getLatestOffset());
            log.debug("Received Date before current date: {}", (Object)LicenseService.isReceivedDateBeforeCurrentDate());
            etDialog.setText(Utils.getLocaleBundle().getString("general.clockNotSetCorrectly"));
        } else if (!LicenseService.isOfflineDurationTolerable()) {
            log.debug("Reason: User has been offline for too long.");
            etDialog.setText(Utils.getLocaleBundle().getString("licenseScreen.revalidationNeeded"));
        }
        if ((result = etDialog.showAndWait()) != null && result == toShop.getButtonType()) {
            LicenseService.goToShop();
            return true;
        }
        if (result != null && result == enterLicense.getButtonType()) {
            FXUtils.findOpenWindowByController(LicenseController.class).ifPresent(Window::hide);
            ExtendedController extendedController = GUIState.getController().showAdditionalScreen(LicenseController.class, Modality.WINDOW_MODAL, false);
            extendedController.getStage().hide();
            extendedController.getStage().show();
            return true;
        }
        return false;
    }

    public static void goToShop() {
        SpringBootJavaFxApplication.getApplication().getHostServices().showDocument("https://easytranscript.de");
    }

    public static void clearCredentials() {
        log.debug("Clearing credentials...");
        try {
            CredentialsUtils.clearCredentials();
        }
        catch (IOException e) {
            log.error("Could not clear credentials.", (Throwable)e);
        }
        log.info("Cleared credentials.");
    }

    private static void doAfterLicenseRequest() {
        V3_1_0_BETA_1__Auth_flow_Migration.deleteToken();
    }

    private static Consumer<HttpHeaders> getAuthTokenHeadersConsumer() {
        HashMap authTokenHeaders = LicenseService.getAuthTokenHeaders();
        if (authTokenHeaders == null) {
            return null;
        }
        return headers -> {
            for (Map.Entry authHeader : authTokenHeaders.entrySet()) {
                headers.add((String)authHeader.getKey(), (String)authHeader.getValue());
            }
        };
    }

    @Nullable
    private static HashMap<String, String> getAuthTokenHeaders() {
        return V3_1_0_BETA_1__Auth_flow_Migration.getAuthTokenHeaders();
    }

    public void saveCredentials(String username, String password) {
        log.debug("Saving credentials.");
        licenseCredentials = new ImmutablePair((Object)username, (Object)password);
        try {
            CredentialsUtils.storeCredentials((byte[])AESUtil.encrypt((Serializable)licenseCredentials));
            log.info("Credentials saved/updated.");
        }
        catch (IOException e) {
            log.error("Could not write credentials.", (Throwable)e);
        }
    }

    public void saveLicenseKey(String licenseKey) {
        log.debug("Saving license key.");
        this.saveCredentials("licensekeylogin", licenseKey);
    }

    @PostConstruct
    public void setup() {
        log.debug("License server url is {}.", (Object)this.licenseServerUrl);
        HttpClient httpClient = (HttpClient)HttpClient.create().resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
        this.webClient = WebClient.builder().baseUrl(this.licenseServerUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
    }

    public boolean showLicenseNotValidDialog() {
        return LicenseService.showLicenseNotValidDialog((boolean)true);
    }

    public void loadLicenseFromDisk() throws SignatureException, AccountExpiredException, IOException {
        log.debug("Loading license from disk...");
        if (!Files.exists(Paths.get(LICENSE_PATH, new String[0]), new LinkOption[0])) {
            log.info("No license saved on disk.");
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(LICENSE_PATH);){
            LicenseReader licenseReader = new LicenseReader((InputStream)new ByteArrayInputStream(IOUtils.toByteArray((InputStream)fileInputStream)));
            License license = licenseReader.read();
            licenseReader.close();
            log.info("Loaded license from disk.");
            if (!license.isOK(this.key)) {
                log.error("License is not valid!");
                userLicense = null;
                throw new SignatureException("License is not valid!");
            }
            userLicense = new UserLicense();
            userLicense.setAllowedNumber(license.get("allowedNumber").getInt());
            if (license.get("expiryDate") != null) {
                userLicense.setExpiryDate(license.get("expiryDate").getDate());
            }
            userLicense.setFirstname(license.get("firstname").getString());
            userLicense.setLastname(license.get("lastname").getString());
            if (license.get("company") != null) {
                userLicense.setCompany(license.get("company").getString());
            }
            if (license.get("sttEnabled") != null) {
                userLicense.setSttEnabled(license.get("sttEnabled").getByte() != 0);
            }
            userLicense.setReceivedDate(license.get("receivedDate").getDate());
            userLicense.setMaxOfflineDuration(license.get("maxOfflineDuration").getLong());
            if (license.get("username") != null) {
                userLicense.setUsername(license.get("username").getString());
            }
            if (!LicenseService.isUserLicenseValid()) {
                log.error("User License is not valid!");
                throw new AccountExpiredException("User License is not valid!");
            }
        }
        catch (IOException e) {
            log.error("Could not read license", (Throwable)e);
            userLicense = null;
            throw e;
        }
    }

    public void showLicenseActivatedDialog() {
        ETDialog.get((String)Utils.getLocaleBundle().getString("licenseScreen.licenseActivatedTitle"), (String)Utils.getLocaleBundle().getString("licenseScreen.licenseActivated")).showAndWait();
        if (this.trialDialog != null) {
            this.trialDialog.getStage().hide();
        }
    }

    public void showTrialVersionDialog() {
        if (this.trialDialogShown) {
            return;
        }
        log.info("Showing trial version dialog ...");
        ArrayList<ETButtonType> buttons = new ArrayList<ETButtonType>();
        ETButtonType toShop = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("licenseScreen.goToShop"), ButtonBar.ButtonData.APPLY), false, false);
        ETButtonType enterLicense = new ETButtonType(new ButtonType(Utils.getLocaleBundle().getString("licenseScreen.enterLicense"), ButtonBar.ButtonData.APPLY), false, false);
        ETButtonType okButton = new ETButtonType(ButtonType.OK, true, true);
        buttons.add(toShop);
        buttons.add(enterLicense);
        buttons.add(okButton);
        this.trialDialog = ETDialog.createDialog((String)Utils.getLocaleBundle().getString("licenseScreen.thisIsATestVersionTitle"), (String)Utils.getLocaleBundle().getString("licenseScreen.thisIsATestVersion"), (Modality)Modality.WINDOW_MODAL, buttons);
        this.trialDialog.getStage().toFront();
        this.trialDialogShown = true;
        ButtonType buttonType = this.trialDialog.showAndWait();
        if (buttonType != null) {
            if (buttonType == toShop.getButtonType()) {
                LicenseService.goToShop();
            } else if (buttonType == enterLicense.getButtonType()) {
                GUIState.getController().showAdditionalScreen(LicenseController.class, Modality.WINDOW_MODAL, false);
            }
        }
        this.trialDialog = null;
    }

    public Mono<ResponseEntity<ByteArrayResource>> getLicenseFromServer(boolean sendMail) throws NullPointerException {
        log.debug("Getting license from Server...");
        DeviceInformation deviceInformation = LicenseService.getDeviceInformation();
        return CredentialsUtils.executeAuthenticated(headers -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/users/easytranscript?sendMail=" + sendMail, new Object[0])).headers(headers)).body((Publisher)Mono.just((Object)deviceInformation), DeviceInformation.class).retrieve().toEntity(ByteArrayResource.class)).onErrorResume(f -> {
            WebClientResponseException ex;
            if (f instanceof WebClientResponseException && ((ex = (WebClientResponseException)f).getStatusCode().value() == HttpStatus.TOO_MANY_REQUESTS.value() || ex.getStatusCode().value() == HttpStatus.UNAUTHORIZED.value())) {
                try {
                    LicenseService.deleteLocalLicense();
                    if (!sendMail) {
                        Platform.runLater(() -> ETDialog.get((String)Utils.getLocaleBundle().getString("problems.credentialsInvalidOrLicenseActivated")).showAndWait());
                    }
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                    ExceptionAlert.get().showModal();
                }
            }
            return Mono.error((Throwable)f);
        }).doFinally(signalType -> LicenseService.doAfterLicenseRequest());
    }

    @NotNull
    private static DeviceInformation getDeviceInformation() {
        DeviceInformation deviceInformation = new DeviceInformation();
        deviceInformation.setLang(Configuration.get().getProgramLanguage());
        deviceInformation.setDeviceName(Hostname.getHostname());
        deviceInformation.setOs(System.getProperty("os.name"));
        deviceInformation.setVersion(Configuration.get().getVersion().toString());
        return deviceInformation;
    }

    public Mono<Long> getBalanceInSeconds() throws NullPointerException {
        log.debug("Getting balance from Server...");
        DeviceInformation deviceInformation = LicenseService.getDeviceInformation();
        return CredentialsUtils.executeAuthenticated(headers -> ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/users/easytranscript/balance", new Object[0])).headers(headers)).body((Publisher)Mono.just((Object)deviceInformation), DeviceInformation.class).retrieve().bodyToMono(Long.class)).doOnSuccess(balance -> log.info("Balance: {}", balance));
    }

    public void writeByteArrayLicense(byte[] byteArray) {
        log.debug("Writing license bytes ...");
        log.debug("Path: {}", (Object)LICENSE_PATH);
        if (byteArray != null) {
            try {
                Path path = Path.of(LICENSE_PATH, new String[0]);
                Files.write(path, byteArray, new OpenOption[0]);
                Utils.markAsHidden((Path)path);
                log.info("Wrote bytes of license.");
            }
            catch (IOException e) {
                log.error("Could not write license.", (Throwable)e);
            }
        } else {
            log.error("Response Body was empty when loading license.");
        }
    }

    public Mono<ResponseEntity<Void>> logout() {
        log.debug("Logging user out ...");
        Consumer headers = CredentialsUtils.getAuthHeadersForFullAuthenticationConsumer();
        if (headers == null) {
            return Mono.error(NullPointerException::new);
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/logout", new Object[0])).headers(headers)).bodyValue((Object)"").retrieve().toBodilessEntity();
    }

    @Generated
    public static HashMap<String, Disposable> getDisposableHashMap() {
        return disposableHashMap;
    }

    @Generated
    public static SimpleBooleanProperty getLoading() {
        return loading;
    }

    @Generated
    public static UserLicense getUserLicense() {
        return userLicense;
    }
}

