/*
 * Decompiled with CFR 0.152.
 */
package eu.ewerkzeug.easytranscript3.networking.license.service;

import java.io.IOException;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NTPService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NTPService.class);
    private static final NumberFormat numberFormat = new DecimalFormat("0.00");
    private static long latestOffset = 0L;
    private static long offsetTolerance = 1800000L;

    private NTPService() {
    }

    public static void getNTPTime() {
        Long offset;
        log.debug("Getting ntp time...");
        NTPUDPClient client = new NTPUDPClient();
        client.setDefaultTimeout(Duration.of(10L, ChronoUnit.SECONDS));
        try {
            log.debug("Opening connection...");
            client.open();
            InetAddress hostAddr = InetAddress.getByName("pool.ntp.org");
            TimeInfo info = client.getTime(hostAddr);
            log.debug("Computing details...");
            info.computeDetails();
            offset = info.getOffset();
            if (offset == null) {
                offset = -1L;
            }
        }
        catch (IOException e) {
            log.error("Error while getting time.", (Throwable)e);
            offset = 0L;
        }
        latestOffset = offset;
        log.debug("Time offset is: {} ms", (Object)offset);
        client.close();
    }

    public static boolean isOffsetTolerable() {
        return latestOffset < offsetTolerance;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NTPService)) {
            return false;
        }
        NTPService other = (NTPService)o;
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NTPService;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "NTPService()";
    }

    @Generated
    public static long getLatestOffset() {
        return latestOffset;
    }

    @Generated
    public static long getOffsetTolerance() {
        return offsetTolerance;
    }
}

